/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class DeployFilteredAction
extends Action {
    StructuredSelection m_sel = null;

    public DeployFilteredAction(TableViewer tv) {
        super("TriggerSelectedDeploymentsAction");
        this.setId("triggerselecteddeploymentsaction");
        this.setText("Trigger selected Deployment");
        if (Repository.getInstance().getRights(1008) < 3 || tv == null) {
            this.setEnabled(false);
            return;
        }
        this.m_sel = (StructuredSelection)tv.getSelection();
        if (this.m_sel == null || this.m_sel.isEmpty()) {
            this.setEnabled(false);
        } else if (this.m_sel.size() > 1) {
            this.setText("Trigger selected Deployments");
        }
    }

    public void run() {
        if (!this.isEnabled() || this.m_sel == null || this.m_sel.isEmpty()) {
            return;
        }
        LinkedList<String> m_selectedAssignments = new LinkedList<String>();
        for (Assignment asn : this.m_sel) {
            m_selectedAssignments.add(asn.getID());
        }
        if (m_selectedAssignments.size() > 0) {
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "trigger deployments for " + m_selectedAssignments.size() + " selected elements");
            }
            ServerClient sc = ServerClient.triggerDelayedDeploymentsFiltered(m_selectedAssignments.toArray(new String[0]));
            Repository.getJobManager().schedule(sc);
        }
    }
}

