/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISharedImages;

public class DupliactePolicyAction
extends Action {
    private TreeViewer m_treeViewer = null;
    private ArrayList<GroupTreeObjectLast> m_elements = null;
    private GroupTreeObjectUnsubmitted m_gtolNew = null;
    private String m_name = null;
    private String m_type = null;

    public DupliactePolicyAction(TreeViewer treeViewer) {
        super("duplicatePolicy");
        this.setText("Duplicate Policy");
        this.setId("duplicated_Policy");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
        } else {
            this.m_elements = new ArrayList();
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    GroupTreeObjectLast gtol;
                    if (!(selected instanceof GroupTreeObjectLast) || (gtol = (GroupTreeObjectLast)selected) instanceof GroupTreeObjectUnsubmitted) continue;
                    this.m_elements.add(gtol);
                }
            }
        }
        if (this.m_elements == null || this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Duplicate Policies");
        }
    }

    public DupliactePolicyAction(String name, String type) {
        super("duplicatePolicy");
        this.setText("Duplicate Policy");
        this.setId("duplicated_Policy");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
        } else {
            this.m_name = name;
            this.m_type = type;
            this.m_treeViewer = PolicyListView.getInstance().getTreeViewer();
        }
        if (this.m_name == null || this.m_type == null || !this.m_type.equals(BMUI.type_mon) && !this.m_type.equals(BMUI.type_msg)) {
            this.setEnabled(false);
        }
    }

    public void run() {
        PolicyManager pm = PolicyManager.getInstance();
        boolean isOk = false;
        if (this.m_elements != null && this.m_elements.size() > 0) {
            int i = 0;
            while (i < this.m_elements.size()) {
                File fileP;
                GroupTreeObjectLast gtoLast = this.m_elements.get(i);
                RTLogger.print(5, "Duplicate Policy ...");
                String type = gtoLast.getTreeObject().getType();
                if (type.equals(BMUI.type_mon)) {
                    isOk = true;
                    fileP = Repository.getInstance().fetchFile(gtoLast.getName(), type);
                    Policy p = pm.getMonitorPolicy(fileP);
                    Policy pCopy = Policy.getCopy(p);
                    this.m_gtolNew = new GroupTreeObjectUnsubmitted(new TreeObject(pCopy.getName(), BMUI.type_mon, pCopy), null, "IMAGE_MON");
                    gtoLast.getParent().addElement(this.m_gtolNew);
                    PolicyView.showNewPolicyTab(pCopy, this.m_treeViewer, this.m_gtolNew, true);
                    PolicyManager.getInstance().addUnsubmitted(this.m_gtolNew, gtoLast.getParentPath());
                } else if (type.equals(BMUI.type_msg)) {
                    isOk = true;
                    fileP = Repository.getInstance().fetchFile(gtoLast.getName(), type);
                    MsgPolicy mp = pm.getMessagePolicy(fileP);
                    MsgPolicy mpCopy = MsgPolicy.getCopy(mp);
                    this.m_gtolNew = new GroupTreeObjectUnsubmitted(new TreeObject(mpCopy.getName(), BMUI.type_msg, mpCopy), null, "IMAGE_MSG");
                    gtoLast.getParent().addElement(this.m_gtolNew);
                    PolicyView.showNewPolicyTab(mpCopy, this.m_treeViewer, this.m_gtolNew, true);
                    PolicyManager.getInstance().addUnsubmitted(this.m_gtolNew, gtoLast.getParentPath());
                }
                ++i;
            }
        } else if (this.m_name != null && this.m_type != null) {
            File fileP;
            MsgPolicy mp;
            if (this.m_type.equals(BMUI.type_mon)) {
                File fileP2 = Repository.getInstance().fetchFile(this.m_name, this.m_type);
                Policy p = pm.getMonitorPolicy(fileP2);
                if (p != null) {
                    Policy pCopy = Policy.getCopy(p);
                    this.m_gtolNew = new GroupTreeObjectUnsubmitted(new TreeObject(pCopy.getName(), BMUI.type_mon, pCopy), null, "IMAGE_MON");
                    this.addNewPolicyToTree(pCopy, this.m_gtolNew);
                    isOk = true;
                }
            } else if (this.m_type.equals(BMUI.type_msg) && (mp = pm.getMessagePolicy(fileP = Repository.getInstance().fetchFile(this.m_name, this.m_type))) != null) {
                MsgPolicy mpCopy = MsgPolicy.getCopy(mp);
                this.m_gtolNew = new GroupTreeObjectUnsubmitted(new TreeObject(mpCopy.getName(), BMUI.type_msg, mpCopy), null, "IMAGE_MSG");
                this.addNewPolicyToTree(mpCopy, this.m_gtolNew);
                isOk = true;
            }
        }
        if (isOk) {
            Object[] expanded = this.m_treeViewer.getExpandedElements();
            this.m_treeViewer.refresh();
            int index = 0;
            while (index < expanded.length) {
                this.m_treeViewer.setExpandedState(expanded[index], true);
                ++index;
            }
        } else {
            new ShowMessageBox("Duplicate Policy", "Error duplicating the Policy!", 1);
        }
    }

    private void addNewPolicyToTree(Object polCopy, GroupTreeObjectUnsubmitted gtolNew) {
        GroupTreeObject root = PolicyManager.getInstance().getPolicyTree();
        GroupTreeObjectLast gtoLast = root.findElement(this.m_name, this.m_type);
        if (gtoLast != null) {
            gtoLast.getParent().addElement(gtolNew);
            PolicyView.showNewPolicyTab(polCopy, this.m_treeViewer, gtolNew, true);
            PolicyManager.getInstance().addUnsubmitted(gtolNew, gtoLast.getParentPath());
        }
    }

    public GroupTreeObjectUnsubmitted getUnsubmittedGTO() {
        return this.m_gtolNew;
    }
}

