/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISharedImages;

public class DuplicateActionAction
extends Action {
    private TreeViewer m_treeViewer = null;
    private ArrayList<GroupTreeObjectLast> m_elements = new ArrayList();

    public DuplicateActionAction(TreeViewer treeViewer) {
        super("DuplicateActionAction");
        this.setText("Duplicate Action");
        this.setId("duplicateAction");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1007) < 3 || treeViewer == null) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        if (sel != null && sel.size() > 0) {
            this.m_elements.ensureCapacity(sel.size());
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
                if (Repository.getInstance().getRights(gtol.getParent().getName()) != 3) continue;
                this.m_elements.add(gtol);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Duplicate Actions");
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObjectLast gtol = this.m_elements.get(i);
            try {
                com.blixx.shared.Action action = (com.blixx.shared.Action)gtol.getTreeObject().getObject();
                com.blixx.shared.Action actionCopy = action.clone();
                GroupTreeObjectUnsubmitted gtolU = new GroupTreeObjectUnsubmitted(new TreeObject(actionCopy.m_label, gtol.getTreeObject().getType(), actionCopy), null, gtol.getIcon());
                gtol.getParent().addElement(gtolU);
                Object[] expanded = this.m_treeViewer.getExpandedElements();
                this.m_treeViewer.refresh();
                int index = 0;
                while (index < expanded.length) {
                    this.m_treeViewer.setExpandedState(expanded[index], true);
                    ++index;
                }
                ActionView.displayAction(actionCopy, gtol.getParent().getName(), gtol.getParent(), gtolU, true);
            }
            catch (RuntimeException e) {
                RTLogger.print(5, "", e);
            }
            ++i;
        }
    }
}

