/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.AttributeFilterDialog;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class EditAttributeFilterAction
extends Action {
    private ServerFilterView m_sfv = null;
    private ForwardFilter m_ff = null;

    public EditAttributeFilterAction(ServerFilterView sfv, ForwardFilter ff, TableViewer tv) {
        super("EditAttributeFilter");
        StructuredSelection ssel;
        this.setId("editattributefilter");
        this.setText("Edit Filter");
        this.m_sfv = sfv;
        if (Repository.getInstance().getRights(1009) < 3 || this.m_sfv == null) {
            this.setEnabled(false);
            return;
        }
        if (ff != null) {
            this.m_ff = ff;
        } else if (tv != null && !(ssel = (StructuredSelection)tv.getSelection()).isEmpty()) {
            this.m_ff = (ForwardFilter)ssel.getFirstElement();
        }
        if (this.m_ff == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled() || this.m_ff == null) {
            return;
        }
        AttributeFilterDialog ffd = new AttributeFilterDialog(this.m_sfv.m_parent.getShell(), this.m_ff);
        ffd.setBlockOnOpen(true);
        ffd.open();
        if (ffd.getReturnCode() == 0) {
            Properties p = new Properties();
            p.setProperty("NAME", ffd.m_name);
            p.setProperty("DESCRIPTION", ffd.m_description);
            p.setProperty("ATTRIBUTE", ffd.m_attribute);
            p.setProperty("PATTERN", ffd.m_pattern);
            p.setProperty("FILTER_NUMBER", "" + this.m_ff.getNumber());
            ForwardFilter ff = ForwardFilter.getInstance(p);
            ArrayList<ForwardFilter> fList = new ArrayList<ForwardFilter>();
            fList.add(ff);
            FFilterManager.getInstance().addFFilters(fList);
            this.m_sfv.refreshAttributeFilterTab(ff);
            this.updateFPolicies(ff);
            this.updateServerAndUserTabs(ff);
        }
    }

    public void updateFPolicies(ForwardFilter ff) {
        ArrayList<ForwardPolicy> fpList = FPolicyManager.getInstance().getAllForwardPolicies();
        int i = 0;
        while (i < fpList.size()) {
            ForwardPolicy fp = fpList.get(i);
            if (fp.m_filters.contains(ff.getNumber())) {
                fp.updateFilter(ff);
            }
            ++i;
        }
    }

    public void updateServerAndUserTabs(ForwardFilter ff) {
        ForwardPolicy currentPol_user = ServerFilterUsersTab.getInstance().getCurrentPolicy();
        ForwardPolicy currentPol_server = ServerFilterView.getInstance().getCurrentPolicy();
        FPolicyManager fPolicyManager = FPolicyManager.getInstance();
        ArrayList<ForwardPolicy> fpList = fPolicyManager.getAllForwardPolicies();
        int i = 0;
        while (i < fpList.size()) {
            ForwardPolicy fp = fpList.get(i);
            if (fp.m_filters.contains(ff.getNumber())) {
                String originalPolName;
                fp.updateFilter(ff);
                if (fp.equals(currentPol_server)) {
                    if (ServerFilterView.getInstance().isDirty()) {
                        originalPolName = ServerFilterView.getInstance().getOriginalPolName();
                        fPolicyManager.saveForwardPolicy(fp, originalPolName, false);
                    }
                    ServerFilterView.getInstance().updateAttrFilterList(fp);
                } else if (fp.equals(currentPol_user)) {
                    if (ServerFilterUsersTab.getInstance().isDirty()) {
                        originalPolName = ServerFilterUsersTab.getInstance().getOriginalPolName();
                        fPolicyManager.saveForwardPolicy(fp, originalPolName, false);
                    }
                    ServerFilterUsersTab.getInstance().updateAttrFilterList(fp);
                }
            }
            ++i;
        }
    }
}

