/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.shared.IODataStream;
import com.blixx.shared.sc.CMDS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class EnableDisableHostAction
extends Action {
    private String m_action = null;
    private List<AgentCard> m_agentCards = new ArrayList<AgentCard>();

    public EnableDisableHostAction(List<AgentCard> agentCards, String action) {
        super("Disable Agent");
        this.setId("EndableDisableHost");
        this.m_agentCards = new ArrayList<AgentCard>(agentCards);
        this.m_action = action;
        if (agentCards == null || agentCards.size() == 0) {
            this.setEnabled(false);
            return;
        }
        if (agentCards.size() == 1 && this.m_action == null) {
            AgentCard ac = agentCards.get(0);
            this.m_action = ac.isDisabled() ? NodeListView.ENABLE : NodeListView.DISABLE;
            this.setText(this.m_action);
            if (!ac.isApproved()) {
                this.setEnabled(false);
            }
        } else if (agentCards.size() >= 1 && this.m_action != null) {
            this.setText(String.valueOf(this.m_action) + "s");
            this.m_agentCards = agentCards;
        } else {
            this.setText(NodeListView.ENABLE);
            this.setEnabled(false);
            return;
        }
        for (AgentCard ac : agentCards) {
            if (Repository.getInstance().isPermittedAgentModify(ac)) continue;
            this.setEnabled(false);
            break;
        }
    }

    public void run() {
        int i = 0;
        while (i < this.m_agentCards.size()) {
            AgentCard ac = this.m_agentCards.get(i);
            this.changeStatus(ac);
            ++i;
        }
        IODataStream[] arr = this.m_agentCards.toArray(new IODataStream[0]);
        ServerClient sc = new ServerClient("ProcessAGENT", CMDS.ACTION_UPDATE_OBJECT, arr);
        Repository.getJobManager().schedule(sc);
    }

    public void changeStatus(AgentCard ac) {
        if (this.m_action.equals(NodeListView.DISABLE) && !ac.isDisabled()) {
            ac.setDisabled(true);
            ac.m_forceRefresh = 1;
        } else if (this.m_action.equals(NodeListView.ENABLE) && ac.isDisabled()) {
            ac.setDisabled(false);
            ac.m_forceRefresh = 1;
        } else {
            return;
        }
    }
}

