/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ExpandCollapseAction
extends Action {
    public static final String EXPAND_ALL = "ExpandAll";
    public static final String EXPAND_SUB_TREE = "ExpandSubTree";
    public static final String COLLAPSE_ALL = "CollapseAll";
    public static final String COLLAPSE_SUB_TREE = "CollagpseSubTree";
    public static boolean doExpand = false;
    public TreeViewer m_treeViewer = null;
    public String m_action = null;
    public List<GroupTreeObject> m_elements = null;
    public int m_level = -1;

    public ExpandCollapseAction(TreeViewer tv, String action) {
        super(action);
        if (tv == null || action == null) {
            this.setEnabled(false);
            return;
        }
        this.m_treeViewer = tv;
        this.m_action = action;
        if (action.equalsIgnoreCase(EXPAND_ALL)) {
            this.setText("Expand All");
            this.setId(EXPAND_ALL);
            this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPAND_ALL_PLUS_ICON);
        } else if (action.equalsIgnoreCase(EXPAND_SUB_TREE)) {
            this.setText("Expand Subtree");
            this.setId("ExpandSubtree");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPAND_PLUS_ICON);
            if (this.m_treeViewer.getSelection().isEmpty()) {
                this.setEnabled(false);
                return;
            }
        } else if (action.equalsIgnoreCase(COLLAPSE_ALL)) {
            this.setText("Collapse All");
            this.setId(COLLAPSE_ALL);
            this.setImageDescriptor(BMUI.IMAGE_DESCR_COLLAPSE_ALL_MINUS_ICON);
        } else if (action.equalsIgnoreCase(COLLAPSE_SUB_TREE)) {
            this.setText("Collapse Subtree");
            this.setId("CollapseSubtree");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_COLLAPSE_MINUS_ICON);
            if (this.m_treeViewer.getSelection().isEmpty()) {
                this.setEnabled(false);
                return;
            }
        } else {
            this.setEnabled(false);
            return;
        }
        if (this.m_treeViewer.getTree().getTopItem() == null) {
            this.setEnabled(false);
            return;
        }
    }

    public ExpandCollapseAction(TreeViewer tv, String action, List<GroupTreeObject> list, int level) {
        super(action);
        if (list == null || list.size() == 0) {
            this.setEnabled(false);
            return;
        }
        this.m_treeViewer = tv;
        this.m_action = action;
        this.m_elements = list;
        this.m_level = level;
    }

    public void run() {
        if (this.m_treeViewer == null || this.m_action == null) {
            return;
        }
        try {
            this.m_treeViewer.getTree().setRedraw(false);
            if (this.m_elements == null) {
                Object sel = ((IStructuredSelection)this.m_treeViewer.getSelection()).getFirstElement();
                this.expandCollapse(sel);
            } else {
                int i = 0;
                while (i < this.m_elements.size()) {
                    GroupTreeObject gto = this.m_elements.get(i);
                    this.expandCollapse(gto);
                    ++i;
                }
            }
            this.m_treeViewer.refresh();
        }
        catch (Throwable throwable) {
            try {
                this.m_treeViewer.getTree().setRedraw(true);
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            this.m_treeViewer.getTree().setRedraw(true);
        }
        catch (Throwable throwable) {}
    }

    public void expandCollapse(Object object) {
        if (this.m_action.equalsIgnoreCase(EXPAND_ALL)) {
            this.m_treeViewer.expandAll();
        } else if (this.m_action.equalsIgnoreCase(EXPAND_SUB_TREE)) {
            this.m_treeViewer.expandToLevel(object, this.m_level);
            this.m_treeViewer.getTree().showSelection();
        } else if (this.m_action.equalsIgnoreCase(COLLAPSE_ALL)) {
            this.m_treeViewer.collapseAll();
        } else if (this.m_action.equalsIgnoreCase(COLLAPSE_SUB_TREE)) {
            this.m_treeViewer.collapseToLevel(object, this.m_level);
            this.m_treeViewer.getTree().showSelection();
        }
    }
}

