/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.ActionsListView;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.log.RTLogger;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExportActionGroup
extends Action {
    private static String m_lastDirSelected = null;
    private TreeViewer m_treeViewer = null;
    private String m_dirName = null;
    private List<GroupTreeObject> m_elements = new ArrayList<GroupTreeObject>();
    private String m_message_savedFiles = "";
    private String m_message_replacedFiles = "";
    private int m_actionCount = 0;
    private String m_treeType = null;
    private File m_exportDir = null;
    private boolean m_dispMsg = true;

    public ExportActionGroup(TreeViewer treeViewer) {
        super("ExportActionGroup");
        this.setText("Export Actions");
        this.setId("export_Actions");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_treeViewer = treeViewer;
        this.m_treeType = (String)this.m_treeViewer.getData(ActionsListView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1007) < 2) {
            this.setEnabled(false);
        } else {
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    if (!(selected instanceof GroupTreeObject) || selected instanceof GroupTreeObjectLast) continue;
                    GroupTreeObject g = (GroupTreeObject)selected;
                    this.m_elements.add(g);
                }
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public ExportActionGroup(TreeViewer treeViewer, GroupTreeObject root, File dir) {
        super("ExportActionGroup");
        this.setText("Export Actions");
        this.setId("export_Actions");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_treeViewer = treeViewer;
        this.m_treeType = (String)this.m_treeViewer.getData(ExportMPIView.TREE_VIEWER_TYPE);
        this.m_exportDir = dir;
        this.m_dispMsg = false;
        if (Repository.getInstance().getRights(1007) < 2) {
            this.setEnabled(false);
        } else {
            List<GroupTreeObject> actionGroups = root.getElements();
            for (GroupTreeObject gto : actionGroups) {
                if (gto instanceof GroupTreeObjectLast) continue;
                this.m_elements.add(gto);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public boolean hasElements4Export() {
        return this.m_elements.size() > 0;
    }

    public void run() {
        if (!this.isEnabled() || this.m_elements.size() == 0) {
            return;
        }
        if (this.m_treeType.equals(ActionsListView.ACTION_LIST)) {
            DirectoryDialog fd = new DirectoryDialog(Display.getCurrent().getActiveShell());
            fd.setText("Select directory");
            if (m_lastDirSelected != null) {
                fd.setFilterPath(m_lastDirSelected);
            }
            this.m_dirName = fd.open();
            if (this.m_dirName == null) {
                return;
            }
        } else if (this.m_treeType.equals(ExportMPIView.ACTION_4EXPORT)) {
            if (this.m_exportDir == null) {
                return;
            }
            this.m_dirName = this.m_exportDir.getPath();
        }
        if (!this.m_dirName.endsWith(File.separator)) {
            this.m_dirName = String.valueOf(this.m_dirName) + File.separator;
        }
        m_lastDirSelected = this.m_dirName;
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObject gto = this.m_elements.get(i);
            ArrayList<com.blixx.shared.Action> al = new ArrayList<com.blixx.shared.Action>();
            List<GroupTreeObject> selActions = gto.getElements();
            for (GroupTreeObject o : selActions) {
                GroupTreeObjectLast gtol;
                Object obj;
                if (!(o instanceof GroupTreeObjectLast) || (obj = (gtol = (GroupTreeObjectLast)o).getTreeObject().getObject()) == null || !(obj instanceof com.blixx.shared.Action)) continue;
                al.add((com.blixx.shared.Action)obj);
            }
            this.exportSelectedActions(gto.getName(), al);
            ++i;
        }
        if (this.m_dispMsg) {
            String displayMessage = "";
            if (this.m_message_replacedFiles.length() > 0) {
                displayMessage = "Existing Action file(s) replaced: " + this.m_message_replacedFiles + "\n\n";
            }
            if (this.m_message_savedFiles.length() > 0) {
                displayMessage = String.valueOf(displayMessage) + "Action file(s) stored: " + this.m_message_savedFiles;
            }
            if (displayMessage.length() > 0) {
                String title = " Export Action";
                String msg = "The following Action has been exported:";
                String msg3 = "1 Action is affected!";
                if (this.m_actionCount > 1) {
                    title = " Export Actions";
                    msg = "The following Actions have been exported:";
                    msg3 = String.valueOf(this.m_actionCount) + " Actions are affected!";
                }
                ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, msg, displayMessage, msg3, false, "OK");
                md.setBlockOnOpen(true);
                md.open();
            }
        }
    }

    public void exportSelectedActions(String actGrpName, ArrayList actList) {
        if (actList.size() > 0) {
            String fullFilename = String.valueOf(this.m_dirName) + actGrpName + BMUI.file_extension_act;
            XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
            factory.storeFile(fullFilename, actList);
        } else {
            RTLogger.print(5, "Export MPI: no Actions to export -  empty ActionsGroup!");
        }
    }

    public void exportGroups(GroupTreeObject gto) {
        block6: {
            String groupName = gto.getName();
            File actionXML = new File(String.valueOf(Repository.getInstance().m_actionRepository.getActionsDirectory()) + groupName + BMUI.file_extension_act);
            if (actionXML.exists()) {
                File target = new File(String.valueOf(this.m_dirName) + groupName + BMUI.file_extension_act);
                boolean is_replaced = false;
                if (target.exists()) {
                    is_replaced = true;
                }
                try {
                    FileUtils.copyFile(actionXML, target);
                    if (!is_replaced) {
                        this.m_message_savedFiles = String.valueOf(this.m_message_savedFiles) + "\n" + target.getCanonicalPath();
                        ++this.m_actionCount;
                        break block6;
                    }
                    this.m_message_replacedFiles = String.valueOf(this.m_message_replacedFiles) + "\n" + target.getCanonicalPath();
                    ++this.m_actionCount;
                }
                catch (IOException e) {
                    new ShowMessageBox("Error", "Export action failed.\n" + e.getMessage(), 1);
                }
            } else {
                new ShowMessageBox("Error", "Export action failed. File not found", 1);
            }
        }
    }
}

