/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.utils.AgentTableFilter;
import com.blixx.boom.gui.utils.AgentTableFilterOnExternal;
import com.blixx.boom.gui.utils.AgentTableFilterOnStatus;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import com.blixx.log.RTLogger;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class ExportAgentOverviewAction
extends Action {
    private TableViewer m_tv = null;
    private static String SEMICOLON_DELIMITER = ";";
    private static String DOUBLE_QUOTE = "\"";
    private String filePath = null;
    private static String m_lastDirSelected = null;
    int col_OS = 1;
    int col_DISABLED = 2;
    int col_LABEL = 3;
    int col_VERSION = 5;
    int col_IP = 6;
    int col_PORT = 7;
    int col_HOST = 8;
    int col_RELATED_GROUPS = 9;
    int col_LAST_INIDCATION = 10;
    int col_BOOM_SERVER = 11;
    int col_AGENT_ID = 12;
    AgentTableFilterOnStatus m_filterOnStatus = null;
    AgentTableFilterOnExternal m_filterOnExternal = null;
    AgentTableFilter m_filterOnAgentTable = null;

    public ExportAgentOverviewAction(TableViewer tv) {
        super("ExportTable");
        this.setId("exporttable");
        this.setText("Export Table");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.setEnabled(true);
        this.m_tv = tv;
    }

    public void run() {
        try {
            File outFile = this.askForExportDirectory();
            if (outFile != null) {
                boolean success = this.export(outFile);
                MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), success ? 2 : 1);
                mb.setText("Agent Overview Export");
                mb.setMessage(success ? "Agent Overview exported to:\n" + this.filePath : "Error exporting Agent Overview to:\n" + this.filePath + "\nThe file might be in use by some other application!");
                mb.open();
            }
        }
        catch (RuntimeException e1) {
            MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 1);
            mb.setText("Error");
            mb.setMessage("Agent Overview Export failed.\n" + e1.getMessage());
            mb.open();
        }
    }

    public File askForExportDirectory() {
        File outFile = null;
        FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8196);
        fd.setFilterExtensions(new String[]{"*.csv"});
        if (m_lastDirSelected != null) {
            fd.setFilterPath(m_lastDirSelected);
        }
        this.filePath = fd.open();
        if (this.filePath != null) {
            outFile = new File(this.filePath);
            m_lastDirSelected = outFile.getParentFile().getPath();
            if (outFile.exists()) {
                String msg = "File does already exist! Do you want to overwrite?";
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Overwrite", msg, "Overwrite", "Cancel");
                int res = dialog.open();
                if (res == 0) {
                    return outFile;
                }
                outFile = this.askForExportDirectory();
            }
        }
        return outFile;
    }

    private boolean export(File outFile) {
        RTLogger.print(3, "Export Agent Overview Table ...");
        PrintWriter pw = null;
        boolean success = true;
        StringBuilder sb = new StringBuilder();
        StringBuffer header = new StringBuffer();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            try {
                pw = new PrintWriter(outFile);
                header.append("AGENT_ID").append(SEMICOLON_DELIMITER).append("LABEL").append(SEMICOLON_DELIMITER).append("IP").append(SEMICOLON_DELIMITER).append("OS").append(SEMICOLON_DELIMITER).append("VERSION").append(SEMICOLON_DELIMITER).append("PORT").append(SEMICOLON_DELIMITER).append("HOST").append(SEMICOLON_DELIMITER).append("RELATED_GROUPS").append(SEMICOLON_DELIMITER).append("MAX_SEVERITY").append(SEMICOLON_DELIMITER).append("LAST_INIDCATION (DAYS)").append(SEMICOLON_DELIMITER).append("BOOM_SERVER").append(SEMICOLON_DELIMITER).append("DISABLED").append(SEMICOLON_DELIMITER).append("OFFLINE").append(SEMICOLON_DELIMITER).append("FIREWALLED").append(SEMICOLON_DELIMITER).append("NOT_APPROVED");
                Set<String> agents_sorted = this.getAgentsToExport();
                for (String labelId : agents_sorted) {
                    String[] split = labelId.split("@@");
                    if (split.length != 2) continue;
                    String agentID = split[1];
                    AgentCard ac = Repository.getInstance().getAgentCard(agentID);
                    sb = new StringBuilder();
                    sb.append(DOUBLE_QUOTE).append(ac.getAgentID()).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.getLabel().trim()).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.getAgentIP()).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(AgentOverviewTableProvider.getOS(ac)).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append("=\"").append(Repository.getInstance().getAgentVersion(ac.getID())).append("\"").append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.getAgentPort()).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.getAgentHost()).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(this.getRelatedGroups(ac)).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(BMUI.getMaxSeverityString(ac)).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(AgentOverviewTableProvider.getLastMessage(ac)).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.getRelatedServer() == null ? "" : ac.getRelatedServer()).append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.isDisabled() ? "YES" : "").append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(!AgentOverviewTableProvider.isAgentOnline(ac) ? "YES" : "").append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(ac.isFirewalled() ? "YES" : "").append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    sb.append(DOUBLE_QUOTE).append(!ac.isApproved() ? "YES" : "").append(DOUBLE_QUOTE).append(SEMICOLON_DELIMITER);
                    lines.add(sb.toString());
                }
                pw.println(header.toString());
                for (String line_str : lines) {
                    pw.println(line_str);
                }
                RTLogger.print(2, "Output file: " + outFile.getName());
            }
            catch (Throwable e) {
                success = false;
                RTLogger.print(1, "Error creating output file " + outFile != null ? outFile.getPath() : this.filePath, e);
                try {
                    pw.close();
                }
                catch (Throwable e2) {
                    RTLogger.print(1, "Error while closing printWriter!", e2);
                }
            }
        }
        finally {
            try {
                pw.close();
            }
            catch (Throwable e) {
                RTLogger.print(1, "Error while closing printWriter!", e);
            }
        }
        return success;
    }

    private Set<String> getAgentsToExport() {
        Collection<AgentCard> allAgents = Repository.getInstance().getAgentCards();
        TreeSet<String> agents = new TreeSet<String>();
        try {
            ViewerFilter[] filters = this.m_tv.getFilters();
            if (filters.length == 0) {
                for (AgentCard ac : allAgents) {
                    if (ac == null) continue;
                    agents.add(String.valueOf(ac.getComparableName()) + "@@" + ac.getID());
                }
            } else {
                int count = 0;
                while (count < filters.length) {
                    ViewerFilter vf = filters[count];
                    if (vf instanceof AgentTableFilterOnStatus) {
                        this.m_filterOnStatus = (AgentTableFilterOnStatus)vf;
                    } else if (vf instanceof AgentTableFilterOnExternal) {
                        this.m_filterOnExternal = (AgentTableFilterOnExternal)vf;
                    } else if (vf instanceof AgentTableFilter) {
                        this.m_filterOnAgentTable = (AgentTableFilter)vf;
                    }
                    ++count;
                }
                for (AgentCard ac : allAgents) {
                    if (ac == null || !this.filterOnStatus(ac) || !(this.filterOnExternal(ac) & this.filterOn(ac))) continue;
                    agents.add(String.valueOf(ac.getComparableName()) + "@@" + ac.getID());
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "Error processing agents for AgentExport!", e);
        }
        return agents;
    }

    private boolean filterOnStatus(AgentCard ac) {
        return this.m_filterOnStatus == null ? true : this.m_filterOnStatus.select(null, null, ac);
    }

    private boolean filterOnExternal(AgentCard ac) {
        return this.m_filterOnExternal == null ? true : this.m_filterOnExternal.select(null, null, ac);
    }

    private boolean filterOn(AgentCard ac) {
        return this.m_filterOnAgentTable == null ? true : this.m_filterOnAgentTable.select(null, null, ac);
    }

    private String getRelatedGroups(AgentCard ac) {
        StringBuffer relGroups = new StringBuffer();
        try {
            Iterator<String> it = ac.getRelatedNodeGroupsList().iterator();
            while (it.hasNext()) {
                relGroups.append(it.next());
                if (!it.hasNext()) continue;
                relGroups.append(", ");
            }
        }
        catch (Throwable throwable) {
            relGroups = new StringBuffer();
        }
        return relGroups.toString();
    }
}

