/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.log.RTLogger;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import java.io.File;
import java.io.FileInputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.w3c.dom.Document;

public class ExportAssignmentsAction
extends Action {
    private static String m_lastDirSelected = null;
    TreeViewer m_treeViewer = null;
    private GroupTreeObject m_root = null;
    private String m_treeType = null;
    private File m_exportDir = null;

    public ExportAssignmentsAction(TreeViewer treeViewer) {
        super("ExportAssignments");
        this.setText("Export Assignments");
        this.setId("exportassignment");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_treeViewer = treeViewer;
        this.m_treeType = (String)this.m_treeViewer.getData(AssignmentListView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1008) < 2) {
            this.setEnabled(false);
        }
    }

    public ExportAssignmentsAction(TreeViewer treeViewer, GroupTreeObject root, File dir) {
        super("ExportAssignments");
        this.setText("Export Assignments");
        this.setId("exportassignment");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_treeViewer = treeViewer;
        this.m_exportDir = dir;
        this.m_treeType = (String)this.m_treeViewer.getData(ExportMPIView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1008) < 2) {
            this.setEnabled(false);
        } else {
            this.m_root = root;
            if (this.m_root == null || this.m_root.getElements().size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public boolean hasElements4Export() {
        return this.m_root != null && this.m_root.getElements().size() > 0;
    }

    public void run() {
        block23: {
            ProgressDialog pd;
            block22: {
                if (this.m_root == null || this.m_root.getElements().size() == 0) {
                    return;
                }
                String dirName = null;
                if (this.m_treeType.equals(AssignmentListView.ASSIGNMENT_LIST)) {
                    String grpFile;
                    File file;
                    DirectoryDialog fd = new DirectoryDialog(this.m_treeViewer.getControl().getShell());
                    fd.setText("Select directory");
                    if (m_lastDirSelected != null) {
                        fd.setFilterPath(m_lastDirSelected);
                    }
                    if ((dirName = fd.open()) == null) {
                        return;
                    }
                    this.m_exportDir = new File(dirName);
                    if (!this.m_exportDir.isDirectory()) {
                        this.m_exportDir = this.m_exportDir.getParentFile();
                    }
                    if ((file = new File(grpFile = this.m_exportDir + File.separator + "assignmentGroups.xml")).exists()) {
                        file.delete();
                    }
                } else if (this.m_treeType.equals(ExportMPIView.ASSIGNMENT_4EXPORT) && this.m_exportDir == null) {
                    return;
                }
                XMLTree m_xmlTools = new XMLTree();
                pd = new ProgressDialog("Export Assignments", "Initialization... ", 1, this.m_root.getElements().size());
                pd.setBlockOnOpen(false);
                pd.open();
                try {
                    try {
                        String asnGroupsFile = this.m_exportDir + File.separator + "assignmentGroups.xml";
                        File asnGrpFile = new File(asnGroupsFile);
                        if (!asnGrpFile.exists() || !asnGrpFile.canRead()) {
                            Document doc = m_xmlTools.getXML(this.m_root);
                            XMLFactory.writeXml(doc, asnGroupsFile);
                            break block22;
                        }
                        FileInputStream fio = new FileInputStream(asnGroupsFile);
                        this.m_root = m_xmlTools.parseXML(fio, true);
                        try {
                            fio.close();
                        }
                        catch (Throwable throwable) {}
                        if (!this.m_root.getFirstChild("Assignments").getTreeObject().getType().equals(BMUI.type_toplevel)) {
                            this.m_root.getFirstChild("Assignments").setType(BMUI.type_toplevel);
                            Document doc = m_xmlTools.getXML(this.m_root);
                            XMLFactory.writeXml(doc, asnGroupsFile);
                        }
                    }
                    catch (Throwable throwable) {
                        RTLogger.print(2, "Assignment group tree failed to be initialized");
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable2) {}
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

