/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.csv.CSVFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class ExportIndiCSVAction
extends Action {
    ArrayList<SEvent> m_elements = null;
    char DELIMIT = (char)59;
    String delimiter = "" + this.DELIMIT;

    public ExportIndiCSVAction(StructuredSelection ssel) {
        super("ExportIndiCSVAction");
        this.setId("ExportIndiCSVAction");
        this.setText("Export Indication (CSV)");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        if (ssel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.m_elements = new ArrayList(ssel.toList());
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Export Indications (CSV)");
        }
    }

    public String escapeSpecialCharacters(String data) {
        String escapedData = data.replaceAll("\\R", " ");
        if (data.contains(this.delimiter) || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block82: {
            block81: {
                if (this.m_elements == null || this.m_elements.size() == 0) {
                    return;
                }
                m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                fd = new FileDialog(Display.getCurrent().getActiveShell(), 8196);
                fd.setFilterExtensions(new String[]{"*.csv", "*.*"});
                fd.setFileName("IndicationsExport_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".csv");
                filePath = fd.open();
                if (filePath == null) break block82;
                RTLogger.print(4, "Start exporting (CSV)" + this.m_elements.size() + " Indications.");
                file = new File(filePath);
                if (file.exists()) {
                    dialog = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Replace existing file?", "Do you want to overwrite existing file:", file.getAbsolutePath(), null, true, "Overwrite");
                    dialog.setBlockOnOpen(true);
                    res = dialog.open();
                    if (res == 0) {
                        if (!file.delete()) {
                            RTLogger.print(4, "ERROR deleting existing file " + filePath);
                        }
                    } else {
                        return;
                    }
                }
                pd = new ProgressDialog("Export Indications (CSV)", "", 0, this.m_elements.size());
                pd.setBlockOnOpen(false);
                pd.open();
                try {
                    dummy = new String[]{};
                    scb = new ServerClientBatch("GET_ANNOT");
                    i = 0;
                    while (i < this.m_elements.size()) {
                        se = this.m_elements.get(i);
                        if (se.getAnnotationFlag() && se.getAnnotations().size() <= 0) {
                            scb.setCommand("GET_ANNOT", se.getID(), dummy);
                            res = scb.runBatch();
                            if (scb.isSuccess() && res != null && res instanceof ArrayList) {
                                se.setAnnotations((ArrayList)res);
                            }
                            s = i + 1;
                            pd.setProgress("Getting Annotations " + s + " of " + this.m_elements.size(), s);
                        }
                        ++i;
                    }
                    scb.close();
                    headComment = "Indications exported: " + this.m_elements.size();
                    format = CSVFormat.EXCEL.withDelimiter(this.DELIMIT);
                    format = format.withHeaderComments(new Object[]{headComment});
                    format = format.withCommentMarker('#');
                    format = format.withHeader(new String[]{"No", "INDICATION TEXT", "SEVERITY", "UUID", "APPLICATION", "GROUP", "HOST", "AGENT HOST", "KPI METRIC", "AVAILABILITY METRIC", "OBJECT", "KEY", "CLOSE MASK", "AUTO-ACTION", "AUTO-ACTION HOST", "OP-ACTION", "SOURCE", "STATE", "DUPLICATES", "FIRST SUBMIT", "LAST DUPLICATE", "SERVER RECEIVED", "VALUE", "END VALUE", "ALERT FINISHED", "DEDUPLICATION KEYONLY", "AGENTID", "SRVSLAVE", "OWNER", "CUSTOM ATTRIBUTES", "ANNOTATIONS"});
                    var10_14 = null;
                    var11_17 = null;
                    try {
                        fw = new FileWriter(file);
                        try {
                            printer = format.print((Appendable)fw);
                            try {
                                seq = 0;
                                i = 0;
                                while (i < this.m_elements.size()) {
                                    block83: {
                                        ++seq;
                                        se = this.m_elements.get(i);
                                        pd.setProgress("Saving data", i + 1);
                                        txt = se.getText().trim().replace('\n', ' ');
                                        txt = this.escapeSpecialCharacters(txt);
                                        sev = se.getSeverity();
                                        id = se.getID();
                                        appl = se.getApplication();
                                        grp = se.getGroup();
                                        host = se.getNode();
                                        agt = se.getAgentNode();
                                        kpi = se.getTypeA() == 1 ? "true" : "false";
                                        av = se.getTypeK() == 1 ? "true" : "false";
                                        obj = se.getObject();
                                        key = se.getKeyConfigured();
                                        close = se.getCloseMask();
                                        aa = se.getAutoAction();
                                        aaNode = se.getAutoActionNode();
                                        oa = se.getOpAction().trim();
                                        src = se.getSource();
                                        state = "Unknown";
                                        switch (se.getState()) {
                                            case 'A': {
                                                state = "Auto Closed Message";
                                                break;
                                            }
                                            case 'O': {
                                                state = "Closed By Operator";
                                                break;
                                            }
                                            case '-': {
                                                state = "Active";
                                                break;
                                            }
                                            case 'D': {
                                                state = "Archived";
                                                break;
                                            }
                                        }
                                        dupl = se.getDuplicates();
                                        firstSubmit = m_sdf.format(new Date(se.getFirstTime()));
                                        lastDupl = m_sdf.format(new Date(se.getTime()));
                                        srvRec = m_sdf.format(new Date(se.getSTime()));
                                        val = 0.0;
                                        endVal = 0.0;
                                        srvTimeFA = null;
                                        if (se.getSource().startsWith("Monitor")) {
                                            val = se.getValue();
                                            if (se instanceof SEventFwd && (sef = (SEventFwd)se).getTFA() > 0L) {
                                                endVal = sef.getVFA();
                                                srvTimeFA = m_sdf.format(new Date(sef.getTFA()));
                                            }
                                        }
                                        deDuplKey = "";
                                        agentID = "";
                                        srvSlave = "";
                                        owner = "";
                                        user = "";
                                        date = "";
                                        customText = "";
                                        name = "";
                                        value = "";
                                        customVar = "";
                                        if (se instanceof SEventFwd) {
                                            sef = (SEventFwd)se;
                                            deDuplKey = sef.getDeDuplicationKeyOnly() != false ? "true" : "false";
                                            agentID = sef.getT1();
                                            if (agentID != null) {
                                                agentID.length();
                                            }
                                            if ((srvSlave = sef.getSrv()) != null) {
                                                srvSlave.length();
                                            }
                                            if ((owner = sef.getT5()) != null && owner.length() > 0) {
                                                user = "";
                                                date = "";
                                                arr = owner.split("\n");
                                                user = arr[0];
                                                try {
                                                    date = m_sdf.format(new Date(Long.parseLong(arr[1])));
                                                }
                                                catch (Throwable v0) {}
                                                if (date.length() > 0) {
                                                    user = String.valueOf(user) + date;
                                                }
                                            }
                                            if ((customText = sef.getT7()) != null && customText.length() > 0) {
                                                customText = String.valueOf(customText) + "  ";
                                            }
                                            cai = 0;
                                            while (cai < 15) {
                                                CAName = "CA" + (cai + 1);
                                                str = sef.m_CustomAttributes.get(CAName);
                                                if (str != null && (indexOf_EQ = str.indexOf(61)) != -1) {
                                                    name = str.substring(0, indexOf_EQ);
                                                    value = str.substring(indexOf_EQ + 1);
                                                    customVar = String.valueOf(customVar) + name + " = " + value + "  ";
                                                }
                                                ++cai;
                                            }
                                            customText = String.valueOf(customText) + customVar;
                                        }
                                        duplicateLabel = "";
                                        usr = " ";
                                        noteLbl = "";
                                        annoDupl = "";
                                        noteLabel = "";
                                        ann = "";
                                        annos = "";
                                        if (!se.getAnnotationFlag()) break block83;
                                        duplicates = new StringBuffer();
                                        dFlag = false;
                                        annoi = 0;
                                        while (annoi < se.getAnnotations().size()) {
                                            block84: {
                                                block85: {
                                                    ann = se.getAnnotations().get(annoi);
                                                    if (ann == null) break block84;
                                                    noteLabel = "Note " + i;
                                                    if (!ann.startsWith("AAT")) break block85;
                                                    noteLabel = "AutoAction\nSuccess\n";
                                                    firstNL = ann.indexOf(10);
                                                    time = ann.substring(ann.indexOf(124) + 1, firstNL);
                                                    noteLabel = String.valueOf(noteLabel) + time;
                                                    ann = ann.substring(firstNL + 1);
                                                    ** GOTO lbl229
                                                }
                                                if (ann.startsWith("DD")) {
                                                    firstNL = ann.indexOf(124);
                                                    line = ann.substring(firstNL + 1);
                                                    if (duplicates.length() == 0) {
                                                        duplicates.append(line.replace('\n', ' '));
                                                    } else {
                                                        duplicates.append('\n').append(line.replace('\n', ' '));
                                                    }
                                                    if (!dFlag.booleanValue()) {
                                                        duplicateLabel = "Custom Attributes in duplicates";
                                                        duplicateLabel = String.valueOf(duplicateLabel) + duplicates.toString();
                                                        dFlag = true;
                                                    }
                                                } else {
                                                    if (ann.startsWith("AAF")) {
                                                        noteLabel = "AutoAction\nFailed\n";
                                                        firstNL = ann.indexOf(10);
                                                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                                                        noteLabel = String.valueOf(noteLabel) + time;
                                                        ann = ann.substring(firstNL + 1);
                                                    } else if (ann.startsWith("SAM")) {
                                                        noteLabel = "Auto closed\n";
                                                        firstNL = ann.indexOf(10);
                                                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                                                        noteLabel = String.valueOf(noteLabel) + time;
                                                        ann = ann.substring(firstNL + 1);
                                                    } else if (ann.startsWith("OAM")) {
                                                        noteLabel = "Operator closed\n";
                                                        firstNL = ann.indexOf(10);
                                                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                                                        noteLabel = String.valueOf(noteLabel) + time;
                                                        ann = ann.substring(firstNL + 1);
                                                    } else if (ann.startsWith("OMN")) {
                                                        noteLabel = "OP: ";
                                                        firstNL = ann.indexOf(10);
                                                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                                                        lnl = (ann = ann.substring(firstNL + 1)).indexOf(10);
                                                        if (lnl != -1) {
                                                            usr = ann.substring(0, lnl);
                                                            noteLabel = String.valueOf(noteLabel) + usr + "\n";
                                                        }
                                                        noteLabel = String.valueOf(noteLabel) + time;
                                                    } else if (ann.startsWith("REO")) {
                                                        noteLabel = "Re-opened by: ";
                                                        firstNL = ann.indexOf(10);
                                                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                                                        try {
                                                            time = m_sdf.format(new Date(Long.parseLong(time)));
                                                        }
                                                        catch (Throwable v1) {}
                                                        ann = ann.substring(firstNL + 1);
                                                        lnl = ann.indexOf(10);
                                                        if (lnl != -1) {
                                                            usr = ann.substring(0, lnl);
                                                            noteLabel = String.valueOf(noteLabel) + usr + "\n";
                                                        }
                                                        noteLabel = String.valueOf(noteLabel) + time;
                                                    }
lbl229:
                                                    // 8 sources

                                                    noteLbl = String.valueOf(noteLbl) + "  " + noteLabel + ann;
                                                }
                                            }
                                            ++annoi;
                                        }
                                        res1 = noteLbl.trim().replaceAll("[\\t\\n\\r]+", " ");
                                        annos = this.escapeSpecialCharacters(res1);
                                        if (dFlag.booleanValue()) {
                                            annoDupl = String.valueOf(annoDupl) + duplicates.toString();
                                        }
                                    }
                                    printer.printRecord(new Object[]{seq, txt, sev, id, appl, grp, host, agt, kpi, av, obj, key, close, aa, aaNode, oa, src, state, dupl, firstSubmit, lastDupl, srvRec, val, endVal, srvTimeFA, deDuplKey, agentID, srvSlave, user, customText, annos, annoDupl});
                                    ++i;
                                }
                            }
                            finally {
                                if (printer != null) {
                                    printer.close();
                                }
                            }
                            ** if (fw == null) goto lbl-1000
                        }
                        catch (Throwable var11_18) {
                            if (var10_14 == null) {
                                var10_14 = var11_18;
                            } else if (var10_14 != var11_18) {
                                var10_14.addSuppressed(var11_18);
                            }
                            if (fw != null) {
                                fw.close();
                            }
                            throw var10_14;
                        }
lbl-1000:
                        // 1 sources

                        {
                            fw.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var11_19) {
                        if (var10_14 == null) {
                            var10_14 = var11_19;
                        } else if (var10_14 != var11_19) {
                            var10_14.addSuppressed(var11_19);
                        }
                        throw var10_14;
                    }
                }
                catch (SWTException swte) {
                    if (swte.code == 24) {
                        new ShowMessageBox("Export stopped", "Operation canceled.", 2);
                    } else {
                        new ShowMessageBox("Export stopped", "SWT Error: " + swte.getMessage(), 2);
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable v2) {}
                    break block81;
                }
                catch (Throwable e) {
                    try {
                        RTLogger.print(5, "", e);
                        new ShowMessageBox("Export stopped", "Runtime Error: " + e.getMessage(), 2);
                    }
                    catch (Throwable var66_76) {
                        try {
                            pd.close();
                        }
                        catch (Throwable v3) {}
                        throw var66_76;
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable v4) {}
                    break block81;
                }
                try {
                    pd.close();
                }
                catch (Throwable v5) {}
            }
            RTLogger.print(4, "Finished exporting Indications (CSV).");
        }
    }
}

