/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.utils.IndicationPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class ExportIndicationAction
extends Action {
    ArrayList<SEvent> m_elements = null;

    public ExportIndicationAction(StructuredSelection ssel) {
        super("ExportIndicationAction");
        this.setId("ExportIndicationAction");
        this.setText("Export Indication (Text)");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        if (ssel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.m_elements = new ArrayList(ssel.toList());
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText("Export Indications (Text)");
        }
    }

    public void run() {
        if (this.m_elements == null || this.m_elements.size() == 0) {
            return;
        }
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8196);
        fd.setFileName("IndicationsExport_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".txt");
        String filePath = fd.open();
        if (filePath != null) {
            block36: {
                RTLogger.print(4, "Start exporting (Text)" + this.m_elements.size() + " Indications.");
                File file = new File(filePath);
                if (file.exists()) {
                    ShowMessageDialog dialog = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Replace existing file?", "Do you want to overwrite existing file:", file.getAbsolutePath(), null, true, "Overwrite");
                    dialog.setBlockOnOpen(true);
                    int res = dialog.open();
                    if (res == 0) {
                        if (!file.delete()) {
                            RTLogger.print(4, "ERROR deleting existing file " + filePath);
                        }
                    } else {
                        return;
                    }
                }
                ProgressDialog pd = new ProgressDialog("Export Indications (Text)", "", 0, this.m_elements.size());
                pd.setBlockOnOpen(false);
                IndicationPrinter iPprinter = new IndicationPrinter();
                try {
                    Throwable throwable = null;
                    Object var7_11 = null;
                    try (FileOutputStream os = new FileOutputStream(file);){
                        SEvent se;
                        pd.open();
                        String[] dummy = new String[]{};
                        ServerClientBatch scb = new ServerClientBatch("GET_ANNOT");
                        int i = 0;
                        while (i < this.m_elements.size()) {
                            se = this.m_elements.get(i);
                            if (se.getAnnotationFlag() && se.getAnnotations().size() <= 0) {
                                scb.setCommand("GET_ANNOT", se.getID(), dummy);
                                Object res = scb.runBatch();
                                if (scb.isSuccess() && res != null && res instanceof ArrayList) {
                                    se.setAnnotations((ArrayList)res);
                                }
                                int s = i + 1;
                                pd.setProgress("Getting Annotations " + s + " of " + this.m_elements.size(), s);
                            }
                            ++i;
                        }
                        scb.close();
                        i = 0;
                        while (i < this.m_elements.size()) {
                            se = this.m_elements.get(i);
                            pd.setProgress("Saving data", i + 1);
                            iPprinter.export(se, os);
                            ++i;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SWTException swte) {
                    if (swte.code == 24) {
                        new ShowMessageBox("Export stopped", "Operation canceled.", 2);
                    } else {
                        new ShowMessageBox("Export stopped", "SWT Error: " + swte.getMessage(), 2);
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                    break block36;
                }
                catch (Throwable e) {
                    try {
                        RTLogger.print(5, "", e);
                        new ShowMessageBox("Export stopped", "Runtime Error: " + e.getMessage(), 2);
                    }
                    catch (Throwable throwable) {
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable3) {}
                        throw throwable;
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                    break block36;
                }
                try {
                    pd.close();
                }
                catch (Throwable throwable) {}
            }
            RTLogger.print(4, "Finished exporting Indications (Text).");
        }
    }
}

