/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public class ExportPolicyAction
extends Action {
    private static String m_lastDirSelected = null;
    TreeViewer m_treeViewer = null;
    private ArrayList<GroupTreeObjectLast> m_elements = new ArrayList();
    private GroupTreeObject m_root = null;
    private String m_treeType = null;
    private File m_exportDir = null;

    public ExportPolicyAction(TreeViewer treeViewer, GroupTreeObject root) {
        super("ExportPolicy");
        this.setText("Export Policies (XML)");
        this.setId("export_Policy");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_root = root;
        this.m_treeViewer = treeViewer;
        this.m_treeType = (String)this.m_treeViewer.getData(PolicyListView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1001) < 2) {
            this.setEnabled(false);
        } else {
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObject)) continue;
                GroupTreeObject gto = (GroupTreeObject)selected;
                if (gto.isGroup()) {
                    this.m_elements.addAll(gto.getAllGTOLs());
                    continue;
                }
                this.m_elements.add((GroupTreeObjectLast)gto);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public ExportPolicyAction(TreeViewer treeViewer, GroupTreeObject root, File dir) {
        super("ExportPolicy");
        this.setText("Export Policies (XML)");
        this.setId("export_Policy");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_treeViewer = treeViewer;
        this.m_root = root;
        this.m_exportDir = dir;
        this.m_treeType = (String)this.m_treeViewer.getData(ExportMPIView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1001) < 2) {
            this.setEnabled(false);
        } else {
            List<GroupTreeObject> list = root.getAllElements();
            for (GroupTreeObject gto : list) {
                if (!(gto instanceof GroupTreeObjectLast)) continue;
                this.m_elements.add((GroupTreeObjectLast)gto);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public boolean hasElements4Export() {
        return this.m_elements.size() > 0;
    }

    public void run() {
        if (this.m_elements.size() == 0) {
            return;
        }
        String dirName = null;
        if (this.m_treeType.equals(PolicyListView.POLICY_LIST)) {
            DirectoryDialog fd = new DirectoryDialog(this.m_treeViewer.getControl().getShell());
            fd.setText("Select directory");
            if (m_lastDirSelected != null) {
                fd.setFilterPath(m_lastDirSelected);
            }
            if ((dirName = fd.open()) == null) {
                return;
            }
            this.m_exportDir = new File(dirName);
            if (!this.m_exportDir.isDirectory()) {
                this.m_exportDir = this.m_exportDir.getParentFile();
            }
            m_lastDirSelected = this.m_exportDir.getPath();
            boolean doPoliciesExist = this.doPoliciesExist();
            if (doPoliciesExist) {
                String msg = "Do you want to overwrite existing Policies?";
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Overwrite", msg, "Overwrite", "Cancel");
                int res = dialog.open();
                if (res != 0) {
                    return;
                }
            }
        } else if (this.m_treeType.equals(ExportMPIView.POLICY_4EXPORT)) {
            if (this.m_exportDir == null) {
                return;
            }
            m_lastDirSelected = this.m_exportDir.getParent();
        }
        ProgressDialog pd = new ProgressDialog("  Export Policies", "", 0, this.m_elements.size());
        pd.setBlockOnOpen(false);
        pd.open();
        try {
            GroupTreeObject root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            HashMap<String, GroupTreeObject> recreated = new HashMap<String, GroupTreeObject>();
            boolean isNotEmpty = false;
            int i = 0;
            while (i < this.m_elements.size()) {
                GroupTreeObjectLast gtol = this.m_elements.get(i);
                if (gtol != null) {
                    String type = gtol.getTreeObject().getType();
                    if (type == null) {
                        RTLogger.print(5, "type is null for element" + gtol);
                    } else {
                        pd.setProgress("Exporting Policies \"" + gtol.getName() + "\"", i + 1);
                        boolean isOK = false;
                        if (PolicyManager.getInstance().isPermittedPolicyRead(gtol)) {
                            isOK = this.exportPolicy(this.m_exportDir, gtol);
                        }
                        if (isOK) {
                            String path = gtol.getParentPath();
                            try {
                                GroupTreeObjectLast nGtol;
                                GroupTreeObject createdLast;
                                if (!recreated.containsKey(path)) {
                                    GroupTreeObject.createPath(path, root);
                                    createdLast = root.searchPath(path, BMUI.type_folder);
                                    recreated.put(path, createdLast);
                                    nGtol = new GroupTreeObjectLast(gtol.getTreeObject(), null, gtol.getIcon());
                                    createdLast.addElement(nGtol);
                                } else {
                                    createdLast = (GroupTreeObject)recreated.get(path);
                                    nGtol = new GroupTreeObjectLast(gtol.getTreeObject(), null, gtol.getIcon());
                                    createdLast.addElement(nGtol);
                                }
                                isNotEmpty = true;
                            }
                            catch (RuntimeException runtimeException) {}
                        }
                    }
                }
                ++i;
            }
            if (isNotEmpty) {
                XMLTree xt = new XMLTree();
                Document xml = xt.getXML(root);
                try {
                    XMLFactory.writeXml(xml, String.valueOf(this.m_exportDir.getCanonicalPath()) + File.separator + BM.PolicyGroups_xml);
                }
                catch (IOException e) {
                    RTLogger.print(3, "Error exporting policies", e);
                }
            } else {
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Warning", "No policies were exported due to error or permissions rights.", "Close", null);
                dialog.open();
            }
        }
        catch (Throwable throwable) {
            try {
                pd.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    private boolean doPoliciesExist() {
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObjectLast gtol = this.m_elements.get(i);
            if (gtol != null) {
                String type = gtol.getType();
                String fileName = null;
                if (type.equals(BMUI.type_mon)) {
                    fileName = String.valueOf(gtol.getName()) + "." + BMUI.type_mon + BMUI.file_extension_xml;
                } else if (type.equals(BMUI.type_msg)) {
                    fileName = String.valueOf(gtol.getName()) + "." + BMUI.type_msg + BMUI.file_extension_xml;
                }
                if (fileName != null) {
                    try {
                        File file = new File(this.m_exportDir + File.separator + fileName);
                        if (file.exists()) {
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
        return false;
    }

    private boolean exportPolicy(File dir, GroupTreeObjectLast gtol) {
        boolean isSuccess = false;
        RTLogger.print(5, "Export Policy ..." + gtol.getName());
        File fileP = null;
        String type = gtol.getTreeObject().getType();
        try {
            if (type.equals(BMUI.type_mon)) {
                fileP = Repository.getInstance().fetchFile(gtol.getName(), type);
            } else if (type.equals(BMUI.type_msg)) {
                fileP = Repository.getInstance().fetchFile(gtol.getName(), type);
            }
        }
        catch (Throwable throwable) {}
        if (fileP == null) {
            String msg = "Server failed to find requested Policy. " + gtol.getName();
            RTLogger.print(5, msg);
            new ShowMessageBox("Error getting Policy", msg, 1);
            return isSuccess;
        }
        File target = new File(dir, fileP.getName());
        try {
            ExportPolicyAction.fileCopy(fileP, target);
            isSuccess = true;
        }
        catch (IOException e) {
            RTLogger.print(5, "filecopy failed. ", e);
            new ShowMessageBox("Save Policy", "Error saving the Policy!\n" + e.getMessage(), 1);
        }
        return isSuccess;
    }

    public static void fileCopy(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            int maxCount = 67076096;
            long size = inChannel.size();
            long position = 0L;
            while (position < size) {
                position += inChannel.transferTo(position, maxCount, outChannel);
            }
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void main(String[] args) {
        GroupTreeObject gt = new GroupTreeObject(new TreeObject("root1", BMUI.type_folder, null));
        GroupTreeObject gt1 = new GroupTreeObject(new TreeObject("A1", BMUI.type_folder, null));
        gt.addElement(gt1);
        GroupTreeObject gt2 = new GroupTreeObject(new TreeObject("B1", BMUI.type_folder, null));
        gt1.addElement(gt2);
        GroupTreeObject gt3 = new GroupTreeObject(new TreeObject("C1", BMUI.type_folder, null));
        gt2.addElement(gt3);
        GroupTreeObject newRoot = new GroupTreeObject(new TreeObject("root2", BMUI.type_folder, null));
        GroupTreeObject.createPath(gt3.getPath(), newRoot);
    }
}

