/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Condition;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;

public class ExportPolicyCSVAction
extends Action {
    private static String m_lastDirSelected = null;
    TreeViewer m_treeViewer = null;
    private ArrayList<GroupTreeObjectLast> m_elements = new ArrayList();
    private GroupTreeObject m_root = null;
    private String m_treeType = null;
    private File m_exportDir = null;
    char DELIMIT = (char)59;
    String delimiter = "" + this.DELIMIT;

    public ExportPolicyCSVAction(TreeViewer treeViewer, GroupTreeObject root) {
        super("ExportPolicyCSV");
        this.setText("Export Policies (CSV)");
        this.setId("export_Policy_CSV");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_root = root;
        this.m_treeViewer = treeViewer;
        this.m_treeType = (String)this.m_treeViewer.getData(PolicyListView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1001) < 2) {
            this.setEnabled(false);
        } else {
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            for (Object selected : sel) {
                if (!(selected instanceof GroupTreeObject)) continue;
                GroupTreeObject gto = (GroupTreeObject)selected;
                if (gto.isGroup()) {
                    this.m_elements.addAll(gto.getAllGTOLs());
                    continue;
                }
                this.m_elements.add((GroupTreeObjectLast)gto);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public ExportPolicyCSVAction(TreeViewer treeViewer, GroupTreeObject root, File dir) {
        super("ExportPolicyCSV");
        this.setText("Export Policies (CSV)");
        this.setId("export_Policy_CSV");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_treeViewer = treeViewer;
        this.m_root = root;
        this.m_exportDir = dir;
        this.m_treeType = (String)this.m_treeViewer.getData(ExportMPIView.TREE_VIEWER_TYPE);
        if (Repository.getInstance().getRights(1001) < 2) {
            this.setEnabled(false);
        } else {
            List<GroupTreeObject> list = root.getAllElements();
            for (GroupTreeObject gto : list) {
                if (!(gto instanceof GroupTreeObjectLast)) continue;
                this.m_elements.add((GroupTreeObjectLast)gto);
            }
            if (this.m_elements.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public boolean hasElements4Export() {
        return this.m_elements.size() > 0;
    }

    public void run() {
        if (this.m_elements.size() == 0) {
            return;
        }
        String dirName = null;
        if (this.m_treeType.equals(PolicyListView.POLICY_LIST)) {
            DirectoryDialog fd = new DirectoryDialog(this.m_treeViewer.getControl().getShell());
            fd.setText("Select directory");
            if (m_lastDirSelected != null) {
                fd.setFilterPath(m_lastDirSelected);
            }
            if ((dirName = fd.open()) == null) {
                return;
            }
            this.m_exportDir = new File(dirName);
            if (!this.m_exportDir.isDirectory()) {
                this.m_exportDir = this.m_exportDir.getParentFile();
            }
            m_lastDirSelected = this.m_exportDir.getPath();
            boolean doPoliciesExist = this.doPoliciesExist();
            if (doPoliciesExist) {
                String msg = "Do you want to overwrite existing Policies?";
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Overwrite", msg, "Overwrite", "Cancel");
                int res = dialog.open();
                if (res != 0) {
                    return;
                }
            }
        } else if (this.m_treeType.equals(ExportMPIView.POLICY_4EXPORT)) {
            if (this.m_exportDir == null) {
                return;
            }
            m_lastDirSelected = this.m_exportDir.getParent();
        }
        ProgressDialog pd = new ProgressDialog("  Export Policies", "", 0, this.m_elements.size());
        pd.setBlockOnOpen(false);
        pd.open();
        try {
            GroupTreeObject root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            HashMap<String, GroupTreeObject> recreated = new HashMap<String, GroupTreeObject>();
            int i = 0;
            while (i < this.m_elements.size()) {
                GroupTreeObjectLast gtol = this.m_elements.get(i);
                if (gtol != null) {
                    String type = gtol.getTreeObject().getType();
                    if (type == null) {
                        RTLogger.print(5, "type is null for element" + gtol);
                    } else {
                        pd.setProgress("Exporting Policies \"" + gtol.getName() + "\"", i + 1);
                        boolean isOK = false;
                        if (PolicyManager.getInstance().isPermittedPolicyRead(gtol)) {
                            isOK = this.exportPolicy(this.m_exportDir, gtol);
                        }
                        if (isOK) {
                            String path = gtol.getParentPath();
                            try {
                                GroupTreeObjectLast nGtol;
                                GroupTreeObject createdLast;
                                if (!recreated.containsKey(path)) {
                                    GroupTreeObject.createPath(path, root);
                                    createdLast = root.searchPath(path, BMUI.type_folder);
                                    recreated.put(path, createdLast);
                                    nGtol = new GroupTreeObjectLast(gtol.getTreeObject(), null, gtol.getIcon());
                                    createdLast.addElement(nGtol);
                                } else {
                                    createdLast = (GroupTreeObject)recreated.get(path);
                                    nGtol = new GroupTreeObjectLast(gtol.getTreeObject(), null, gtol.getIcon());
                                    createdLast.addElement(nGtol);
                                }
                            }
                            catch (RuntimeException runtimeException) {}
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                pd.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    private boolean doPoliciesExist() {
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObjectLast gtol = this.m_elements.get(i);
            if (gtol != null) {
                String type = gtol.getType();
                String fileName = null;
                if (type.equals(BMUI.type_mon)) {
                    fileName = String.valueOf(gtol.getName()) + "." + BMUI.type_mon + BMUI.file_extension_xml;
                } else if (type.equals(BMUI.type_msg)) {
                    fileName = String.valueOf(gtol.getName()) + "." + BMUI.type_msg + BMUI.file_extension_xml;
                }
                if (fileName != null) {
                    try {
                        File file = new File(this.m_exportDir + File.separator + fileName);
                        if (file.exists()) {
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean exportPolicy(File dir, GroupTreeObjectLast gtol) {
        boolean isSuccess = false;
        RTLogger.print(5, "Export Policy ..." + gtol.getName());
        File fileP = null;
        String type = gtol.getTreeObject().getType();
        try {
            if (type.equals(BMUI.type_mon)) {
                fileP = Repository.getInstance().fetchFile(gtol.getName(), type);
            } else if (type.equals(BMUI.type_msg)) {
                fileP = Repository.getInstance().fetchFile(gtol.getName(), type);
            }
        }
        catch (Throwable throwable) {}
        if (fileP == null) {
            String msg = "Server failed to find requested Policy. " + gtol.getName();
            RTLogger.print(5, msg);
            new ShowMessageBox("Error getting Policy", msg, 1);
            return isSuccess;
        }
        int length = fileP.getName().length();
        File target = new File(dir, String.valueOf(fileP.getName().substring(0, length - 3)) + "csv");
        MsgPolicy mp = null;
        PolicyManager pm = PolicyManager.getInstance();
        if (type.equals(BMUI.type_msg)) {
            mp = pm.getMessagePolicy(fileP);
            if (mp != null) {
                String polName = mp.getName();
                String polVer = mp.getVersion();
                String polDescr = mp.getDescription();
                Iterator itC = mp.getConditions().getConditionList().iterator();
                int condSize = 0;
                while (itC.hasNext()) {
                    ++condSize;
                    itC.next();
                }
                String polHeadComment = "";
                polHeadComment = polDescr.isEmpty() ? "Indication Policy: " + polName + "\nVersion: " + polVer + "\nConditions exported: " + condSize : "Indication Policy: " + polName + " (" + polDescr + ")" + "\nVersion: " + polVer + "\nConditions exported: " + condSize;
                try {
                    Throwable throwable = null;
                    Object var17_28 = null;
                    try (FileWriter fw = new FileWriter(target);){
                        CSVFormat format = CSVFormat.EXCEL.withDelimiter(this.DELIMIT);
                        format = format.withHeaderComments(new Object[]{polHeadComment});
                        format = format.withCommentMarker('#');
                        format = format.withHeader(new String[]{"No", "DESCRIPTION", "ADVICE", "INSTR-URL", "AV", "KPI", "DUPLICATES", "DE-DUP KEYONLY", "CLOSED", "INDICATION KEY", "CLOSE MASK", "APPLICATION", "GROUP", "OBJECT", "HOST", "SEVERITY", "SET APPLICATION", "SET GROUP", "SET OBJECT", "SET HOST", "SET SEVERITY", "SEARCH TEXT", "TEXT", "SILENCE TIME", "SILENCE COUNT", "AUTO ACTION", "AA HOST", "AA TIMEOUT", "OP ACTION", "COND TYPE"});
                        CSVPrinter printer = format.print((Appendable)fw);
                        int seq = 0;
                        Iterator it = mp.getConditions().getConditionList().iterator();
                        while (it.hasNext()) {
                            new StringBuffer();
                            MsgCondition mc = (MsgCondition)it.next();
                            String seqNo = Integer.toString(++seq);
                            String condAdvice = mc.getHelptext();
                            mc.getActionType();
                            String condDescr = mc.getDescription();
                            condDescr = this.escapeSpecialCharacters(condDescr);
                            String condInstr = mc.getInstructionAction();
                            String condAV = mc.getTypeA() == 1 ? "true" : "false";
                            String condKPI = mc.getTypeK() == 1 ? "true" : "false";
                            String condIsDedupl = mc.isDedupl() ? "true" : "false";
                            String condIsDeduplKeyOnly = mc.isDeduplKeyOnly() ? "true" : "false";
                            String condClosed = mc.getInsertClosed() == 1 ? "true" : "false";
                            String condIndKey = mc.getKey();
                            String condCloseMask = mc.getCloseMask();
                            String condAppl = mc.getApplicationFilter();
                            String condGrp = mc.getGroupFilter();
                            String condObj = mc.getObjectFilter();
                            String condHost = mc.getNodeFilter();
                            String condSev = mc.getSeverityFilter();
                            String condSetAppl = mc.getSetApplication();
                            String condSetGrp = mc.getSetGroup();
                            String condSetObj = mc.getSetObject();
                            String condSetHost = mc.getSetNode();
                            String condSetSev = mc.getSetSeverity();
                            String condSearchText = mc.getTextFilter();
                            String condText = mc.getSetText();
                            String condSilenceTime = Integer.toString(mc.getSuppressInterval());
                            String condSilenceCount = Integer.toString(mc.getSuppressCount());
                            String condAA = mc.getAutoAction();
                            String condAAHost = mc.getAutoAction_Node();
                            String condAATimeout = Integer.toString(mc.getAutoActionTimeout());
                            String condOPAction = mc.getOpAction();
                            String condCondType = mc.getActionType();
                            printer.printRecord(new Object[]{seqNo, condDescr, condAdvice, condInstr, condAV, condKPI, condIsDedupl, condIsDeduplKeyOnly, condClosed, condIndKey, condCloseMask, condAppl, condGrp, condObj, condHost, condSev, condSetAppl, condSetGrp, condSetObj, condSetHost, condSetSev, condSearchText, condText, condSilenceTime, condSilenceCount, condAA, condAAHost, condAATimeout, condOPAction, condCondType});
                        }
                        printer.flush();
                        printer.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(5, "", e);
                    new ShowMessageBox("Export stopped", "Runtime Error: " + e.getMessage(), 2);
                }
                RTLogger.print(4, "Finished exporting Indication Policy (CSV).");
                return isSuccess;
            }
            String msg = "Server not able finding requested Policy. " + gtol.getName();
            RTLogger.print(5, msg);
            new ShowMessageBox("Error finding Policy", msg, 1);
            return isSuccess;
        }
        Policy p = pm.getMonitorPolicy(fileP);
        if (p == null) return isSuccess;
        String polName = p.getName();
        String polVer = p.getVersion();
        String polDescr = p.getDescription();
        Iterator itC = p.getConditions().getConditionList().iterator();
        int condSize = 0;
        while (itC.hasNext()) {
            ++condSize;
            itC.next();
        }
        String polHeadComment = "";
        polHeadComment = polDescr.isEmpty() ? "Monitor Policy: " + polName + "\nVersion: " + polVer + "\nCondtions exported: " + condSize : "Monitor Policy: " + polName + " (" + polDescr + ")" + "\nVersion: " + polVer + "\nConditions exported: " + condSize;
        try {
            Throwable throwable = null;
            Object var18_34 = null;
            try (FileWriter fw = new FileWriter(target);){
                CSVFormat format = CSVFormat.EXCEL.withDelimiter(this.DELIMIT);
                format = format.withHeaderComments(new Object[]{polHeadComment});
                format = format.withCommentMarker('#');
                format = format.withHeader(new String[]{"No", "DESCRIPTION", "ADVICE", "INSTR-URL", "AV", "KPI", "DUPLICATES", "DE-DUP KEYONLY", "CLOSED", "INDICATION KEY", "CLOSE MASK", "SET APPLICATION", "SET GROUP", "SET OBJECT", "SET HOST", "THRESHOLD", "RESET", "IGNORE RESET", "RESET COND-STATE", "TEXT", "SILENCE COUNT", "AUTO ACTION", "AA HOST", "AA TIMEOUT", "OP ACTION", "COND TYPE"});
                CSVPrinter printer = format.print((Appendable)fw);
                int seq = 0;
                Iterator it = p.getConditions().getConditionList().iterator();
                while (it.hasNext()) {
                    new StringBuffer();
                    Condition c = (Condition)it.next();
                    String condDescr = c.getDescription();
                    condDescr = this.escapeSpecialCharacters(condDescr);
                    String seqNo = Integer.toString(++seq);
                    String condAdvice = c.getHelptext();
                    String condInstr = c.getInstructionAction();
                    String condAV = c.getTypeA() == 1 ? "true" : "false";
                    String condKPI = c.getTypeK() == 1 ? "true" : "false";
                    String condIsDedupl = c.isDedupl() ? "true" : "false";
                    String condIsDeduplKeyOnly = c.isDeduplKeyOnly() ? "true" : "false";
                    String condClosed = c.getInsertClosed() == 1 ? "true" : "false";
                    String condIndKey = c.getKey();
                    String condCloseMask = c.getCloseMask();
                    String condSetAppl = c.getSetApplication();
                    String condSetGrp = c.getSetGroup();
                    String condSetObj = c.getSetObject();
                    String condSetHost = c.getSetNode();
                    String condThreshold = Double.toString(c.getThreshold());
                    String condReset = Double.toString(c.getReset());
                    String condIsIgnoreReset = c.isIgnoreReset() ? "true" : "false";
                    String condResetStateMin = Integer.toString(c.getResetStateMinutes());
                    String condText = c.getSetText();
                    String condSilenceCount = Double.toString(c.getSilenceCount());
                    String condAA = c.getAutoAction();
                    String condAAHost = c.getAutoAction_Node();
                    String condAATimeout = Integer.toString(c.getAutoActionTimeout());
                    String condOPAction = c.getOpAction();
                    String condCondType = c.getActionType();
                    printer.printRecord(new Object[]{seqNo, condDescr, condAdvice, condInstr, condAV, condKPI, condIsDedupl, condIsDeduplKeyOnly, condClosed, condIndKey, condCloseMask, condSetAppl, condSetGrp, condSetObj, condSetHost, condThreshold, condReset, condIsIgnoreReset, condResetStateMin, condText, condSilenceCount, condAA, condAAHost, condAATimeout, condOPAction, condCondType});
                }
                printer.flush();
                printer.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "", e);
            new ShowMessageBox("Export stopped", "Runtime Error: " + e.getMessage(), 2);
        }
        RTLogger.print(4, "Finished exporting Monitor Policy (CSV).");
        return isSuccess;
    }

    public String escapeSpecialCharacters(String data) {
        String escapedData = data.replaceAll("\\R", " ");
        if (data.contains(this.delimiter) || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    public static void main(String[] args) {
        GroupTreeObject gt = new GroupTreeObject(new TreeObject("root1", BMUI.type_folder, null));
        GroupTreeObject gt1 = new GroupTreeObject(new TreeObject("A1", BMUI.type_folder, null));
        gt.addElement(gt1);
        GroupTreeObject gt2 = new GroupTreeObject(new TreeObject("B1", BMUI.type_folder, null));
        gt1.addElement(gt2);
        GroupTreeObject gt3 = new GroupTreeObject(new TreeObject("C1", BMUI.type_folder, null));
        gt2.addElement(gt3);
        GroupTreeObject newRoot = new GroupTreeObject(new TreeObject("root2", BMUI.type_folder, null));
        GroupTreeObject.createPath(gt3.getPath(), newRoot);
    }
}

