/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.views.actions.ExportXMLTree;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.w3c.dom.Document;

public class ExportTreeAction
extends Action {
    private GroupTreeObject m_root = null;

    public ExportTreeAction(GroupTreeObject root) {
        super("ExportTree");
        this.setText("Export Tree");
        this.setId("export_tree");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_root = root;
        this.setEnabled(true);
    }

    public void run() {
        try {
            ExportXMLTree xt = new ExportXMLTree();
            GroupTreeObject topElement = new GroupTreeObject(new TreeObject("Assignments", null, null));
            topElement.addElements(this.m_root.getElements());
            GroupTreeObject newRoot = new GroupTreeObject(new TreeObject("root", null, null));
            newRoot.addElement(topElement);
            Document doc = xt.getXML(newRoot);
            FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8196);
            fd.setFilterExtensions(new String[]{"*.xml"});
            String filePath = fd.open();
            if (filePath == null) {
                return;
            }
            XMLFactory.writeXml(doc, filePath);
            MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 2);
            mb.setText("OK");
            mb.setMessage("Assignment tree exported to:\n" + filePath);
            mb.open();
        }
        catch (RuntimeException e1) {
            MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 1);
            mb.setText("Error");
            mb.setMessage("Assignment tree failed to export.\n" + e1.getMessage());
            mb.open();
        }
    }
}

