/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.actions.AgentRemoteAction;
import com.blixx.boom.gui.views.actions.AgentRemoteActionOnSelected;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class FastActionsSubMenu
extends Action {
    private com.blixx.shared.Action m_action = null;
    private TreeViewer m_treeViewer = null;
    private TableViewer m_tableViewer = null;
    private String m_type = null;
    protected Shell m_parentShell = null;
    private static final String RUN_FAST_ACTION = "runfastaction";
    private static final String TYPE_FAST_ACTION = "FAST_ACTION";
    private static final String TYPE_FAST_ACTION_WITH_HOSTS = "FAST_ACTION_WITH_HOSTS";

    public FastActionsSubMenu(com.blixx.shared.Action action) {
        super(RUN_FAST_ACTION);
        this.setId(RUN_FAST_ACTION);
        this.m_action = action;
        this.m_type = TYPE_FAST_ACTION;
        this.setText(this.m_action.m_label);
        this.setImageDescriptor(BMUI.IMAGE_DESCR_ACTION);
        if (Repository.getInstance().getRights(1007) < 2 || this.m_action == null || this.m_action.m_serverAction) {
            this.setEnabled(false);
        }
    }

    public FastActionsSubMenu(Shell shell, com.blixx.shared.Action action, TreeViewer treeViewer) {
        super(RUN_FAST_ACTION);
        this.setId(RUN_FAST_ACTION);
        this.m_parentShell = shell;
        this.m_action = action;
        this.m_treeViewer = treeViewer;
        this.m_type = TYPE_FAST_ACTION_WITH_HOSTS;
        this.setText(this.m_action.m_label);
        this.setImageDescriptor(BMUI.IMAGE_DESCR_ACTION);
        if (Repository.getInstance().getRights(1007) < 2 || this.m_parentShell == null || this.m_action == null || this.m_action.m_serverAction || this.m_treeViewer == null) {
            this.setEnabled(false);
        }
    }

    public FastActionsSubMenu(Shell shell, com.blixx.shared.Action action, TableViewer tableViewer) {
        super(RUN_FAST_ACTION);
        this.setId(RUN_FAST_ACTION);
        this.m_parentShell = shell;
        this.m_action = action;
        this.m_tableViewer = tableViewer;
        this.m_type = TYPE_FAST_ACTION_WITH_HOSTS;
        this.setText(this.m_action.m_label);
        this.setImageDescriptor(BMUI.IMAGE_DESCR_ACTION);
        if (Repository.getInstance().getRights(1007) < 2 || this.m_parentShell == null || this.m_action == null || this.m_action.m_serverAction || this.m_tableViewer == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_action == null) {
            RTLogger.print(5, "Error running Fast-Action! Action is null.");
            return;
        }
        switch (this.m_type) {
            case "FAST_ACTION": {
                try {
                    String actionGroup = this.getActionGtolByActionID(this.m_action.m_ID).getParent().getName();
                    AgentRemoteAction remoteAction = new AgentRemoteAction("Run: " + this.m_action.m_label, this.m_action, actionGroup);
                    remoteAction.run();
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
                break;
            }
            case "FAST_ACTION_WITH_HOSTS": {
                try {
                    if (this.m_treeViewer != null) {
                        AgentRemoteActionOnSelected remoteAction = new AgentRemoteActionOnSelected(this.m_parentShell, this.m_action, this.m_treeViewer);
                        remoteAction.run();
                        break;
                    }
                    if (this.m_tableViewer == null) break;
                    AgentRemoteActionOnSelected remoteAction = new AgentRemoteActionOnSelected(this.m_parentShell, this.m_action, this.m_tableViewer);
                    remoteAction.run();
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
                break;
            }
        }
    }

    public static List<com.blixx.shared.Action> getFastActions(TreeViewer treeViewer) {
        GroupTreeObject actRoot = null;
        actRoot = treeViewer != null ? Repository.getInstance().getActionTree((Viewer)treeViewer) : Repository.getInstance().getActionTree();
        List<String> fastActionIDs = UISettings.getInstance().getActionSettings();
        ArrayList<com.blixx.shared.Action> fastActions = new ArrayList<com.blixx.shared.Action>();
        for (GroupTreeObjectLast gtol : actRoot.getAllGTOLs()) {
            Object o = gtol.getTreeObject().getObject();
            if (o == null || !(o instanceof com.blixx.shared.Action)) continue;
            com.blixx.shared.Action action = (com.blixx.shared.Action)o;
            if (!fastActionIDs.contains(action.m_ID)) continue;
            fastActions.add(action);
        }
        return fastActions;
    }

    private GroupTreeObjectLast getActionGtolByActionID(String id) {
        GroupTreeObject actionTree = Repository.getInstance().m_actionRepository.getTree();
        for (GroupTreeObjectLast gtol : actionTree.getAllGTOLs()) {
            Object o = gtol.getTreeObject().getObject();
            if (o == null || !(o instanceof com.blixx.shared.Action)) continue;
            com.blixx.shared.Action action = (com.blixx.shared.Action)o;
            if (!id.equals(action.m_ID)) continue;
            return gtol;
        }
        return null;
    }
}

