/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.actions.AddToFastRemoteAction;
import com.blixx.boom.gui.views.actions.AgentRemoteAction;
import com.blixx.boom.gui.views.actions.AgentRemoteActionOnSelected;
import com.blixx.boom.gui.views.actions.FastActionsSubMenu;
import com.blixx.boom.gui.views.actions.RemoveFromFastRemoteAction;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class FastAndRemoteActions {
    private static final String ACTION_TREE = "ACTION_TREE";
    private static final String NODE_TREE = "NODE_TREE";
    private static final String AGENT_OVERVIEW_TABLE = "AGENT_OVERVIEW_TABLE";
    private static final String MESSAGE_BROWSER_TABLE = "MESSAGE_BROWSER_TABLE";
    private String m_type = null;
    private IMenuManager m_manager = null;
    private Shell m_shell = null;
    private TreeViewer m_treeViewer = null;
    private TableViewer m_tableViewer = null;
    private SEventFwd m_firstElement = null;
    private int m_sselCount = 0;
    private com.blixx.shared.Action m_action = null;
    private GroupTreeObjectLast m_gtol = null;

    public FastAndRemoteActions(IMenuManager manager, TreeViewer treeViewer, com.blixx.shared.Action action, GroupTreeObjectLast gtol) {
        this.m_type = ACTION_TREE;
        this.m_manager = manager;
        this.m_treeViewer = treeViewer;
        this.m_action = action;
        this.m_gtol = gtol;
    }

    public FastAndRemoteActions(IMenuManager manager, Shell shell, TreeViewer treeViewer) {
        this.m_type = NODE_TREE;
        this.m_manager = manager;
        this.m_shell = shell;
        this.m_treeViewer = treeViewer;
    }

    public FastAndRemoteActions(IMenuManager manager, Shell shell, TableViewer tableViewer) {
        this.m_type = AGENT_OVERVIEW_TABLE;
        this.m_manager = manager;
        this.m_shell = shell;
        this.m_tableViewer = tableViewer;
    }

    public FastAndRemoteActions(IMenuManager manager, Shell shell, TableViewer tableViewer, SEventFwd firstElement, int sselCount) {
        this.m_type = MESSAGE_BROWSER_TABLE;
        this.m_manager = manager;
        this.m_shell = shell;
        this.m_tableViewer = tableViewer;
        this.m_firstElement = firstElement;
        this.m_sselCount = sselCount;
    }

    public void addActions() {
        this.addAgentRemoteActionOnSelected();
        this.addFastActionSubMenu();
    }

    public void addAgentRemoteActionOnSelected() {
        switch (this.m_type) {
            case "ACTION_TREE": {
                this.m_manager.add((IAction)new AgentRemoteAction("Run: " + this.m_action.m_label, this.m_action, this.m_gtol.getParent().getName()));
                break;
            }
            case "NODE_TREE": {
                this.m_manager.add((IAction)new AgentRemoteActionOnSelected(this.m_shell, this.m_treeViewer));
                break;
            }
            case "AGENT_OVERVIEW_TABLE": {
                this.m_manager.add((IAction)new AgentRemoteActionOnSelected(this.m_shell, this.m_tableViewer));
                break;
            }
            case "MESSAGE_BROWSER_TABLE": {
                this.m_manager.add((IAction)new AgentRemoteActionOnSelected(this.m_shell, this.m_sselCount, this.m_firstElement));
            }
        }
    }

    public void addFastActionSubMenu() {
        block23: {
            List<com.blixx.shared.Action> fastActions;
            block22: {
                fastActions = FastActionsSubMenu.getFastActions(null);
                if (!fastActions.isEmpty()) break block22;
                Action placeholderAction = new Action("Fast-Actions..."){};
                placeholderAction.setEnabled(false);
                this.m_manager.add((IAction)placeholderAction);
                break block23;
            }
            MenuManager menuMgr = new MenuManager("Fast-Actions...", "runFastAction");
            for (com.blixx.shared.Action action : fastActions) {
                switch (this.m_type) {
                    case "ACTION_TREE": {
                        menuMgr.add((IAction)new FastActionsSubMenu(action));
                        break;
                    }
                    case "NODE_TREE": {
                        menuMgr.add((IAction)new FastActionsSubMenu(this.m_shell, action, this.m_treeViewer));
                        break;
                    }
                    case "AGENT_OVERVIEW_TABLE": {
                        menuMgr.add((IAction)new FastActionsSubMenu(this.m_shell, action, this.m_tableViewer));
                        break;
                    }
                    case "MESSAGE_BROWSER_TABLE": {
                        menuMgr.add((IAction)new FastActionsSubMenu(this.m_shell, action, this.m_tableViewer));
                    }
                }
            }
            this.m_manager.add((IContributionItem)menuMgr);
        }
        if (this.m_type.endsWith(ACTION_TREE)) {
            if (this.m_gtol == null) {
                return;
            }
            com.blixx.shared.Action action = this.getActionObject(this.m_gtol);
            if (action.m_serverAction) {
                return;
            }
            if (UISettings.getInstance().getActionSettings().contains(action.m_ID)) {
                this.m_manager.add((IAction)new RemoveFromFastRemoteAction(this.m_action));
            } else {
                this.m_manager.add((IAction)new AddToFastRemoteAction(this.m_action));
            }
        }
    }

    public boolean selectionContainsRunnableAgents(StructuredSelection ssel) {
        List<AgentCard> nonRunnableAgents = this.getNonRunnableAgents();
        switch (this.m_type) {
            case "NODE_TREE": {
                for (GroupTreeObject gto : ssel) {
                    if (gto instanceof GroupTreeObjectLast) {
                        try {
                            Object o = ((GroupTreeObjectLast)gto).getTreeObject().getObject();
                            if (nonRunnableAgents.contains((AgentCard)o)) continue;
                            return true;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    for (GroupTreeObjectLast gtol : gto.getAllGTOLs()) {
                        try {
                            Object o = gtol.getTreeObject().getObject();
                            if (o == null || !(o instanceof AgentCard) || nonRunnableAgents.contains((AgentCard)o)) continue;
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                }
                break;
            }
            case "AGENT_OVERVIEW_TABLE": {
                for (Object o : ssel) {
                    if (!(o instanceof AgentCard) || nonRunnableAgents.contains((AgentCard)o)) continue;
                    return true;
                }
                break;
            }
            case "MESSAGE_BROWSER_TABLE": {
                for (Object obj : ssel) {
                    AgentCard ac;
                    String agentID;
                    if (!(obj instanceof SEventFwd) || (agentID = ((SEventFwd)obj).getT1()) == null || agentID.length() <= 0 || nonRunnableAgents.contains(ac = Repository.getInstance().getAgentCard(agentID))) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private List<AgentCard> getNonRunnableAgents() {
        ArrayList<AgentCard> nonRunnableAgents = new ArrayList<AgentCard>();
        switch (this.m_type) {
            case "NODE_TREE": {
                Object obj = this.m_treeViewer.getTree().getData();
                if (!(obj instanceof GroupTreeObject)) break;
                GroupTreeObject root = (GroupTreeObject)obj;
                for (GroupTreeObject gto : root.getElements()) {
                    if (gto.getName().equals("_Groups")) continue;
                    for (GroupTreeObjectLast gtol : gto.getAllGTOLs()) {
                        Object o = gtol.getTreeObject().getObject();
                        if (o == null || !(o instanceof AgentCard)) continue;
                        AgentCard ac = (AgentCard)o;
                        if (!gtol.getPath().contains("_External") && !gtol.getPath().contains("Connecting...") && ac.isApproved()) continue;
                        nonRunnableAgents.add((AgentCard)o);
                    }
                }
                break;
            }
            case "MESSAGE_BROWSER_TABLE": 
            case "AGENT_OVERVIEW_TABLE": {
                TableItem[] tableItems = this.m_tableViewer.getTable().getItems();
                int i = 0;
                while (i < tableItems.length) {
                    AgentCard ac;
                    Object o = tableItems[i].getData();
                    if (o != null && o instanceof AgentCard && ((ac = (AgentCard)o).isExternal() || !ac.isApproved() || ac.getOSName().contains("Connecting..."))) {
                        nonRunnableAgents.add(ac);
                    }
                    ++i;
                }
                break;
            }
        }
        return nonRunnableAgents;
    }

    private com.blixx.shared.Action getActionObject(GroupTreeObjectLast gtol) {
        com.blixx.shared.Action action = null;
        try {
            Object o = gtol.getTreeObject().getObject();
            if (o instanceof com.blixx.shared.Action) {
                action = (com.blixx.shared.Action)o;
            }
        }
        catch (Exception exception) {}
        return action;
    }
}

