/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.AgentTreeDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.ScErrorShowMessage;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScLinkAgent2NodeGroup;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public class GtoAddAgentLinkAction
extends Action {
    private TreeViewer m_treeViewer = null;
    private GroupTreeObject m_root = null;
    private String m_localPath = null;
    private String m_srvPath = null;
    private String m_filename = null;
    private String m_parentName = null;
    private String m_parentPath = null;
    private String m_parentType = null;

    public GtoAddAgentLinkAction(TreeViewer treeViewer, String fname, String srvPath, String localpath, String parentName, String parentPath, String parentType, GroupTreeObject root) {
        this.setText("Link Agent");
        this.setId("AddHostsGTOL");
        this.m_treeViewer = treeViewer;
        this.m_parentName = parentName;
        this.m_parentPath = parentPath;
        this.m_parentType = parentType;
        this.m_root = root;
        this.m_localPath = localpath;
        this.m_srvPath = srvPath;
        this.m_filename = fname;
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
        this.setEnabled(Repository.getInstance().isPermittedNodeGroupModify(this.m_root.searchPath(parentPath, parentType)));
    }

    public void run() {
        List<AgentCard> agents = null;
        AgentTreeDialog atd = new AgentTreeDialog(Display.getCurrent().getActiveShell(), "Select Agents");
        atd.setBlockOnOpen(true);
        try {
            atd.open();
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        agents = atd.getSelectedAgentCards(false);
        if (agents.size() == 0) {
            return;
        }
        GroupTreeObject parent = this.m_root.searchPath(this.m_parentPath, this.m_parentType);
        if (parent == null) {
            new ShowMessageBox("  Missing Node Group", "Cannot link Agent to the Group '" + this.m_parentName + "'. Group does not exist!", 2);
            return;
        }
        ArrayList<String> agentIDs = new ArrayList<String>(agents.size());
        for (AgentCard ac : agents) {
            agentIDs.add(ac.getAgentID());
        }
        final List<AgentCard> fagents = agents;
        ScLinkAgent2NodeGroup scAl = new ScLinkAgent2NodeGroup(Repository.getInstance(), this.m_parentPath, agentIDs);
        scAl.addCmdPostProcess(new ICmdPostProcess(){

            public void postProcess(ServerClient cmd) {
                if (!cmd.isSupported()) {
                    GroupTreeObject parent = GtoAddAgentLinkAction.this.m_root.searchPath(GtoAddAgentLinkAction.this.m_parentPath, GtoAddAgentLinkAction.this.m_parentType);
                    int i = 0;
                    while (i < fagents.size()) {
                        AgentCard ac = (AgentCard)fagents.get(i);
                        GroupTreeObjectLast newGTO = new GroupTreeObjectLast(ac, ac.getAgentID(), "IMAGE_PC");
                        try {
                            parent.addElement(newGTO);
                        }
                        catch (Throwable throwable) {}
                        ++i;
                    }
                    GroupTreeObject rroot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                    rroot.addElement(GtoAddAgentLinkAction.this.m_root);
                    GtoAddAgentLinkAction.this.m_treeViewer.setExpandedState((Object)parent, true);
                    XMLTree xt = new XMLTree();
                    Document doc = xt.getXML(rroot);
                    XMLFactory.writeXml(doc, String.valueOf(GtoAddAgentLinkAction.this.m_localPath) + GtoAddAgentLinkAction.this.m_filename);
                    com.blixx.boom.engine.ServerClient sc = com.blixx.boom.engine.ServerClient.putFile(String.valueOf(GtoAddAgentLinkAction.this.m_srvPath) + GtoAddAgentLinkAction.this.m_filename, String.valueOf(GtoAddAgentLinkAction.this.m_localPath) + GtoAddAgentLinkAction.this.m_filename);
                    Repository.getJobManager().schedule(sc);
                }
            }
        });
        scAl.addCmdPostProcess(new ScErrorShowMessage("Error linking Agents to node group: " + this.m_parentPath));
        Repository.getJobManager().schedule(scAl);
    }
}

