/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.BinaryTreeDialog;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.ctrl.sc.in.ScDeploy;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class GtoAddBinaryLinkAction
extends Action {
    private STreeViewer treeViewer = null;
    private GroupTreeObject folder = null;

    public GtoAddBinaryLinkAction(STreeViewer treeViewer, GroupTreeObject folder) {
        this.setText("Link Package");
        this.setId("LinkPackage");
        this.treeViewer = treeViewer;
        this.folder = folder;
        if (treeViewer == null || folder == null) {
            this.setEnabled(false);
        } else if (!PolicyManager.getInstance().isPermittedPGAModify(folder)) {
            this.setEnabled(false);
        }
    }

    public void run() {
        BinaryTreeDialog dialog = new BinaryTreeDialog(Display.getCurrent().getActiveShell(), "Select Packages");
        dialog.setBlockOnOpen(true);
        try {
            dialog.open();
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        List<Object> elements = dialog.getSelectedPackages();
        if (elements == null || elements.size() == 0) {
            return;
        }
        List<ScDeploy.NameType> packagesToDeploy = this.addPackageLinks(elements);
        this.triggerDeployment(packagesToDeploy);
    }

    private List<ScDeploy.NameType> addPackageLinks(List<Object> elements) {
        RTLogger.print(5, "Link packages to AsnTree: " + elements.size() + " elements");
        LinkedList<ScDeploy.NameType> toDeploy = new LinkedList<ScDeploy.NameType>();
        String title = "  Add Links";
        ProgressDialog pd = new ProgressDialog(title, "", 0, elements.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int progressNumber = 0;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        try {
            scBatch.openSocket();
            UpdateServer usrv = new UpdateServer();
            boolean isSuccess = false;
            for (Object o : elements) {
                GroupTreeObject gto = null;
                ITreeObject to = null;
                String sourcePath = null;
                if (!(o instanceof GroupTreeObjectLast) && o instanceof GroupTreeObject) {
                    gto = (GroupTreeObject)o;
                    to = gto.getTreeObject();
                    sourcePath = gto.getPath();
                    isSuccess = usrv.syncAsnWithServer(scBatch, sourcePath, this.folder.getPath(), CMDS.ACTION_ADDLINK, gto.getType());
                    if (isSuccess) {
                        pd.setProgress("Add Binary Link  '" + gto.getName() + "'", ++progressNumber);
                        try {
                            this.folder.addElement(new GroupTreeObjectLast(to, sourcePath, "IMAGE_PKG_LNK"));
                            ScDeploy.NameType nt = new ScDeploy.NameType(gto.getName(), gto.getType());
                            toDeploy.add(nt);
                        }
                        catch (Exception e) {
                            RTLogger.print(5, "Link Package to AsnTree: " + e.getMessage());
                        }
                    }
                }
                if (isSuccess) continue;
                MessageDialog.openError((Shell)this.treeViewer.getControl().getShell(), (String)"Error updating server", (String)usrv.m_resultString);
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
        this.treeViewer.refresh();
        this.treeViewer.setExpandedState(this.folder, true);
        return toDeploy;
    }

    private void triggerDeployment(List<ScDeploy.NameType> toDeploy) {
        Map<AgentCard, String> related;
        GroupTreeObject pga;
        if (toDeploy.size() > 0 && BMUI.type_assignment_pol.equals((pga = this.folder.findFirstParent(BMUI.type_assignment_pol)).getType()) && (related = Repository.getInstance().getAllAssignments().getAgentID2AssignmentGroupID(pga.getName())) != null && related.size() > 0) {
            String title1 = toDeploy.size() > 1 ? "Trigger Deployments" : "Trigger Deployment";
            String header = toDeploy.size() > 1 ? "Trigger Deployments now?\n\nRelated Agents:" : "Trigger Deployment now?\n\nRelated Agent:";
            String footer = related.size() > 1 ? "Total: " + related.size() + " Agents" : "Total: " + related.size() + " Agent";
            ShowMessageDialog smd = new ShowMessageDialog(this.treeViewer.getControl().getShell(), title1, header, footer, true, "OK", new ArrayList<AgentCard>(related.keySet()), "No related Agents found");
            smd.setBlockOnOpen(true);
            int res = smd.open();
            if (res == 0) {
                StringBuilder agentIDs = new StringBuilder();
                Iterator<AgentCard> it = related.keySet().iterator();
                while (it.hasNext()) {
                    agentIDs.append(it.next().getAgentID());
                    if (!it.hasNext()) continue;
                    agentIDs.append(',');
                }
                ScDeploy sd = new ScDeploy(Repository.getInstance(), agentIDs.toString(), toDeploy.toArray(new ScDeploy.NameType[0]));
                JobManager.getInstance().schedule(sd);
            } else {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentsSummaryView.getInstance());
            }
        }
    }
}

