/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GActionsRepository;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.actions.RefreshTreeAction;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class ImportActionGroup
extends Action {
    private static String m_lastDirSelected = null;

    public ImportActionGroup() {
        super("ImportActionGroup");
        this.setText("Import Actions");
        this.setId("Import_Actions");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_IMPORT);
        if (Repository.getInstance().getRights(1007) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 2);
        if (m_lastDirSelected != null) {
            fd.setFilterPath(m_lastDirSelected);
        }
        fd.setText("Select an Action File");
        fd.setFilterExtensions(new String[]{"*" + BMUI.file_extension_act});
        String fileFIRST = fd.open();
        String[] fnames = fd.getFileNames();
        String path = fd.getFilterPath();
        if (fnames == null || fnames.length == 0) {
            return;
        }
        m_lastDirSelected = fileFIRST;
        GActionsRepository GA = Repository.getInstance().m_actionRepository;
        int i = 0;
        while (i < fnames.length) {
            block20: {
                String groupName;
                List<com.blixx.shared.Action> actions;
                block19: {
                    String pName = String.valueOf(path) + File.separator + fnames[i];
                    File source = new File(pName);
                    actions = null;
                    try {
                        actions = GA.loadActions(source);
                        if (actions == null || actions.size() == 0) {
                            new ShowMessageBox("Warning", "No actions available in the file:\n" + pName, 8);
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        new ShowMessageBox("Error", "Import failed for file:\n" + pName, 1);
                    }
                    break block20;
                }
                String finGroupName = groupName = fnames[i].replace(BMUI.file_extension_act, "");
                int n = 1;
                while (GA.isActionGroupExist(finGroupName)) {
                    finGroupName = String.valueOf(groupName) + "(" + n + ")";
                    ++n;
                }
                UpdateServer usrv = new UpdateServer();
                String[] arr = new String[]{finGroupName};
                boolean isSuccess = usrv.syncWithActionServer(CMDS.ACTION_ADD, arr);
                if (isSuccess) {
                    ProgressDialog pd = new ProgressDialog("Import actions", "", 0, actions.size());
                    pd.setBlockOnOpen(false);
                    pd.open();
                    int count = 0;
                    try {
                        Iterator<com.blixx.shared.Action> it = actions.iterator();
                        while (it.hasNext()) {
                            ServerClient sc;
                            com.blixx.shared.Action a = it.next();
                            pd.setProgress("Importing \"" + a.m_label + "\"", ++count);
                            if (GA.m_knownActions.containsKey(a.m_ID)) {
                                a.m_ID = UUID.randomUUID().toString();
                            }
                            if ((sc = GA.saveAction(a, finGroupName)).isSuccess()) {
                                RTLogger.print(3, "Action Import OK: " + a.m_label + " Group:" + finGroupName);
                                continue;
                            }
                            RTLogger.print(3, "UPDATEACTION Error: " + sc.getResultObject());
                            new ShowMessageBox("Import Action", "Error saving the Action:" + a.m_label, 1);
                            it.remove();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    new ShowMessageBox("Import Action Group", "Error creation Action group", 1);
                }
            }
            ++i;
        }
        RefreshTreeAction rta = new RefreshTreeAction(null, "GETACTIONS", null, null);
        rta.run();
    }
}

