/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ImportMPIPropertiesDialog;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.omu.PolicyConvereter;
import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportOVPolicy
extends Action {
    private static String m_lastDirSelected = null;
    TreeViewer m_treeViewer = null;
    private GroupTreeObject m_parent = null;

    public ImportOVPolicy(TreeViewer treeViewer, GroupTreeObject parent) {
        super("Import Other");
        this.setText("Import Other");
        this.setId("Import_Other");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_IMPORT);
        this.m_parent = parent;
        this.m_treeViewer = treeViewer;
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        Shell parentShell = this.m_treeViewer.getControl().getShell();
        FileDialog fd = new FileDialog(parentShell, 2);
        fd.setText("Select a policy file");
        if (m_lastDirSelected != null) {
            fd.setFilterPath(m_lastDirSelected);
        }
        fd.setFilterExtensions(new String[]{"*.dat", "*.data", "*.*"});
        String fileFIRST = fd.open();
        String[] fnames = fd.getFileNames();
        String path = fd.getFilterPath();
        if (fnames == null || fnames.length == 0) {
            return;
        }
        m_lastDirSelected = fileFIRST;
        int deduplicationMode = 2;
        ImportMPIPropertiesDialog dialog = new ImportMPIPropertiesDialog(Display.getCurrent().getActiveShell());
        dialog.setBlockOnOpen(true);
        int res1 = dialog.open();
        if (res1 == 1) {
            return;
        }
        deduplicationMode = dialog.getdedupFlag();
        RTLogger.print(3, "Import Policies started (Import Other)");
        SALogger logger = new SALogger(Repository.getUserDirectory(), "BoomPolicyConverter_", 3, 10L);
        int i = 0;
        while (i < fnames.length) {
            String pName = String.valueOf(path) + File.separator + fnames[i];
            try {
                File pg = new File(pName);
                PolicyConvereter pc = new PolicyConvereter(logger, deduplicationMode);
                pc.readFile(pg);
                int indexOf = pg.getName().indexOf("_");
                String spiName = "";
                if (indexOf != -1) {
                    spiName = pg.getName().substring(0, indexOf);
                }
                String time = "" + System.currentTimeMillis();
                this.createAndDisplay(pc, spiName, time);
                if (pc.m_REST.size() > 0) {
                    ProgressDialog pd = new ProgressDialog("   Import Policies " + fnames[i], "", 0, pc.m_REST.size());
                    pd.setBlockOnOpen(false);
                    pd.open();
                    int processingNumber = 0;
                    try {
                        int j = 0;
                        while (j < pc.m_REST.size()) {
                            String name = "policy #" + j;
                            try {
                                PolicyConvereter pc2 = pc.m_REST.get(j);
                                name = pc2.m_monitor.get(0);
                                pd.setProgress("Processing " + name, ++processingNumber);
                                this.createAndDisplay(pc2, spiName, time);
                            }
                            catch (Throwable throwable) {
                                new ShowMessageBox("Import failed", "Can't import Policy " + name, 1);
                            }
                            ++j;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable2) {}
                        throw throwable;
                    }
                    try {
                        pd.close();
                    }
                    catch (Throwable throwable) {}
                }
                Object[] expanded = this.m_treeViewer.getExpandedElements();
                this.m_treeViewer.refresh();
                int index = 0;
                while (index < expanded.length) {
                    try {
                        if (!this.m_treeViewer.getExpandedState(expanded[index])) {
                            this.m_treeViewer.setExpandedState(expanded[index], true);
                        }
                    }
                    catch (Exception exception) {}
                    ++index;
                }
            }
            catch (Throwable e) {
                RTLogger.print(5, "Error import Policy.", e);
                logger.print(1, "Error processing file " + pName);
                new ShowMessageBox("Import failed", "Error processing file " + pName, 1);
            }
            ++i;
        }
        this.m_treeViewer.expandToLevel((Object)this.m_parent, 1);
        RTLogger.print(3, "Import Policies finished (Import Other)");
    }

    private void createAndDisplay(PolicyConvereter pc, String spiName, String suffix) {
        MsgPolicy mp = pc.createMsgPolicy(spiName);
        if (mp.getName() != null) {
            MsgConditions mcs = pc.createMsgConditions(mp);
            if (mcs.getConditionList().size() == 0) {
                MsgCondition mc = MsgCondition.getNew(0);
                mc.setStopEvaluation(true);
                mcs.addCondition(mc);
            }
            mp.setConditions(mcs);
            mp.setName(String.valueOf(mp.getName()) + "_" + suffix);
            GroupTreeObjectUnsubmitted gtol = new GroupTreeObjectUnsubmitted(new TreeObject(mp.getName(), BMUI.type_msg, mp), null, "IMAGE_MSG");
            this.m_parent.addElement(gtol);
            PolicyView.showNewPolicyTab(mp, this.m_treeViewer, gtol, false);
            PolicyManager.getInstance().addUnsubmitted(gtol, this.m_parent.getPath());
        } else {
            Policy p = pc.createPolicy(spiName);
            Conditions cnds = pc.createConditions(p);
            if (cnds.getConditionList().size() == 0) {
                Condition c = Condition.getNew(0);
                if (p.getType().equals("MAXTHRESHOLD")) {
                    c.setThreshold(1.0);
                    c.setReset(1.0);
                } else {
                    c.setThreshold(-1.0);
                    c.setReset(-1.0);
                }
                c.setHelptext("Imported trigger policy. This condition will never match.");
                c.setSetText("Trigger policy <$NAME>");
                cnds.addCondition(c);
            }
            p.setConditions(cnds);
            p.setName(String.valueOf(p.getName()) + "_" + suffix);
            GroupTreeObjectUnsubmitted gtol = new GroupTreeObjectUnsubmitted(new TreeObject(p.getName(), BMUI.type_mon, p), null, "IMAGE_MON");
            this.m_parent.addElement(gtol);
            PolicyView.showNewPolicyTab(p, this.m_treeViewer, gtol, false);
            PolicyManager.getInstance().addUnsubmitted(gtol, this.m_parent.getPath());
        }
    }
}

