/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GActionsRepository;
import com.blixx.boom.engine.GuiClient;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.ImportMPIDialog;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public class InstallMPI
extends Action {
    private static String m_lastDirSelected = null;
    public static final String NOTHING_TO_IMPORT = "Nothing to import";
    public static final String READY_TO_IMPORT = "Ready to Import.";
    public static final String CONFLICTS_FOUND = "CONFLICTS found!";
    public static final String NO_CONFLICTS_FOUND = "Ready to Import. No conflicts found.";
    public static final String WARNINGS_FOUND = "Ready to Import. WARNINGS found!";
    public String policiesDir;
    public String policiesGroupsFile;
    public String assignmentGroupsFile;
    public String nodeGroupsFile;
    public String actionsDir;
    public String packagesDir;
    public String nodegroupsDir;
    public String nodeGroupsFile_tmp;
    public String m_msg_policies = "Ready to Import. No conflicts found.";
    public String m_msg_actions = "Ready to Import. No conflicts found.";
    public String m_msg_packages = "Ready to Import. No conflicts found.";
    public String m_msg_assignments = "Ready to Import. No conflicts found.";
    public String m_msg_nodegroups = "Ready to Import. No conflicts found.";
    public HashMap<String, List<com.blixx.shared.Action>> m_actionGroups = new HashMap();
    public List<String> m_packages = new ArrayList<String>();
    public List<GroupTreeObjectLast> m_policies = new ArrayList<GroupTreeObjectLast>();
    public List<GroupTreeObject> m_assignments = new ArrayList<GroupTreeObject>();
    public List<GroupTreeObject> m_nodegroups = new ArrayList<GroupTreeObject>();
    public boolean m_policyConflictFound = false;
    public HashMap<String, String> m_packagesToRename = new HashMap();
    public HashMap<String, String> m_policiesToRename = new HashMap();
    public HashMap<String, String> m_policiesToRenameREVERSE = new HashMap();
    public HashMap<String, String> m_policiesPathesToRename = new HashMap();
    public HashMap<String, String> m_assignmentsToRename = new HashMap();
    public HashMap<String, String> m_nodeGroupsToMerge = new HashMap();
    public List<String> m_asnAlreadyExist = new LinkedList<String>();
    public List<String> m_missingImportFiles = new LinkedList<String>();
    public List<String> m_missingImportAndSrvFiles = new LinkedList<String>();
    public List<String> m_removedAsnLinks = new LinkedList<String>();
    public List<String> m_notRemovedAsnLinks_err = new LinkedList<String>();
    private File m_policiesDirFile = null;
    private HashMap<String, Object> m_newElementsMap = new HashMap();

    public InstallMPI() {
        this.setId("boom.import.MPI");
        this.setText("Import MPI");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_IMPORT);
        if (Repository.getInstance().getRights(1008) < 3 || Repository.getInstance().getRights(1001) < 3 || Repository.getInstance().getRights(1006) < 3 || Repository.getInstance().getRights(1007) < 3 || Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        Repository.getInstance().fetchAssignments(true);
        this.m_msg_policies = NO_CONFLICTS_FOUND;
        this.m_msg_actions = NO_CONFLICTS_FOUND;
        this.m_msg_packages = NO_CONFLICTS_FOUND;
        this.m_msg_assignments = NO_CONFLICTS_FOUND;
        this.m_msg_nodegroups = NO_CONFLICTS_FOUND;
        this.m_packagesToRename.clear();
        this.m_policiesToRename.clear();
        this.m_policiesToRenameREVERSE.clear();
        this.m_policiesPathesToRename.clear();
        this.m_assignmentsToRename.clear();
        this.m_asnAlreadyExist.clear();
        this.m_missingImportFiles.clear();
        this.m_missingImportAndSrvFiles.clear();
        this.m_removedAsnLinks.clear();
        this.m_notRemovedAsnLinks_err.clear();
        this.m_nodeGroupsToMerge.clear();
        this.m_newElementsMap.clear();
        this.m_actionGroups.clear();
        this.m_packages.clear();
        this.m_policies.clear();
        this.m_assignments.clear();
        this.m_nodegroups.clear();
        this.m_policyConflictFound = false;
        DirectoryDialog fd = new DirectoryDialog(Display.getCurrent().getActiveShell());
        if (m_lastDirSelected != null) {
            fd.setFilterPath(m_lastDirSelected);
        }
        fd.setText("   Select MPI's Directory");
        fd.setMessage("Select a directory");
        String dirName = fd.open();
        if (dirName == null) {
            return;
        }
        m_lastDirSelected = dirName;
        if (!dirName.endsWith(File.separator)) {
            dirName = String.valueOf(dirName) + File.separator;
        }
        this.policiesDir = String.valueOf(dirName) + "policies";
        this.policiesGroupsFile = String.valueOf(this.policiesDir) + File.separator + "policyGroups.xml";
        this.assignmentGroupsFile = String.valueOf(this.policiesDir) + File.separator + "assignmentGroups.xml";
        this.actionsDir = String.valueOf(dirName) + "actions";
        this.packagesDir = String.valueOf(dirName) + "packages";
        this.nodegroupsDir = String.valueOf(dirName) + "nodes";
        this.nodeGroupsFile = String.valueOf(this.nodegroupsDir) + File.separator + "nodeGroups.xml";
        this.nodeGroupsFile_tmp = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "nodeGroups4Import_tmp.xml";
        this.check();
        this.openImportMPIDialog();
        RTLogger.print(5, "Import MPI finished!");
    }

    private void openImportMPIDialog() {
        ImportMPIDialog id = new ImportMPIDialog(Display.getCurrent().getActiveShell(), this);
        id.setBlockOnOpen(true);
        int result = id.open();
        if (result == 1) {
            new ShowMessageBox("Cancel MPI Import", "MPI Import has been canceled.", 2);
            return;
        }
        RTLogger.print(5, "Import MPI started ...");
        GroupTreeObject import_folder = null;
        boolean isCanceled = false;
        if (this.m_policyConflictFound && !id.m_overwrite_policies) {
            try {
                import_folder = this.renamePolicies();
            }
            catch (RuntimeException runtimeException) {
                isCanceled = true;
            }
        } else {
            HashMap<String, GroupTreeObjectLast> map = new HashMap<String, GroupTreeObjectLast>();
            for (GroupTreeObjectLast gto : this.m_policies) {
                map.put(gto.getName(), gto);
            }
            this.processGTOs(map);
        }
        if (isCanceled) {
            this.openImportMPIDialog();
        } else {
            GuiClient.m_ignorePending = true;
            try {
                if (this.policiesDir != null) {
                    this.importPolicies(import_folder, id.m_updateTreeStructure_pol);
                }
                if (this.packagesDir != null) {
                    this.importPackages(id.m_overwrite_packages);
                }
                if (this.actionsDir != null) {
                    this.importActions(id.m_overwrite_actions, id.m_merge_actions);
                }
                if (this.nodegroupsDir != null) {
                    this.importNodeGroups();
                }
            }
            catch (RuntimeException e) {
                RTLogger.print(2, "IMPORT failed.", e);
                new ShowMessageBox("Import canceled", "Error " + e.getMessage(), 1);
            }
            BinariesListView.getInstance().refreshTree(true);
            Repository.getInstance().fetchPolicies(true);
            this.importAssignments(id.m_overwrite_assignments);
            Repository.getInstance().fetchAssignments(true);
            Repository.getInstance().getAllAssignments().startServerClient(0L, Repository.getInstance());
            GuiClient.m_ignorePending = false;
        }
    }

    private void importAssignments(boolean overwrite) {
        ProgressDialog pd = new ProgressDialog("Import Assignments", "", 0, this.m_assignments.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int processingNumber = 0;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        try {
            UpdateServer usrv = new UpdateServer();
            for (GroupTreeObject asn : this.m_assignments) {
                boolean isSuccess;
                pd.setProgress("Processing Assignment: " + asn.getName(), ++processingNumber);
                if (this.m_assignmentsToRename.containsKey(asn.getName())) {
                    overwrite = false;
                    if (overwrite) {
                        this.renameAssignmentElements(asn);
                        isSuccess = usrv.syncAsnWithServer(scBatch, asn.getParentPath(), asn.getName(), CMDS.ACTION_DEL, asn.getType());
                        if (!isSuccess) {
                            RTLogger.print(1, "IMPORT MPI error deleting Asn Group " + asn.getName());
                        }
                    } else {
                        asn.setName(this.m_assignmentsToRename.get(asn.getName()));
                        this.renameAssignmentElements(asn);
                    }
                } else {
                    this.renameAssignmentElements(asn);
                }
                if (isSuccess = usrv.syncAsnWithServer(scBatch, asn.getParentPath(), asn.getName(), CMDS.ACTION_ADD, asn.getType())) {
                    List<GroupTreeObject> allElements = asn.getAllElements();
                    for (GroupTreeObject g : allElements) {
                        pd.setProgress("Processing Assignment: " + g.getPath().replace("/root/Assignments/", ""), processingNumber);
                        if (g instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gl = (GroupTreeObjectLast)g;
                            String type = gl.getTreeObject().getType();
                            if (type.equals(BMUI.type_assignment_bin)) {
                                if (this.m_packagesToRename.containsKey(gl.getName())) {
                                    String newPackageName = this.m_packagesToRename.get(gl.getName());
                                    String lpath = gl.getLinkedPath();
                                    gl.setName(newPackageName);
                                    gl.setLinkedPath(String.valueOf(lpath.substring(0, lpath.lastIndexOf(47) + 1)) + newPackageName);
                                }
                            } else {
                                GroupTreeObject polRoot = PolicyManager.getInstance().getPolicyTree();
                                GroupTreeObjectLast existingPol = polRoot.findElement(gl.getName(), gl.getType());
                                if (existingPol != null && !existingPol.getPath().equals(gl.getLinkedPath())) {
                                    gl.setLinkedPath(existingPol.getPath());
                                }
                            }
                            if (isSuccess = usrv.syncAsnWithServer(scBatch, gl.getLinkedPath(), g.getParentPath(), CMDS.ACTION_ADDLINK_noDeploy, gl.getType())) continue;
                            new ShowMessageBox("Import Error", "Assignment element " + g.getName() + " creation failed.\nWill be skipped.", 1);
                            continue;
                        }
                        isSuccess = usrv.syncAsnWithServer(scBatch, g.getParentPath(), g.getPath(), CMDS.ACTION_ADD, g.getType());
                        if (isSuccess) continue;
                        new ShowMessageBox("Import Error", "Assignment folder " + g.getName() + " creation failed.\nWill be skipped.", 1);
                    }
                    continue;
                }
                new ShowMessageBox("Import Error", "Assignment " + asn.getName() + " creation failed.\nWill be skipped.", 1);
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    private void renameAssignmentElements(GroupTreeObject asn) {
        for (String oldName : this.m_policiesToRename.keySet()) {
            String newPath;
            String lp;
            String newName = this.m_policiesToRename.get(oldName);
            GroupTreeObjectLast gtol = asn.findElement(oldName, BMUI.type_mon);
            String oldLinkedPath = null;
            if (gtol != null) {
                oldLinkedPath = gtol.getLinkedPath();
                gtol.setName(newName);
                lp = gtol.getLinkedPath();
                gtol.setLinkedPath(String.valueOf(lp.substring(0, lp.length() - oldName.length())) + newName);
            } else {
                gtol = asn.findElement(oldName, BMUI.type_msg);
                if (gtol != null) {
                    oldLinkedPath = gtol.getLinkedPath();
                    gtol.setName(newName);
                    lp = gtol.getLinkedPath();
                    gtol.setLinkedPath(String.valueOf(lp.substring(0, lp.length() - oldName.length())) + newName);
                }
            }
            if (gtol == null || oldLinkedPath == null || (newPath = this.m_policiesPathesToRename.get(oldLinkedPath)) == null) continue;
            gtol.setLinkedPath(newPath);
        }
        for (String oldPathName : this.m_policiesPathesToRename.keySet()) {
            String newPath = this.m_policiesPathesToRename.get(oldPathName);
            List<GroupTreeObjectLast> list = asn.findLinksByName(oldPathName);
            if (list.size() <= 0) continue;
            int i = 0;
            while (i < list.size()) {
                GroupTreeObjectLast gtol = list.get(i);
                gtol.setLinkedPath(newPath);
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void importPolicies(GroupTreeObject import_folder, boolean updateTreeStructure) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GroupTreeObject renamePolicies() {
        GroupTreeObject import_folder = null;
        HashMap<String, GroupTreeObjectLast> tempMap = new HashMap<String, GroupTreeObjectLast>();
        int i = 0;
        while (i < this.m_policies.size()) {
            GroupTreeObjectLast gtol = this.m_policies.get(i);
            tempMap.put(gtol.getName(), gtol);
            ++i;
        }
        PolicyRenamingDialog m_pvd = new PolicyRenamingDialog(Display.getCurrent().getActiveShell(), tempMap, PolicyRenamingDialog.IMPORT_POLICY);
        Window.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        m_pvd.setTitles();
        m_pvd.setBlockOnOpen(true);
        m_pvd.open();
        if (m_pvd.getReturnCode() == 0) {
            if (m_pvd.m_target != null) {
                import_folder = m_pvd.m_target;
            }
        } else {
            throw new RuntimeException("Canceled PRD");
        }
        HashMap<String, GroupTreeObjectLast> elementsHM = m_pvd.getElements();
        this.processGTOs(elementsHM);
        return import_folder;
    }

    private void processGTOs(HashMap<String, GroupTreeObjectLast> elementsHM) {
        this.m_policies.clear();
        if (this.m_newElementsMap == null) {
            this.m_newElementsMap = new HashMap();
        }
        this.m_newElementsMap.clear();
        for (String newName : elementsHM.keySet()) {
            File of;
            GroupTreeObjectLast gtol = elementsHM.get(newName);
            String oldName = gtol.getName();
            String oldFileName = String.valueOf(oldName) + BMUI.file_extension_mon;
            if (gtol.getTreeObject().getType().equals(BMUI.type_msg)) {
                oldFileName = String.valueOf(oldName) + BMUI.file_extension_msg;
                of = new File(this.m_policiesDirFile.getParent(), oldFileName);
                MsgPolicy mp = PolicyManager.getInstance().getMessagePolicy(of);
                mp.setName(newName);
                this.m_newElementsMap.put(newName, mp);
            } else {
                oldFileName = String.valueOf(oldName) + BMUI.file_extension_mon;
                of = new File(this.m_policiesDirFile.getParent(), oldFileName);
                Policy p = PolicyManager.getInstance().getMonitorPolicy(of);
                p.setName(newName);
                this.m_newElementsMap.put(newName, p);
            }
            gtol.setName(newName);
            if (!oldName.equals(newName)) {
                this.m_policiesToRename.put(oldName, newName);
                this.m_policiesToRenameREVERSE.put(newName, oldName);
            }
            this.m_policies.add(gtol);
        }
    }

    private void importActions(boolean overwrite, boolean merge) {
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        UpdateServer usrv = new UpdateServer();
        ProgressDialog pd = new ProgressDialog("Import actions", "", 0, this.m_actionGroups.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int count = 0;
        try {
            Iterator<String> it = this.m_actionGroups.keySet().iterator();
            while (it.hasNext()) {
                String actionGroup;
                String finGroupName = actionGroup = it.next();
                boolean doImportActGRP = true;
                GActionsRepository GA = Repository.getInstance().m_actionRepository;
                if (GA.isActionGroupExist(actionGroup)) {
                    if (merge) {
                        List<com.blixx.shared.Action> newActList = this.m_actionGroups.get(actionGroup);
                        for (com.blixx.shared.Action newAct : newActList) {
                            String newActName = newAct.m_label;
                            if (!this.doesActionExist(GA, actionGroup, newActName)) {
                                pd.setProgress("Import Action " + newAct, ++count);
                                ServerClient sc = Repository.getInstance().m_actionRepository.saveAction(newAct, actionGroup);
                                if (sc.isSuccess()) {
                                    RTLogger.print(3, "UPDATEACTION OK: " + sc.getResultObject());
                                } else {
                                    RTLogger.print(3, "UPDATEACTION Error: " + sc.getResultObject());
                                }
                            }
                            doImportActGRP = false;
                        }
                    } else if (overwrite) {
                        doImportActGRP = true;
                    } else {
                        finGroupName = this.checkActionGroupName(actionGroup);
                        pd.setProgress("Import Action Group" + finGroupName, ++count);
                        String[] arr = new String[]{finGroupName};
                        boolean isSuccess = usrv.syncWithActionServer(scBatch, CMDS.ACTION_ADD, arr);
                        if (!isSuccess) {
                            RTLogger.print(1, "IMPORT MPI error adding action group " + actionGroup);
                        }
                        doImportActGRP = true;
                    }
                }
                if (!doImportActGRP) continue;
                List<com.blixx.shared.Action> actions = this.m_actionGroups.get(actionGroup);
                for (com.blixx.shared.Action a : actions) {
                    pd.setProgress("Processing action: \"" + finGroupName + "/" + a.m_label + "\"", count);
                    scBatch.setCommand("UPDATEACTION", finGroupName, new IODataStream[]{a});
                    Object res = scBatch.runBatch();
                    if (scBatch.isSuccess()) {
                        RTLogger.print(3, "Action Import OK: " + a.m_label + " Group:" + finGroupName);
                        continue;
                    }
                    RTLogger.print(3, "UPDATEACTION Error: " + res);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    private boolean doesActionExist(GActionsRepository GA, String actionGroup, String newActionName) {
        boolean doesExist = false;
        GroupTreeObject actGTO = GA.getTree().getFirstChild(actionGroup);
        GroupTreeObject foundGTO = actGTO.getChild(newActionName, BMUI.type_act);
        if (foundGTO != null) {
            doesExist = true;
        }
        return doesExist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importPackages(boolean overwrite) {
        Iterator<String> it = this.m_packages.iterator();
        ProgressDialog pd = new ProgressDialog("Uploading files", "", 0, this.m_packages.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int progress = 0;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        try {
            while (it.hasNext()) {
                String path;
                String newPackageName = null;
                String packageName = it.next();
                pd.setProgress("Processing package: " + packageName, ++progress);
                if (this.m_packagesToRename.containsKey(packageName)) {
                    if (overwrite) {
                        this.deleteFiles(scBatch, packageName);
                        this.m_packagesToRename.remove(packageName);
                    } else {
                        newPackageName = this.m_packagesToRename.get(packageName);
                        path = "srv/packages/" + newPackageName;
                        this.createPackage(scBatch, newPackageName, path);
                    }
                } else {
                    path = "srv/packages/" + packageName;
                    this.createPackage(scBatch, packageName, path);
                }
                try {
                    this.uploadFiles(scBatch, packageName, newPackageName, pd);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
                throw throwable;
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
            return;
        }
        catch (Throwable throwable) {}
    }

    private void importNodeGroups() {
        GroupTreeObject nodeGroupGTO = Repository.getInstance().getNodeGroupTree();
        if (nodeGroupGTO != null) {
            try {
                GroupTreeObject nodeGroupGTO_clone = nodeGroupGTO.clone();
                for (GroupTreeObject newNode : this.m_nodegroups) {
                    if (newNode.getName().equals("_Groups")) continue;
                    if (this.m_nodeGroupsToMerge.containsKey(newNode.getName())) {
                        List<GroupTreeObject> allNewSubGTOs = newNode.getAllElements();
                        for (GroupTreeObject g : allNewSubGTOs) {
                            String path;
                            GroupTreeObject existingGTO = nodeGroupGTO_clone.searchPath(g.getPath(), g.getType());
                            if (existingGTO != null || !g.getPath().startsWith("/root") || (existingGTO = nodeGroupGTO_clone.searchPath(path = g.getPath().replace("/root", ""), g.getType())) != null) continue;
                            GroupTreeObject.createPath(path, nodeGroupGTO_clone);
                        }
                        continue;
                    }
                    nodeGroupGTO_clone.addElement(newNode);
                }
                GroupTreeObject root = null;
                if (!nodeGroupGTO_clone.getPath().startsWith("/root")) {
                    root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                    root.addElement(nodeGroupGTO_clone);
                } else {
                    root = nodeGroupGTO_clone;
                }
                XMLTree xt = new XMLTree();
                Document doc = xt.getXML(root);
                XMLFactory.writeXml(doc, this.nodeGroupsFile_tmp);
                ServerClient sc = ServerClient.putFile("srv/groups/nodeGroups.xml", this.nodeGroupsFile_tmp);
                sc.run();
                File tmpFile = new File(this.nodeGroupsFile_tmp);
                if (tmpFile != null && tmpFile.exists()) {
                    try {
                        tmpFile.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private void uploadFiles(ServerClientBatch scBatch, String packageName, String newPackageName, ProgressDialog pd) {
        File pkDir = new File(String.valueOf(this.packagesDir) + File.separator + packageName);
        String path = "srv/packages/" + packageName + "/";
        if (newPackageName != null) {
            path = "srv/packages/" + newPackageName + "/";
        }
        this.uploadSingle(scBatch, pkDir, path, pd);
    }

    private void uploadSingle(ServerClientBatch scBatch, File pkDir, String pathEndedWithSlash, ProgressDialog pd) {
        if (pkDir.isDirectory()) {
            File[] list = pkDir.listFiles();
            pd.setMaximum(list.length);
            int i = 0;
            while (i < list.length) {
                String pathCurr = String.valueOf(pathEndedWithSlash) + list[i].getName();
                if (list[i].isDirectory()) {
                    pd.setProgress("Processing package folder: " + pathCurr, pd.getCurrent());
                    scBatch.setCommand("CREATE_FOLDER", pathCurr, new String[0]);
                    scBatch.runBatch();
                    if (!scBatch.isSuccess()) {
                        RTLogger.print(5, "IMPORT Error creating Folder: " + pathCurr);
                        throw new RuntimeException("IMPORT Error creating Folder: " + pathCurr);
                    }
                    RTLogger.print(5, "IMPORT Folder created. " + pathCurr);
                    File[] subFiles = list[i].listFiles();
                    int j = 0;
                    while (j < subFiles.length) {
                        this.uploadSingle(scBatch, subFiles[j], String.valueOf(pathCurr) + "/", pd);
                        ++j;
                    }
                } else {
                    try {
                        pd.setProgress("Processing package file: " + pathCurr, pd.getCurrent());
                        scBatch.setCommand("PUT_FILE", pathCurr, new String[]{list[i].getCanonicalPath()});
                        scBatch.runBatch();
                        if (scBatch.isSuccess()) {
                            RTLogger.print(5, "IMPORT File created. " + pathCurr);
                        } else {
                            RTLogger.print(5, "IMPORT Error creating File: " + pathCurr);
                        }
                    }
                    catch (IOException iOException) {}
                }
                ++i;
            }
        } else {
            try {
                String pathCurr = String.valueOf(pathEndedWithSlash) + pkDir.getName();
                pd.setProgress("Processing package file: " + pathCurr, pd.getCurrent());
                scBatch.setCommand("PUT_FILE", pathCurr, new String[]{pkDir.getCanonicalPath()});
                scBatch.runBatch();
                if (scBatch.isSuccess()) {
                    RTLogger.print(5, "IMPORT File created. " + pathCurr);
                } else {
                    RTLogger.print(5, "IMPORT Error creating File: " + pathCurr);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void deleteFiles(ServerClientBatch scBatch, String packageName) {
        GroupTreeObject m_binTree = Repository.getInstance().getBinaryTree();
        GroupTreeObject pkgGTO = m_binTree.findFirstGroup(packageName, BMUI.type_assignment_bin);
        ArrayList<String> toDelete = new ArrayList<String>();
        this.collectPathes(pkgGTO, toDelete);
        for (String path : toDelete) {
            path = path.replace("/root/Packages", "srv/packages");
            scBatch.setCommand("DELETE_FILE", path, new String[0]);
            scBatch.runBatch();
            if (scBatch.isSuccess()) {
                RTLogger.print(5, "IMPORT File deleted. " + path);
                continue;
            }
            RTLogger.print(5, "IMPORT Error deleting file: " + path);
        }
    }

    private void collectPathes(GroupTreeObject pkgGTO, ArrayList<String> toDelete) {
        List<GroupTreeObject> al = pkgGTO.getElements();
        for (GroupTreeObject gto : al) {
            toDelete.add(0, gto.getPath());
            if (!gto.hasElements().booleanValue()) continue;
            this.collectPathes(gto, toDelete);
        }
    }

    private void createPackage(ServerClientBatch scBatch, String packageName, String path) {
        scBatch.setCommand("CREATE_FOLDER", path, new String[0]);
        scBatch.runBatch();
        if (!scBatch.isSuccess()) {
            RTLogger.print(5, "IMPORT Error creating Folder: " + path);
            throw new RuntimeException("IMPORT Error creating package: " + packageName);
        }
        RTLogger.print(5, "IMPORT Folder created. " + path);
    }

    public void check() {
        this.checkPoliciesAll();
        this.checkActions();
        this.checkPackages();
        this.checkAssignments();
        this.checkNodeGroups();
    }

    private void checkPoliciesAll() {
        File pgDir = new File(this.policiesDir);
        if (pgDir.exists() && pgDir.isDirectory()) {
            File[] list = pgDir.listFiles();
            if (list == null || list.length == 0) {
                this.policiesDir = null;
            } else {
                File pg = new File(this.policiesGroupsFile);
                if (!pg.exists()) {
                    this.policiesGroupsFile = null;
                    this.m_msg_policies = NOTHING_TO_IMPORT;
                } else {
                    this.m_policyConflictFound = this.checkPolicies();
                    if (this.m_policyConflictFound) {
                        this.m_msg_policies = "CONFLICTS found!\nPolicy renaming dialog will be started if Overwrite checkbox remains unchecked.";
                    }
                }
            }
        } else {
            this.policiesDir = null;
            this.policiesGroupsFile = null;
            this.m_msg_policies = NOTHING_TO_IMPORT;
            this.assignmentGroupsFile = null;
            this.m_msg_assignments = NOTHING_TO_IMPORT;
        }
        if (this.policiesDir == null) {
            this.m_msg_policies = NOTHING_TO_IMPORT;
        }
    }

    private void checkAssignments() {
        if (this.policiesDir == null) {
            this.assignmentGroupsFile = null;
            this.m_msg_assignments = NOTHING_TO_IMPORT;
            return;
        }
        File pgDir = new File(this.policiesDir);
        if (pgDir.exists() && pgDir.isDirectory()) {
            File[] list = pgDir.listFiles();
            if (list == null || list.length == 0) {
                this.policiesDir = null;
            } else {
                File ag = new File(this.assignmentGroupsFile);
                if (!ag.exists()) {
                    this.assignmentGroupsFile = null;
                    this.m_msg_assignments = NOTHING_TO_IMPORT;
                } else {
                    try {
                        XMLTree xt = new XMLTree();
                        FileInputStream fis = new FileInputStream(ag);
                        GroupTreeObject incomingAsnTree = xt.parseXML(fis, true);
                        fis.close();
                        GroupTreeObject inR = incomingAsnTree.getFirstChild("Assignments");
                        List<GroupTreeObject> asnListNew = inR.getElements();
                        int i = 0;
                        while (i < asnListNew.size()) {
                            String inAsnGrpName = asnListNew.get(i).getName();
                            String finAsnName = this.checkAssignmentGroup(asnListNew.get(i), inAsnGrpName);
                            if (finAsnName == null) {
                                this.m_asnAlreadyExist.add(inAsnGrpName);
                            } else {
                                this.m_assignments.add(asnListNew.get(i));
                                if (finAsnName != null && !finAsnName.equals(inAsnGrpName)) {
                                    if (!this.m_msg_assignments.startsWith(CONFLICTS_FOUND)) {
                                        this.m_msg_assignments = "CONFLICTS found!\nConflicting names will be resolved automatically";
                                    }
                                    this.m_assignmentsToRename.put(inAsnGrpName, finAsnName);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        this.assignmentGroupsFile = null;
                        this.m_msg_assignments = "Error parsing assignmentGroups.xml";
                    }
                }
            }
            if (this.policiesDir != null && this.assignmentGroupsFile != null && this.m_missingImportAndSrvFiles.size() > 0) {
                int i = 0;
                while (i < this.m_missingImportAndSrvFiles.size()) {
                    String name = this.m_missingImportAndSrvFiles.get(i);
                    boolean removed = this.removeAsnLinksIfExist(name);
                    if (removed) {
                        this.m_removedAsnLinks.add(name);
                    } else {
                        this.m_notRemovedAsnLinks_err.add(name);
                    }
                    ++i;
                }
            }
        } else {
            this.policiesDir = null;
            this.policiesGroupsFile = null;
            this.m_msg_policies = NOTHING_TO_IMPORT;
            this.assignmentGroupsFile = null;
            this.m_msg_assignments = NOTHING_TO_IMPORT;
        }
        if (this.policiesDir == null) {
            this.m_msg_policies = NOTHING_TO_IMPORT;
        }
    }

    public boolean removeAsnLinksIfExist(String linkedPathToRemove) {
        File ag;
        File[] list;
        boolean removed = false;
        File pgDir = new File(this.policiesDir);
        if (pgDir.exists() && pgDir.isDirectory() && (list = pgDir.listFiles()) != null && list.length > 0 && (ag = new File(this.assignmentGroupsFile)).exists()) {
            try {
                XMLTree xt = new XMLTree();
                FileInputStream fis = new FileInputStream(ag);
                GroupTreeObject incomingAsnTree = xt.parseXML(fis, true);
                fis.close();
                GroupTreeObject inR = incomingAsnTree.getFirstChild("Assignments");
                List<GroupTreeObject> asnListNew = inR.getElements();
                int i = 0;
                while (i < asnListNew.size()) {
                    List<GroupTreeObject> allChild = asnListNew.get(i).getAllElements();
                    for (GroupTreeObject gto : allChild) {
                        if (gto.getTreeObject().getType().equals(BMUI.type_mon) || gto.getTreeObject().getType().equals(BMUI.type_msg)) {
                            String link;
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                            String linkedPath = gtol.getLinkedPath();
                            String[] split = linkedPath.split("\\/");
                            if (split.length <= 0 || !linkedPathToRemove.equals(link = split[split.length - 1])) continue;
                            gtol.getParent().removeElement(gtol);
                            removed = true;
                            continue;
                        }
                        gto.getTreeObject().getType().equals(BMUI.type_assignment_bin);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                this.assignmentGroupsFile = null;
                this.m_msg_assignments = "Error parsing assignmentGroups.xml";
            }
        }
        return removed;
    }

    public boolean containsByNameAndType(List<GroupTreeObject> list, GroupTreeObjectLast gtol) {
        String nameType = gtol.getNameType();
        int i = 0;
        while (i < list.size()) {
            GroupTreeObjectLast g;
            GroupTreeObject gto = list.get(i);
            if (gto != null && gto instanceof GroupTreeObjectLast && (g = (GroupTreeObjectLast)gto).getNameType().equals(nameType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkPackages() {
        File pkgDir = new File(this.packagesDir);
        if (pkgDir.exists() && pkgDir.isDirectory()) {
            File[] list = pkgDir.listFiles();
            if (list == null || list.length == 0) {
                this.packagesDir = null;
            } else {
                int i = 0;
                while (i < list.length) {
                    if (list[i].isDirectory()) {
                        String pkgName = list[i].getName();
                        this.m_packages.add(pkgName);
                        String newName = this.checkPackageName(pkgName);
                        if (!newName.equals(pkgName)) {
                            this.m_msg_packages = "CONFLICTS found!\nConflicting Binary packages will be imported with new names if Overwrite checkbox remains unchecked.";
                            this.m_packagesToRename.put(pkgName, newName);
                        }
                    }
                    ++i;
                }
            }
        } else {
            this.packagesDir = null;
        }
        if (this.packagesDir == null) {
            this.m_msg_packages = NOTHING_TO_IMPORT;
        }
    }

    private void checkActions() {
        File actDir = new File(this.actionsDir);
        if (actDir.exists() && actDir.isDirectory()) {
            File[] list = actDir.listFiles();
            if (list == null || list.length == 0) {
                this.actionsDir = null;
            } else {
                GActionsRepository GA = Repository.getInstance().m_actionRepository;
                int i = 0;
                while (i < list.length) {
                    String groupName = list[i].getName().replace(BMUI.file_extension_act, "");
                    List<com.blixx.shared.Action> actions = null;
                    try {
                        actions = GA.loadActions(list[i]);
                        if (actions != null && actions.size() != 0) {
                            this.m_actionGroups.put(groupName, actions);
                            if (!this.checkActionGroupName(groupName).equals(groupName)) {
                                this.m_msg_actions = "CONFLICTS found!\nConflicting Actions Groups will be imported with new names if both checkboxes (Overwrite/Merge) remain unchecked.";
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    ++i;
                }
                if (this.m_actionGroups.size() == 0) {
                    this.actionsDir = null;
                }
            }
        } else {
            this.actionsDir = null;
        }
        if (this.actionsDir == null) {
            this.m_msg_actions = NOTHING_TO_IMPORT;
        }
    }

    private void checkNodeGroups() {
        if (this.nodegroupsDir == null) {
            return;
        }
        File nodDir = new File(this.nodegroupsDir);
        if (nodDir.exists() && nodDir.isDirectory()) {
            File[] list = nodDir.listFiles();
            if (list == null || list.length == 0) {
                this.nodegroupsDir = null;
            } else {
                File ng = new File(this.nodeGroupsFile);
                if (!ng.exists()) {
                    this.nodeGroupsFile = null;
                    this.m_msg_nodegroups = NOTHING_TO_IMPORT;
                } else {
                    try {
                        XMLTree xt = new XMLTree();
                        FileInputStream fis = new FileInputStream(ng);
                        GroupTreeObject incomingNodeTree = xt.parseXML(fis, true);
                        fis.close();
                        GroupTreeObject inR = incomingNodeTree.getChild("_Groups", BMUI.type_folder);
                        List<GroupTreeObject> nodeList = inR.getElements();
                        int i = 0;
                        while (i < nodeList.size()) {
                            String inNodeName = nodeList.get(i).getName();
                            this.m_nodegroups.add(nodeList.get(i));
                            String finNodeName = this.checkNodeGroup(inNodeName);
                            if (!finNodeName.equals(inNodeName)) {
                                if (!this.m_msg_nodegroups.startsWith(CONFLICTS_FOUND)) {
                                    this.m_msg_nodegroups = "CONFLICTS found!\nConflicting Node Groups will be merged automatically.";
                                }
                                this.m_nodeGroupsToMerge.put(inNodeName, finNodeName);
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        this.nodeGroupsFile = null;
                        this.m_msg_nodegroups = "Error parsing nodeGroups.xml";
                    }
                }
            }
        } else {
            this.nodegroupsDir = null;
            this.nodeGroupsFile = null;
            this.m_msg_nodegroups = NOTHING_TO_IMPORT;
        }
        if (this.nodegroupsDir == null) {
            this.m_msg_nodegroups = NOTHING_TO_IMPORT;
        }
    }

    private boolean checkPolicies() {
        boolean conflict = false;
        this.m_policiesDirFile = new File(this.policiesGroupsFile);
        XMLTree m_xt = new XMLTree();
        FileInputStream io = null;
        try {
            io = new FileInputStream(this.m_policiesDirFile);
            GroupTreeObject newROOT = m_xt.parseXML(io, true);
            GroupTreeObject existingPolicyTree = PolicyManager.getInstance().getPolicyTree();
            this.m_policies = GroupTreeObject.collectElements(newROOT);
            Iterator<GroupTreeObjectLast> elIT = this.m_policies.iterator();
            while (elIT.hasNext()) {
                GroupTreeObjectLast ggg;
                GroupTreeObjectLast gl = elIT.next();
                String filename = String.valueOf(gl.getName()) + "." + gl.getTreeObject().getType() + ".xml";
                File f = new File(this.m_policiesDirFile.getParent(), filename);
                if (!f.exists() || !f.canRead()) {
                    elIT.remove();
                    ggg = existingPolicyTree.findElement(gl.getName(), gl.getTreeObject().getType());
                    if (ggg != null) {
                        this.m_missingImportFiles.add(gl.getName());
                        continue;
                    }
                    this.m_missingImportAndSrvFiles.add(gl.getName());
                    continue;
                }
                if (conflict || (ggg = existingPolicyTree.findElement(gl.getName(), gl.getTreeObject().getType())) == null) continue;
                conflict = true;
            }
            if (this.m_policies.size() == 0) {
                throw new RuntimeException("policyGroups.xml file is empty or XML files missed.");
            }
        }
        catch (Throwable throwable) {}
        return conflict;
    }

    private String checkActionGroupName(String groupName) {
        int n = 1;
        String finGroupName = groupName;
        GActionsRepository GA = Repository.getInstance().m_actionRepository;
        while (GA.isActionGroupExist(finGroupName)) {
            finGroupName = String.valueOf(groupName) + "(" + n + ")";
            ++n;
        }
        return finGroupName;
    }

    private String checkPackageName(String packageName) {
        int n = 1;
        String finPkgName = packageName;
        GroupTreeObject binTree = Repository.getInstance().getBinaryTree();
        while (binTree.findFirstGroup(finPkgName, BMUI.type_assignment_bin) != null) {
            finPkgName = String.valueOf(packageName) + "(" + n + ")";
            ++n;
        }
        return finPkgName;
    }

    private String checkAssignmentGroup(GroupTreeObject asnNew, String asnName) {
        boolean rename = false;
        int n = 1;
        String finAsnName = asnName;
        GroupTreeObject asnRoot = PolicyManager.getInstance().getAsnTree();
        GroupTreeObject asnOld = asnRoot.getFirstChild("Assignments").getChild(asnName, BMUI.type_assignment_pol);
        if (asnOld != null) {
            List<GroupTreeObject> newList = asnNew.getAllElements();
            List<GroupTreeObject> oldList = asnOld.getAllElements();
            if (newList.size() != oldList.size()) {
                rename = true;
            } else {
                Iterator<GroupTreeObject> newIT = newList.iterator();
                if (newIT.hasNext()) {
                    GroupTreeObject gtoNew = newIT.next();
                    if (this.doesGtoExist(gtoNew, oldList)) {
                        return null;
                    }
                    rename = true;
                }
            }
        }
        if (rename) {
            while (asnRoot.findFirstGroup(finAsnName, BMUI.type_assignment_pol) != null) {
                finAsnName = String.valueOf(asnName) + "(" + n + ")";
                ++n;
            }
        }
        return finAsnName;
    }

    public boolean doesGtoExist(GroupTreeObject gtoNew, List<GroupTreeObject> list) {
        for (GroupTreeObject gto : list) {
            if (!gtoNew.getName().equals(gto.getName()) || !gtoNew.getType().equals(gto.getType()) || !gtoNew.getPath().equals(gto.getPath())) continue;
            return true;
        }
        return false;
    }

    private String checkNodeGroup(String nodeName) {
        int n = 1;
        String finNodeName = nodeName;
        GroupTreeObject ngTree = Repository.getInstance().getNodeGroupTree();
        if (ngTree != null) {
            while (ngTree.getChild(finNodeName, "") != null) {
                finNodeName = String.valueOf(nodeName) + "(" + n + ")";
                ++n;
            }
        }
        return finNodeName;
    }
}

