/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.AttributeFilterListDialog;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.List;
import org.eclipse.jface.action.Action;

public class LinkAttributeFilterAction
extends Action {
    private Object m_object = null;

    public LinkAttributeFilterAction(Object obj, String type) {
        super("AddAttributeFilter");
        this.setId("addattributefilter");
        this.setText("Add Filter");
        this.m_object = obj;
        if (this.m_object == null || type == null) {
            this.setEnabled(false);
            return;
        }
        if (type.equals("NOTIFICATION")) {
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
                return;
            }
        } else if (type.equals("USERS") && Repository.getInstance().getRights(1004) < 3) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        AttributeFilterListDialog fd = new AttributeFilterListDialog();
        fd.setBlockOnOpen(true);
        int res = fd.open();
        if (res == 0) {
            List<ForwardFilter> list = fd.getSelection();
            if (this.m_object instanceof ServerFilterView) {
                ForwardPolicy currentPol = ServerFilterView.getInstance().getCurrentPolicy();
                currentPol.addFilter(list);
                ServerFilterView.getInstance().updateAttrFilterList(currentPol);
                ServerFilterView.getInstance().setDirty(true);
            } else if (this.m_object instanceof ServerFilterUsersTab) {
                ForwardPolicy currentPol = ServerFilterUsersTab.getInstance().getCurrentPolicy();
                currentPol.addFilter(list);
                ServerFilterUsersTab.getInstance().updateAttrFilterList(currentPol);
                ServerFilterUsersTab.getInstance().setDirty(true);
            }
        }
    }
}

