/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.views.actions.UnloadActiveIndications;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetActiveIndications;
import com.blixx.shared.ISEventFwdFilter;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;

public class LoadActiveIndicationsFiltered
extends Action
implements ICmdPostProcess {
    List<EventFilter> m_filters = null;
    ArrayList<EventFilter> evFilters = new ArrayList(0);

    public LoadActiveIndicationsFiltered(List<EventFilter> filters) {
        this.m_filters = filters;
        this.setId(this.getClass().getName());
        this.setText("Load indications (Use active filters)");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
    }

    public void run() {
        try {
            ScGetActiveIndications scgci = new ScGetActiveIndications(Repository.getInstance(), this);
            ArrayList<ISEventFwdFilter> encFilters = new ArrayList<ISEventFwdFilter>(0);
            if (this.m_filters != null) {
                encFilters.ensureCapacity(this.m_filters.size());
                this.evFilters.ensureCapacity(this.m_filters.size());
                for (final EventFilter ef : this.m_filters) {
                    if (!ef.m_isActive) continue;
                    this.evFilters.add(ef);
                    encFilters.add(new ISEventFwdFilter(){

                        @Override
                        public boolean matches(SEventFwd sef) {
                            return ef.select(null, null, sef);
                        }
                    });
                }
                scgci.addFilters(encFilters);
            }
            if (encFilters.size() == 0) {
                ShowSimpleDialog ssd = new ShowSimpleDialog(null, "Warning", "No active filters defined in this view\nDo you want to load all active Indications?", "Load", "Cancel");
                ssd.setBlockOnOpen(true);
                if (ssd.open() != 0) {
                    return;
                }
            }
            scgci.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void postProcess(ServerClient sc) {
        UnloadActiveIndications.removeFiltered(this.evFilters);
        ScGetActiveIndications cl = (ScGetActiveIndications)sc;
        Object ActiveIndications = cl.getResultObject();
        Iterator iterator = ActiveIndications.iterator();
        while (iterator.hasNext()) {
            SEventFwd sef = (SEventFwd)iterator.next();
            if ('-' == sef.getState()) {
                Repository.getEventStorageSubmit().addEventForced(sef);
                continue;
            }
            Repository.getEventStorageSubmit().addAcknowledgedForced(sef);
        }
        Repository.getEventStorageSubmit().fillTable();
    }
}

