/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.MessageDetailsDialog;
import com.blixx.boom.gui.dialogs.PVDialog;
import com.blixx.boom.gui.dialogs.RemoteActionDialog;
import com.blixx.boom.gui.utils.PatternValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Shell;

public class ManageDialogAction
extends Action {
    public static ArrayList<MessageDetailsDialog> m_indicationDialogs = new ArrayList();
    public static ArrayList<Shell> m_actionDialogs = new ArrayList();
    public static ArrayList<PVDialog> m_pvDialogs = new ArrayList();
    private String m_id = null;
    private String m_name = null;
    private String m_type = null;
    private String m_counter = null;
    private List<String> m_params = null;
    public static String INDICATION_TITLE = "INDICATION_TITLE";
    public static String INDICATION_DIALOG = "INDICATION_DIALOG";
    public static String INDICATION_CLOSE = "INDICATION_CLOSE";
    public static String ACTION_TITLE = "ACTION_TITLE";
    public static String ACTION_DIALOG = "ACTION_DIALOG";
    public static String ACTION_CLOSE = "ACTION_CLOSE";
    public static String PV_TITLE = "PV_TITLE";
    public static String PV_DIALOG = "PV_DIALOG";
    public static String PV_CLOSE = "PV_CLOSE";

    public ManageDialogAction(String type, List<String> params, boolean isChecked) {
        super("organizeOpenDialogs");
        this.setId("organizeOpenDialogs");
        this.m_type = type;
        this.m_params = params;
        if (this.m_params == null) {
            if (this.m_type.equals(INDICATION_TITLE)) {
                this.setText("Indication Dialogs: ");
            } else if (this.m_type.equals(ACTION_TITLE)) {
                this.setText("Action Dialogs: ");
            } else if (this.m_type.equals(PV_TITLE)) {
                this.setText("Pattern Validation Dialogs: ");
            } else if (this.m_type.equals(INDICATION_CLOSE)) {
                this.setText("Close All Indication Dialogs ...");
            } else if (this.m_type.equals(ACTION_CLOSE)) {
                this.setText("Close All Action Dialogs ...");
            } else if (this.m_type.equals(PV_CLOSE)) {
                this.setText("Close All Pattern Validation Dialogs ...");
            }
        } else {
            this.m_id = this.m_params.get(0);
            this.m_name = this.m_params.get(1);
            this.m_counter = this.m_params.get(2);
            this.setText(String.valueOf(this.m_counter) + " " + this.m_name);
            this.setId(this.m_name);
            this.setChecked(isChecked);
            if (this.m_type.equals(INDICATION_DIALOG)) {
                int severity = Integer.parseInt(this.m_params.get(3));
                this.setImageDescriptor(BMUI.getIconDescriptor(severity));
            } else if (this.m_type.equals(ACTION_DIALOG)) {
                String actionType = this.m_params.get(3);
                if (actionType.equals(RemoteActionDialog.ACTION)) {
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_ACTION);
                } else if (actionType.equals(RemoteActionDialog.SERVER_ACTION)) {
                    this.setImageDescriptor(BMUI.IMAGE_DESCR_SERVER_ACTION);
                }
            } else if (this.m_type.equals(PV_DIALOG)) {
                String dialogType = this.m_params.get(3);
                if (dialogType.equals(PatternValidator.JAVA)) {
                    this.setImageDescriptor(BMUI.IMAGE_DESCRIPTOR_PATTERN_VALIDATION);
                } else if (dialogType.equals(PatternValidator.SIMPLIFIED)) {
                    this.setImageDescriptor(BMUI.IMAGE_DESCRIPTOR_PATTERN_VALIDATION_SP);
                }
            }
        }
    }

    public void run() {
        block17: {
            block15: {
                block18: {
                    block16: {
                        if (this.m_params != null) break block15;
                        if (!this.m_type.equals(INDICATION_CLOSE)) break block16;
                        while (m_indicationDialogs.size() > 0) {
                            MessageDetailsDialog dialog = m_indicationDialogs.get(0);
                            dialog.close();
                        }
                        break block17;
                    }
                    if (!this.m_type.equals(ACTION_CLOSE)) break block18;
                    while (m_actionDialogs.size() > 0) {
                        Shell dialog = m_actionDialogs.get(0);
                        dialog.close();
                    }
                    break block17;
                }
                if (!this.m_type.equals(PV_CLOSE)) break block17;
                while (m_pvDialogs.size() > 0) {
                    PVDialog dialog = m_pvDialogs.get(0);
                    dialog.close();
                }
                break block17;
            }
            if (this.m_type.equals(INDICATION_DIALOG)) {
                int i = 0;
                while (i < m_indicationDialogs.size()) {
                    MessageDetailsDialog dialog = m_indicationDialogs.get(i);
                    if (dialog.toString().equals(this.m_id)) {
                        dialog.activate();
                        return;
                    }
                    ++i;
                }
            } else if (this.m_type.equals(ACTION_DIALOG)) {
                int i = 0;
                while (i < m_actionDialogs.size()) {
                    Shell dialogShell = m_actionDialogs.get(i);
                    if (dialogShell != null && dialogShell.toString().equals(this.m_id)) {
                        dialogShell.setActive();
                        if (dialogShell.getMinimized()) {
                            dialogShell.setMinimized(false);
                        }
                        return;
                    }
                    ++i;
                }
            } else if (this.m_type.equals(PV_DIALOG)) {
                int i = 0;
                while (i < m_pvDialogs.size()) {
                    PVDialog dialog = m_pvDialogs.get(i);
                    if (dialog.toString().equals(this.m_id)) {
                        dialog.activate();
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    public static ArrayList<MessageDetailsDialog> getIndicationDialogs() {
        return m_indicationDialogs;
    }

    public static void addIndicationDialog(MessageDetailsDialog dialog) {
        if (!m_indicationDialogs.contains(dialog)) {
            m_indicationDialogs.add(dialog);
        }
    }

    public static void removeIndicationDialog(MessageDetailsDialog dialog) {
        if (m_indicationDialogs.contains(dialog)) {
            m_indicationDialogs.remove(dialog);
        }
    }

    public static MessageDetailsDialog isIndicationDialogOpen(String sEventID) {
        MessageDetailsDialog dialog = null;
        int i = 0;
        while (i < m_indicationDialogs.size()) {
            MessageDetailsDialog md = m_indicationDialogs.get(i);
            if (md.m_se.getID().equals(sEventID)) {
                dialog = md;
                if (!dialog.isDisposed()) break;
                ManageDialogAction.removeIndicationDialog(dialog);
                dialog.close();
                dialog = null;
                break;
            }
            ++i;
        }
        return dialog;
    }

    public static ArrayList<Shell> getActionDialogs() {
        return m_actionDialogs;
    }

    public static void addActionDialog(Shell dialog) {
        if (!m_actionDialogs.contains(dialog)) {
            m_actionDialogs.add(dialog);
        }
    }

    public static void removeActionDialog(Shell dialog) {
        if (m_actionDialogs.contains(dialog)) {
            m_actionDialogs.remove(dialog);
        }
    }

    public static Shell isActionDialogOpen(String actionID) {
        Shell dialog = null;
        Iterator<Shell> it = m_actionDialogs.iterator();
        while (it.hasNext()) {
            Shell s = it.next();
            try {
                String runningID = (String)s.getData(RemoteActionDialog.ACTION_ID);
                if (runningID == null || !runningID.equals(actionID)) continue;
                dialog = s;
                break;
            }
            catch (SWTException sWTException) {
                it.remove();
            }
            catch (Throwable throwable) {}
        }
        return dialog;
    }

    public static ArrayList<PVDialog> getPVDialogs() {
        return m_pvDialogs;
    }

    public static void addPVDialog(PVDialog dialog) {
        if (!m_pvDialogs.contains(dialog)) {
            m_pvDialogs.add(dialog);
        }
    }

    public static void removePVDialog(PVDialog dialog) {
        if (m_pvDialogs.contains(dialog)) {
            m_pvDialogs.remove(dialog);
        }
    }
}

