/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.ITableBrowserProvider;
import com.blixx.boom.gui.dialogs.MonitorHistoryDialog;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class MonitorHistoryAction
extends Action {
    private int m_type = -1;
    private Iterator<SEvent> m_tv_iter = null;
    private ITableBrowserProvider m_eventStorage = null;

    public MonitorHistoryAction(Iterator<SEvent> iter, int type, ITableBrowserProvider es) {
        super("MHA");
        this.m_eventStorage = es;
        this.m_type = type;
        if (this.m_type == 1) {
            this.setText("History (steps)");
            this.setId("Show_History_steps");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_GR2);
        } else {
            this.setText("History ");
            this.setId("Show_History" + this.m_type);
            this.setImageDescriptor(BMUI.IMAGE_DESCR_GR1);
        }
        this.m_tv_iter = iter;
    }

    public void run() {
        SEvent se;
        String id;
        ArrayList<String> keys = new ArrayList<String>();
        while (this.m_tv_iter.hasNext()) {
            SEvent sEvent = this.m_tv_iter.next();
            String origKey = EventStorageUtils.getEventKey(sEvent);
            if (keys.contains(origKey)) continue;
            keys.add(origKey);
        }
        LinkedList<SEvent> arr = new LinkedList<SEvent>();
        Iterator<String> it = this.m_eventStorage.getEventProvider().getActive();
        while (it.hasNext()) {
            id = it.next();
            se = this.m_eventStorage.getEventProvider().getActive(id);
            if (se == null || !keys.contains(EventStorageUtils.getEventKey(se))) continue;
            arr.add(se);
        }
        it = this.m_eventStorage.getEventProvider().getAckn();
        while (it.hasNext()) {
            id = it.next();
            se = this.m_eventStorage.getEventProvider().getAckn(id);
            if (se == null || !keys.contains(EventStorageUtils.getEventKey(se))) continue;
            arr.add(se);
        }
        if (arr.size() > 0) {
            MonitorHistoryDialog md = new MonitorHistoryDialog(Display.getCurrent().getActiveShell(), arr, this.m_type, null, this.m_eventStorage);
            md.open();
        }
    }
}

