/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.BrowserView;
import com.blixx.log.RTLogger;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenBrowserAction
extends Action {
    public String m_url = null;
    public boolean m_forceUseInternal = false;

    public OpenBrowserAction() {
        this.setText("Browser");
        this.setId("showbrowser");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_BROWSER);
        this.m_url = "";
        this.m_forceUseInternal = true;
    }

    public OpenBrowserAction(String url) {
        this.setText("Open Link");
        this.setId("openlink");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_BROWSER);
        this.m_url = url;
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.m_forceUseInternal && UISettings.getInstance().isExternalWebBrowser()) {
            this.runInExternalBrowser();
        } else {
            this.runInternal();
        }
    }

    private void runInternal() {
        try {
            IWorkbenchPage activePage = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.showView("com.blixx.boom.gui.views.browserview");
            if (BrowserView.m_folder.getItems().length == 0) {
                BrowserView.openBrowser(this.m_url, -1);
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "cannot open BrowserView: " + e.getMessage());
            new ShowMessageBox("Error", "Error opening BrowserView :\n" + e.getMessage(), 1);
        }
    }

    public void runInExternalBrowser() {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(128, "browser01", this.m_url, this.m_url);
            browser.openURL(new URL(this.m_url));
        }
        catch (PartInitException e) {
            RTLogger.print(5, "Error opening URL in Message Dialog", e);
            new ShowMessageBox("Error", "Error opening Instruction URL.\nCan't open external browser:\n" + e.getMessage(), 1);
        }
        catch (MalformedURLException e) {
            RTLogger.print(5, "Wrong URL to " + this.m_url + " in Message Dialog", e);
            new ShowMessageBox("Error", "Malformed Instruction URL:\n" + this.m_url, 1);
        }
        catch (Throwable e) {
            RTLogger.print(5, "Error opening Instruction URL", e);
            new ShowMessageBox("Error", "Error opening Instruction URL:\n" + e.getMessage(), 1);
        }
    }
}

