/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.HashMapArray;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenFilterAction
extends Action {
    private FilterFactory m_filterFactory = null;
    public static HashMapArray m_filters = new HashMapArray();
    private TableViewer m_tv = null;
    private CTabItem m_cTab = null;

    public OpenFilterAction(CTabItem ctab, TableViewer tv) {
        super("OpenFilters");
        this.setText("Open Filters");
        this.setId("openfilters");
        this.m_cTab = ctab;
        this.m_tv = tv;
    }

    public void run() {
        this.m_filterFactory = new FilterFactory();
        Shell shell = new Shell(Display.getCurrent().getActiveShell());
        String fileName = null;
        try {
            FileDialog fd = new FileDialog(shell, 4096);
            fd.setText("Select File");
            fileName = fd.open();
            if (fileName != null) {
                File file = new File(fileName);
                if (file.exists() || file.canRead()) {
                    m_filters = this.m_filterFactory.loadFilter(file, this.m_tv);
                    ViewerFilter[] filters = m_filters.getArray(this.m_tv).toArray(new EventFilter[0]);
                    this.m_tv.setFilters(filters);
                    ViewFilterAction.resetFilters(this.m_cTab, this.m_tv, m_filters);
                } else {
                    RTLogger.print(1, "Required file: " + file.getPath() + " not found. Exit.");
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(4, "Error uploading file " + fileName, e);
        }
        shell.dispose();
    }
}

