/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;

public class OpenMessageBrowserAction
extends Action {
    private List<AgentCard> m_acList = new ArrayList<AgentCard>();
    private List<String> m_nodeGroupPathes = null;
    private String m_slaveServerName = null;
    private static int MAX = 10;
    public static String NODE_GROUPS = "NODE_GROUPS";
    protected boolean m_includeSubGroups = false;
    protected boolean m_nodeGroupExtendedFilter = false;
    protected boolean m_showMessagesForAgentAndHost = false;

    public OpenMessageBrowserAction(String slaveServerName) {
        this.m_slaveServerName = slaveServerName;
        this.setText("Show Indications ");
        this.setToolTipText("Show Indications from the selected Server");
        this.setId("openIndicationBrowserForSlave");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (this.m_slaveServerName == null) {
            this.setEnabled(false);
        }
    }

    public OpenMessageBrowserAction(StructuredSelection ssel, String type, boolean includeSubGroups) {
        super("openIndicationBrowser");
        this.m_nodeGroupExtendedFilter = "Node group [Hosts]".equals(type);
        if (includeSubGroups) {
            if (this.m_nodeGroupExtendedFilter) {
                this.setText("Show Indications [Hosts] (Recursive)");
                this.setToolTipText("Matches on IDs, Hostnames or IPs of linked agents");
            } else {
                this.setText("Show Indications (Recursive)");
                this.setToolTipText("Matches on agent IDs");
            }
        } else if (this.m_nodeGroupExtendedFilter) {
            this.setText("Show Indications [Hosts]");
            this.setToolTipText("Matches on IDs, Hostnames or IPs of linked agents");
        } else {
            this.setText("Show Indications");
            this.setToolTipText("Matches on agent IDs");
        }
        this.setId("openIndicationBrowser");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (ssel == null || ssel.isEmpty() || type == null || !type.equals("Node group") && !this.m_nodeGroupExtendedFilter) {
            this.setEnabled(false);
            return;
        }
        this.m_includeSubGroups = includeSubGroups;
        this.m_nodeGroupPathes = new ArrayList<String>(ssel.size());
        for (Object elem : ssel) {
            String ngPath;
            GroupTreeObject nodeGTO;
            if (!(elem instanceof GroupTreeObject) || elem instanceof GroupTreeObjectLast || (nodeGTO = (GroupTreeObject)elem) == null || this.m_nodeGroupPathes.contains(ngPath = nodeGTO.getPath())) continue;
            this.m_nodeGroupPathes.add(ngPath);
        }
        if (this.m_nodeGroupPathes.size() == 0) {
            this.setEnabled(false);
        }
    }

    public OpenMessageBrowserAction(StructuredSelection ssel, boolean showMessagesForAgentAndHost) {
        super("openIndicationBrowser");
        if (showMessagesForAgentAndHost) {
            this.setText("Show Indications [with Host]");
        } else {
            this.setText("Show Indications");
        }
        this.setId("openIndicationBrowser");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (ssel == null || ssel.size() > MAX) {
            this.setEnabled(false);
            return;
        }
        this.m_showMessagesForAgentAndHost = showMessagesForAgentAndHost;
        for (Object o : ssel) {
            GroupTreeObjectLast gtol;
            Object obj;
            if (!(o instanceof GroupTreeObjectLast) || !((obj = (gtol = (GroupTreeObjectLast)o).getTreeObject().getObject()) instanceof AgentCard)) continue;
            this.m_acList.add((AgentCard)obj);
        }
        if (this.m_acList.size() == 0) {
            this.setEnabled(false);
        }
    }

    public OpenMessageBrowserAction(AgentCard ac) {
        super("openIndicationBrowser");
        this.setText("Show Indications");
        this.setId("openIndicationBrowser");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (ac == null) {
            this.setEnabled(false);
            return;
        }
        this.m_acList.add(ac);
    }

    public OpenMessageBrowserAction(List<AgentCard> acList) {
        super("openIndicationBrowser");
        this.setText("Show Indications");
        this.setId("openIndicationBrowser");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (acList == null || acList.size() == 0 || acList.size() > MAX) {
            this.setEnabled(false);
            return;
        }
        this.m_acList.addAll(acList);
    }

    public void run() {
        block13: {
            block14: {
                block12: {
                    if (this.m_slaveServerName == null) break block12;
                    MessagesView.showMessagesForSlaveServer(this.m_slaveServerName, "Server: " + this.m_slaveServerName + " ");
                    break block13;
                }
                if (this.m_acList == null || this.m_acList.size() <= 0) break block14;
                int i = 0;
                while (i < this.m_acList.size()) {
                    String title;
                    AgentCard ac = this.m_acList.get(i);
                    if (this.m_showMessagesForAgentAndHost) {
                        title = String.valueOf(ac.toString()) + "[Agent+Host]";
                        RTLogger.print(5, "Open Filtered Indication Browser for " + title + " ...");
                        MessagesView.showMessagesForAgentAndHost(ac, title);
                    } else if (!ac.isExternal()) {
                        title = String.valueOf(ac.toString()) + "(ID:" + ac.getAgentID() + ")";
                        RTLogger.print(5, "Open Filtered Indication Browser for " + title + " ...");
                        MessagesView.showMessagesForAgent(ac, title);
                    } else {
                        title = String.valueOf(ac.toString()) + "(ID:" + ac.getAgentID() + ")";
                        RTLogger.print(5, "Open Filtered Indication Browser for " + title + " ...");
                        MessagesView.showMessagesForHost(String.valueOf(ac.getAgentHost()) + "|" + ac.getAgentIP(), title);
                    }
                    ++i;
                }
                break block13;
            }
            if (this.m_nodeGroupPathes == null || this.m_nodeGroupPathes.size() <= 0) break block13;
            int i = 0;
            while (i < this.m_nodeGroupPathes.size()) {
                String ngPath = this.m_nodeGroupPathes.get(i);
                if (this.m_includeSubGroups) {
                    if (this.m_nodeGroupExtendedFilter) {
                        MessagesView.showMessagesForNodeGroupExtRecursive(ngPath, "NG[Hosts]: " + ngPath.replace("/root/_Groups/*", ""));
                    } else {
                        MessagesView.showMessagesForNodeGroupRecursive(ngPath, "NG: " + ngPath.replace("/root/_Groups/*", ""));
                    }
                } else if (this.m_nodeGroupExtendedFilter) {
                    MessagesView.showMessagesForNodeGroupExtString(ngPath, "NG[Hosts]: " + ngPath.replace("/root/_Groups/", ""));
                } else {
                    MessagesView.showMessagesForNodeGroupString(ngPath, "NG: " + ngPath.replace("/root/_Groups/", ""));
                }
                ++i;
            }
        }
    }
}

