/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.ExportMPIView;
import com.blixx.boom.gui.views.PolicySearchTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.SelectPolicyInTreeAction;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;

public class OpenPolicyAction
extends Action {
    private List<Object> m_elements = new ArrayList<Object>();
    private TreeViewer m_treeViewer = null;
    private TableViewer m_tableViewer = null;
    private boolean m_selectInTree = false;
    private static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    private static String ASSIGNMENT_LIST = "ASSIGNMENT_LIST";
    private static String AGENT_TREE_VIEWER = "AGENT_TREE_VIEWER";
    private static String VIEWER_TYPE = "VIEWER_TYPE";
    private static String POLICY_OVERVIEW = "POLICY_OVERVIEW";
    private static String SINGLE_DEPLOYED_TABLE_VIEWER = "SINGLE_DEPLOYED_TABLE_VIEWER";
    private static String DEPLOYMENT_QUEUE_TABLE_VIEWER = "DEPLOYMENT_QUEUE_TABLE_VIEWER";
    private static String AGENT_TAB = "AGENT_TAB";
    private int MAX = 30;

    public OpenPolicyAction(TreeViewer treeViewer, boolean selectInTree) {
        super("OpenPolicyAction");
        this.setText("Open Policy");
        this.setId("openpolicy");
        this.m_treeViewer = treeViewer;
        this.m_selectInTree = selectInTree;
        if (this.m_treeViewer == null || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
        for (Object selected : sel) {
            GroupTreeObjectLast gtol;
            String type;
            if (!(selected instanceof GroupTreeObjectLast) || !(type = (gtol = (GroupTreeObjectLast)selected).getTreeObject().getType()).equals("mon") && !type.equals("msg")) continue;
            this.m_elements.add(gtol);
        }
        this.setTitle();
        int size = this.m_elements.size();
        if (size == 0 || size > this.MAX) {
            this.setEnabled(false);
        }
    }

    public OpenPolicyAction(TableViewer tableViewer, boolean selectInTree) {
        super("OpenPolicyAction");
        StructuredSelection sel;
        this.setText("Open Policy");
        this.setId("openpolicy");
        this.m_tableViewer = tableViewer;
        this.m_selectInTree = selectInTree;
        if (this.m_tableViewer == null || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        String tableType = (String)this.m_tableViewer.getData(VIEWER_TYPE);
        if (tableType == null) {
            this.setEnabled(false);
            return;
        }
        if (tableType.equals(SINGLE_DEPLOYED_TABLE_VIEWER) || tableType.equals(DEPLOYMENT_QUEUE_TABLE_VIEWER)) {
            sel = (StructuredSelection)this.m_tableViewer.getSelection();
            for (Object selected : sel) {
                GroupTreeObjectLast gtol;
                Assignment asn;
                String type;
                if (!(selected instanceof Assignment) || !(type = (asn = (Assignment)selected).getType()).equals("mon") && !type.equals("msg") || (gtol = PolicyManager.getInstance().getPolicyTree().findElement(asn.getName(), type)) == null) continue;
                this.m_elements.add(gtol);
            }
        } else if (tableType.equals(POLICY_OVERVIEW)) {
            sel = (StructuredSelection)this.m_tableViewer.getSelection();
            for (Object selected : sel) {
                if (!(selected instanceof String[])) continue;
                this.m_elements.add((String[])selected);
            }
        } else if (tableType.equals(PolicySearchTab.POLICY_SEARCH)) {
            sel = (StructuredSelection)this.m_tableViewer.getSelection();
            for (Object selected : sel) {
                if (!(selected instanceof String[])) continue;
                this.m_elements.add((String[])selected);
            }
        }
        this.setTitle();
        int size = this.m_elements.size();
        if (size == 0 || size > this.MAX) {
            this.setEnabled(false);
        }
    }

    private void setTitle() {
        int size = this.m_elements.size();
        if (size == 1) {
            if (this.isReadOnly()) {
                this.setText("Open Policy (read-only)");
            } else {
                this.setText("Open Policy");
            }
        } else if (size > 1) {
            if (this.isReadOnly()) {
                this.setText("Open Policies (read-only)");
            } else {
                this.setText("Open Policies");
            }
        }
    }

    private boolean isReadOnly() {
        return Repository.getInstance().getRights(1001) < 3;
    }

    public void run() {
        String viewerType = null;
        int max = 30;
        if (this.m_elements.size() < max) {
            max = this.m_elements.size();
        }
        if (this.m_treeViewer != null) {
            viewerType = (String)this.m_treeViewer.getData(TREE_VIEWER_TYPE);
            if (viewerType == null) {
                viewerType = (String)this.m_treeViewer.getData(VIEWER_TYPE);
            }
        } else if (this.m_tableViewer != null) {
            viewerType = (String)this.m_tableViewer.getData(VIEWER_TYPE);
        }
        if (viewerType == null) {
            return;
        }
        if (viewerType.equals(POLICY_OVERVIEW)) {
            String polName = null;
            String polType = null;
            String path = null;
            int i = 0;
            while (i < max) {
                String[] item = (String[])this.m_elements.get(i);
                polName = item[1];
                polType = item[0];
                path = item[6];
                PolicyView.displayPolicy(polName, polType, path, null);
                ++i;
            }
            if (polName == null || polType == null || !this.m_selectInTree) {
                return;
            }
            SelectPolicyInTreeAction selectAction = new SelectPolicyInTreeAction(polName, polType);
            selectAction.run();
        } else if (viewerType.equals(PolicySearchTab.POLICY_SEARCH)) {
            String polName = null;
            String polType = null;
            int i = 0;
            while (i < max) {
                String[] item = (String[])this.m_elements.get(i);
                polName = item[1];
                polType = item[0];
                PolicyView.displayPolicy(polName, polType, null, null);
                ++i;
            }
            if (polName == null || polType == null || !this.m_selectInTree) {
                return;
            }
            SelectPolicyInTreeAction selectAction = new SelectPolicyInTreeAction(polName, polType);
            selectAction.run();
        } else {
            GroupTreeObjectLast gtol = null;
            String name = null;
            String type = null;
            CTabItem cTabItem = null;
            int i = 0;
            while (i < max) {
                gtol = (GroupTreeObjectLast)this.m_elements.get(i);
                if (viewerType.equals(AGENT_TAB)) {
                    name = gtol.getTreeObject().getObject().toString();
                    cTabItem = PolicyView.displayPolicy(name, type = gtol.getType(), null, null);
                    if (cTabItem != null) {
                        PolicyView.activate();
                    }
                } else {
                    PolicyView.displayPolicy(gtol, this.m_treeViewer);
                    PolicyView.activate();
                }
                ++i;
            }
            if (viewerType == null || !this.m_selectInTree) {
                return;
            }
            if (viewerType.equals(ASSIGNMENT_LIST) || viewerType.equals(AGENT_TREE_VIEWER) || viewerType.equals(SINGLE_DEPLOYED_TABLE_VIEWER) || viewerType.equals(DEPLOYMENT_QUEUE_TABLE_VIEWER) || viewerType.equals(ExportMPIView.POLICY) || viewerType.equals(ExportMPIView.POLICY_4EXPORT)) {
                if (gtol != null) {
                    SelectPolicyInTreeAction selectAction = new SelectPolicyInTreeAction(gtol);
                    selectAction.run();
                }
            } else if (viewerType.equals(AGENT_TAB)) {
                if (name == null || type == null) {
                    return;
                }
                SelectPolicyInTreeAction selectAction = new SelectPolicyInTreeAction(name, type);
                selectAction.run();
            }
        }
    }
}

