/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.HashMapArray;
import java.io.File;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenServiceFilterAction
extends Action {
    private FilterFactory m_filterFactory = null;
    public static HashMapArray m_filters = new HashMapArray();
    private TreeViewer m_treeViewer = null;
    private GroupTreeObject m_gto = null;
    private TableViewer m_message_tv = null;
    private EventFilterGroup m_selectedEFG = null;

    public OpenServiceFilterAction(TreeViewer treeViewer, GroupTreeObject gto, TableViewer message_tv, EventFilterGroup selectedEFG) {
        super("ImportServiceFilters");
        this.setText("Import Filters");
        this.setId("importservicefilters");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_IMPORT);
        this.m_treeViewer = treeViewer;
        this.m_gto = gto;
        this.m_message_tv = message_tv;
        this.m_selectedEFG = selectedEFG;
        if (this.m_selectedEFG == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        this.m_filterFactory = new FilterFactory();
        Shell shell = new Shell(Display.getCurrent().getActiveShell());
        String fileName = null;
        try {
            FileDialog fd = new FileDialog(shell, 4096);
            fd.setText("Select File");
            fileName = fd.open();
            if (fileName != null) {
                File file = new File(fileName);
                if (file.exists() || file.canRead()) {
                    m_filters = this.m_filterFactory.loadFilter(file, this.m_message_tv);
                    Iterator it = m_filters.iterator(this.m_message_tv);
                    while (it.hasNext()) {
                        EventFilter ef = (EventFilter)((Object)it.next());
                        if (ef.m_column.equals("Severity") || ef.m_column.equals("SrvTime") || ef.m_column.equals("Time")) continue;
                        ef.m_isLocked = true;
                        this.m_selectedEFG.addFilter(ef);
                        ViewFilterAction.addFilter(null, this.m_message_tv, ef);
                    }
                    this.m_treeViewer.setExpandedState((Object)this.m_gto, true);
                } else {
                    RTLogger.print(1, "Required file: " + file.getPath() + " not found. Exit.");
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(4, "Error uploading file " + fileName, e);
        }
        shell.dispose();
    }
}

