/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.PolicyRenamingDialog;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.SaveDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.TriggerDeploymentDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.PolicyOverviewTab;
import com.blixx.boom.gui.views.PolicySearchTab;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScAsnTreeUpdate;
import com.blixx.ctrl.sc.in.ScDeletePolicy;
import com.blixx.ctrl.sc.in.ScDeploymentTriggerFiltered;
import com.blixx.ctrl.sc.in.ScUpdatePolicy;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;

public class PolicyRenamingAction
extends Action {
    public PolicyRenamingDialog m_pvd = null;
    public Shell m_parentShell = null;
    private TreeViewer m_treeViewer = null;
    private HashMap<String, GroupTreeObjectLast> m_hashMap = new HashMap();
    private String m_type = null;
    private GroupTreeObject m_target = null;
    public static String POLICY_TYPE = "policy_type";
    public static String DIRTY_STATUS = "dirty_Status";
    public static String YES = "YES";
    public static String NO = "NO";
    public static String CANCEL = "CANCEL";
    private CTabItem m_tab = null;

    public PolicyRenamingAction(Shell parentShell, TreeViewer treeViewer, String type) {
        super("policyCopyRenaming");
        this.setId("Policy_CopyRenaming");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_parentShell = parentShell;
        this.m_treeViewer = treeViewer;
        this.m_type = type;
        if (this.m_type.equals(PolicyRenamingDialog.IMPORT_POLICY)) {
            this.setText("Rename Policies");
        } else {
            this.setText("Copy And Rename Policies");
        }
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
        } else {
            GroupTreeObject cfr_ignored_0 = (GroupTreeObject)this.m_treeViewer.getInput();
            ArrayList<GroupTreeObjectLast> elements = new ArrayList<GroupTreeObjectLast>();
            StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
            if (sel.size() > 0) {
                for (Object selected : sel) {
                    if (!(selected instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)selected;
                    if (gto.isGroup()) {
                        elements.addAll(gto.getAllGTOLs());
                        continue;
                    }
                    elements.add((GroupTreeObjectLast)gto);
                }
                int i = 0;
                while (i < elements.size()) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)elements.get(i);
                    boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gtol);
                    this.setEnabled(permittedPolicyModify);
                    if (!permittedPolicyModify) {
                        return;
                    }
                    this.m_hashMap.put(gtol.getName(), gtol);
                    ++i;
                }
            }
            if (this.m_hashMap.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public PolicyRenamingAction(Shell parentShell, TableViewer tableViewer, String type, CTabItem tab) {
        super("policyCopyRenaming");
        this.setText("Copy And Rename Policies");
        this.setId("Policy_CopyRenaming");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_parentShell = parentShell;
        this.m_type = type;
        this.m_tab = tab;
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)tableViewer.getSelection();
        if (sel.size() > 0) {
            HashMap<String, GroupTreeObjectLast> policyGTOLs = this.getAllPolicyGTOLs();
            for (Object selected : sel) {
                String[] item;
                String polName;
                GroupTreeObjectLast gtol;
                if (!(selected instanceof String[]) || (gtol = (GroupTreeObjectLast)policyGTOLs.get(polName = (item = (String[])selected)[1])) == null) continue;
                boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gtol);
                this.setEnabled(permittedPolicyModify);
                if (!permittedPolicyModify) {
                    return;
                }
                this.m_hashMap.put(polName, gtol);
            }
        }
        if (this.m_hashMap.size() == 0) {
            this.setEnabled(false);
        }
    }

    public PolicyRenamingAction(Shell parentShell, String polName, String type, PolicyOverviewTab tab) {
        super("policyCopyRenaming");
        this.setText("Copy And Rename Policies");
        this.setId("Policy_CopyRenaming");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_parentShell = parentShell;
        this.m_type = type;
        this.m_tab = tab;
        if (Repository.getInstance().getRights(1001) < 3 || polName == null || type == null) {
            this.setEnabled(false);
            return;
        }
        HashMap<String, GroupTreeObjectLast> policyGTOLs = this.getAllPolicyGTOLs();
        GroupTreeObjectLast gtol = (GroupTreeObjectLast)policyGTOLs.get(polName);
        if (gtol != null) {
            boolean permittedPolicyModify = PolicyManager.getInstance().isPermittedPolicyModify(gtol);
            this.setEnabled(permittedPolicyModify);
            if (!permittedPolicyModify) {
                return;
            }
            this.m_hashMap.put(polName, gtol);
        }
        if (this.m_hashMap.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (PolicyRenamingAction.checkUnsavedPolicies(this.m_parentShell, this.m_hashMap)) {
            this.m_pvd = new PolicyRenamingDialog(this.m_parentShell, this.m_hashMap, this.m_type);
            this.m_pvd.setBlockOnOpen(true);
            this.m_pvd.open();
            if (this.m_pvd.getReturnCode() == 0) {
                if (this.m_treeViewer == null) {
                    this.m_treeViewer = PolicyListView.getInstance().getTreeViewer();
                }
                if (this.m_treeViewer != null) {
                    this.m_hashMap = this.m_pvd.getElements();
                    try {
                        this.processOnServer(this.isCopying(), this.isRenameOnly());
                    }
                    catch (Throwable e) {
                        RTLogger.print(5, "Error renaming policy: ", e);
                    }
                    Repository.getInstance().fetchPolicies(true);
                }
                if (this.m_tab != null && this.m_tab instanceof PolicyOverviewTab) {
                    ((PolicyOverviewTab)this.m_tab).reloadTable();
                } else if (this.m_tab != null && this.m_tab instanceof PolicySearchTab) {
                    ((PolicySearchTab)this.m_tab).reRunSearch();
                }
            }
        }
    }

    private HashMap<String, GroupTreeObjectLast> getAllPolicyGTOLs() {
        HashMap<String, GroupTreeObjectLast> policies = new HashMap<String, GroupTreeObjectLast>();
        GroupTreeObjectLast gtol = null;
        List<GroupTreeObject> list = PolicyManager.getInstance().getPolicyTree().getAllElements();
        int i = 0;
        while (i < list.size()) {
            GroupTreeObject o = list.get(i);
            if (!(o instanceof GroupTreeObjectUnsubmitted) && o instanceof GroupTreeObjectLast) {
                gtol = (GroupTreeObjectLast)o;
                policies.put(gtol.getName(), gtol);
            }
            ++i;
        }
        return policies;
    }

    public static boolean checkUnsavedPolicies(Shell parentShell, HashMap<String, GroupTreeObjectLast> hashMap) {
        boolean ok = true;
        Boolean isDirty = false;
        ArrayList<CTabItem> tabList_dirty = new ArrayList<CTabItem>();
        ArrayList<CTabItem> tabList_NotDirty = new ArrayList<CTabItem>();
        for (String name : hashMap.keySet()) {
            CTabItem cTab = PolicyView.getTab(name);
            if (cTab == null) continue;
            isDirty = (Boolean)cTab.getData(MonitorPolicyTab.DIRTY_STATUS);
            if (!PolicyView.isTabOpen(name)) continue;
            if (isDirty.booleanValue()) {
                tabList_dirty.add(cTab);
                continue;
            }
            tabList_NotDirty.add(cTab);
        }
        if (tabList_dirty.size() > 0) {
            SaveDialog dialog = new SaveDialog(parentShell);
            dialog.init(PolicyView.getInstance().getFolder(), null, tabList_dirty, SaveDialog.POLICY_RENAMING);
            dialog.setBlockOnOpen(true);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 0) {
                ArrayList<CTabItem> tabs_doSave = dialog.m_tabs_doSave;
                boolean hasVersionConflicts = PolicyRenamingAction.processPolicyTabs(hashMap, tabs_doSave, true);
                if (hasVersionConflicts) {
                    ok = false;
                }
                ArrayList<CTabItem> tabs_doNotSave = dialog.m_tabs_doNotSave;
                PolicyRenamingAction.processPolicyTabs(hashMap, tabs_doNotSave, false);
            } else if (returnCode == SaveDialog.JUST_CLOSE_ID) {
                ArrayList<CTabItem> tabs_doNotSave = dialog.m_tabs_doNotSave;
                int index = 0;
                while (index < tabs_doNotSave.size()) {
                    CTabItem cTab = tabs_doNotSave.get(index);
                    if (cTab instanceof MonitorPolicyTab) {
                        ((MonitorPolicyTab)cTab).setDirty(false);
                    } else if (cTab instanceof FilterPolicyTab) {
                        ((FilterPolicyTab)cTab).setDirty(false);
                    }
                    cTab.dispose();
                    ++index;
                }
                ArrayList<CTabItem> tabs_unchanged = dialog.m_unchangedTabs;
                int index2 = 0;
                while (index2 < tabs_unchanged.size()) {
                    CTabItem cTab = tabs_unchanged.get(index2);
                    if (!(cTab instanceof PolicyOverviewTab)) {
                        cTab.dispose();
                    }
                    ++index2;
                }
            } else if (returnCode == 1) {
                ok = false;
            }
        } else {
            ok = true;
        }
        return ok;
    }

    public static boolean processPolicyTabs(HashMap<String, GroupTreeObjectLast> hashMap, List<CTabItem> aList, boolean doSave) {
        boolean hasVersionConflicts = false;
        for (CTabItem cTab : aList) {
            MonitorPolicyTab mpt;
            FilterPolicyTab fpt;
            String tabName;
            String newName = tabName = cTab.getText();
            if (tabName.startsWith("*")) {
                newName = tabName.substring(2);
            }
            GroupTreeObjectLast gtol = hashMap.get(newName);
            if (doSave) {
                boolean b;
                if (cTab instanceof FilterPolicyTab) {
                    fpt = (FilterPolicyTab)cTab;
                    fpt.save(false);
                    if (fpt.isDisposed() || !(b = ((Boolean)fpt.getData(FilterPolicyTab.HAS_VERSION_CONFLICT)).booleanValue())) continue;
                    hasVersionConflicts = true;
                    continue;
                }
                if (!(cTab instanceof MonitorPolicyTab)) continue;
                mpt = (MonitorPolicyTab)cTab;
                mpt.save(false);
                if (mpt.isDisposed() || !(b = ((Boolean)mpt.getData(MonitorPolicyTab.HAS_VERSION_CONFLICT)).booleanValue())) continue;
                hasVersionConflicts = true;
                continue;
            }
            if (gtol instanceof GroupTreeObjectUnsubmitted) continue;
            if (cTab instanceof FilterPolicyTab) {
                fpt = (FilterPolicyTab)cTab;
                if (!fpt.isDirty()) continue;
                fpt.setDirty(false);
                PolicyView.reOpenTab(fpt.getText(), fpt.getText(), BMUI.type_msg, (String)fpt.getData(FilterPolicyTab.TREE_PATH), fpt.m_selectedCondTab);
                continue;
            }
            if (!(cTab instanceof MonitorPolicyTab) || !(mpt = (MonitorPolicyTab)cTab).isDirty()) continue;
            mpt.setDirty(false);
            PolicyView.reOpenTab(mpt.getText(), mpt.getText(), BMUI.type_mon, (String)mpt.getData(MonitorPolicyTab.TREE_PATH), mpt.m_selectedCondTab);
        }
        return hasVersionConflicts;
    }

    private void processOnServer(boolean copyPolicy, boolean renameOnly) {
        PolicyManager pm = PolicyManager.getInstance();
        LinkedList<ScDeletePolicy.RenamePolicyRequest> successCreated = new LinkedList<ScDeletePolicy.RenamePolicyRequest>();
        HashMap linkList = new HashMap();
        ProgressDialog pd = new ProgressDialog("Renaming Policies", "", 0, this.m_hashMap.size());
        pd.setBlockOnOpen(false);
        pd.open();
        try {
            int count = 0;
            Set<String> keys = this.m_hashMap.keySet();
            for (String nameNew : keys) {
                GroupTreeObjectLast gtol = this.m_hashMap.get(nameNew);
                GroupTreeObject assignmentRoot = null;
                String treePath = gtol.getParentPath();
                String nameOld = gtol.getName();
                String type = gtol.getTreeObject().getType();
                pd.setProgress("Fetching \"" + nameOld + "\"", ++count);
                File fileP = Repository.getInstance().fetchFile(nameOld, type);
                if (fileP == null) {
                    new ShowMessageBox("Sync error", "Failed getting policy from the server: " + nameOld, 1);
                } else {
                    ScDeletePolicy.RenamePolicyRequest dpr;
                    ScUpdatePolicy sc;
                    PolicyFactory pf;
                    String filePath;
                    AbstractPolicy pol;
                    pd.setProgress("Renaming \"" + nameOld + "\"", count);
                    List<Object> links = new ArrayList(0);
                    if (renameOnly) {
                        assignmentRoot = PolicyManager.getInstance().getAsnTree();
                        links = assignmentRoot.findLinksByName(gtol.getPath());
                        linkList.put(links, String.valueOf(treePath) + "/" + nameNew);
                    }
                    if (type.equals(BMUI.type_msg)) {
                        MsgPolicy mp = null;
                        if (copyPolicy) {
                            pol = pm.getMessagePolicy(fileP);
                            mp = MsgPolicy.getCopy((MsgPolicy)pol);
                            mp.setName(pol.getName());
                            treePath = this.m_target.getPath();
                        } else {
                            mp = pm.getMessagePolicy(fileP);
                        }
                        if (!nameNew.equals(gtol.getName())) {
                            mp.setName(nameNew);
                            if (copyPolicy) {
                                mp.setVersion("1.0");
                            }
                        }
                        filePath = String.valueOf(Repository.getUserPoliciesDirectory()) + mp.getName() + BMUI.file_extension_msg;
                        pf = new PolicyFactory();
                        pf.storePolicy(Repository.getUserPoliciesDirectory(), mp);
                        sc = new ScUpdatePolicy(Repository.getInstance(), mp.getName(), type, filePath, treePath);
                        sc.run();
                        if (renameOnly) {
                            if (sc.isSuccess()) {
                                dpr = new ScDeletePolicy.RenamePolicyRequest(nameOld, BMUI.type_msg, nameNew);
                                successCreated.add(dpr);
                                RTLogger.print(5, "Created OK: " + nameNew);
                            } else {
                                linkList.remove(links);
                                RTLogger.print(5, "Create FAILED: " + nameNew);
                            }
                        }
                    } else if (type.equals(BMUI.type_mon)) {
                        Policy p = null;
                        if (copyPolicy) {
                            pol = pm.getMonitorPolicy(fileP);
                            p = Policy.getCopy((Policy)pol);
                            p.setName(pol.getName());
                            treePath = this.m_target.getPath();
                        } else {
                            p = pm.getMonitorPolicy(fileP);
                        }
                        if (!nameNew.equals(gtol.getName())) {
                            p.setName(nameNew);
                            if (copyPolicy) {
                                p.setVersion("1.0");
                            }
                        }
                        filePath = String.valueOf(Repository.getUserPoliciesDirectory()) + p.getName() + BMUI.file_extension_mon;
                        pf = new PolicyFactory();
                        pf.storePolicy(Repository.getUserPoliciesDirectory(), p);
                        sc = new ScUpdatePolicy(Repository.getInstance(), p.getName(), type, filePath, treePath);
                        sc.run();
                        if (sc.isSuccess()) {
                            RTLogger.print(5, "Created OK: " + nameNew);
                            if (renameOnly) {
                                dpr = new ScDeletePolicy.RenamePolicyRequest(nameOld, BMUI.type_mon, nameNew);
                                successCreated.add(dpr);
                            }
                        } else {
                            RTLogger.print(5, "Create FAILED: " + nameNew);
                            linkList.remove(links);
                            StringBuilder sb = new StringBuilder();
                            sb.append("Server failed to create new policy: ").append(nameNew).append("\nError: ").append(sc.getResultObject());
                            MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error creating policy", (String)sb.toString());
                        }
                    }
                }
                PolicyView.reOpenTab(nameOld, nameNew, type, treePath, null);
            }
            if (renameOnly) {
                count = 1;
                pd.setMaximum(3);
                pd.setProgress("Deleting old policies ...", count);
                ScDeletePolicy scn = new ScDeletePolicy(Repository.getInstance(), successCreated.toArray(new ScDeletePolicy.DeletePolicyRequest[0]));
                scn.addCmdPostProcess(new ICmdPostProcess(){

                    public void postProcess(final ServerClient sc) {
                        if (!sc.isSuccess()) {
                            UIJob j = new UIJob(null){

                                @Override
                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("Error: ").append(sc.getResultObject());
                                    MessageDialog.openError((Shell)PolicyRenamingAction.this.m_treeViewer.getControl().getShell(), (String)"Error deleting policy", (String)sb.toString());
                                    return Status.OK_STATUS;
                                }
                            };
                            UIJobManager.getInstance().schedule(j);
                        }
                    }
                });
                Repository.getJobManager().schedule(scn);
                this.triggerDeployment(successCreated);
                pd.setProgress("Updating links ...", ++count);
                ArrayList<ScAsnTreeUpdate.AsnUpdateActionAddLink> updateList = new ArrayList<ScAsnTreeUpdate.AsnUpdateActionAddLink>(linkList.size());
                for (List links : linkList.keySet()) {
                    String treePathSlashName = (String)linkList.get(links);
                    for (GroupTreeObjectLast link : links) {
                        String nameNew = treePathSlashName.substring(treePathSlashName.lastIndexOf(47) + 1);
                        link.setName(nameNew);
                        link.setLinkedPath(treePathSlashName);
                        ScAsnTreeUpdate.AsnUpdateActionAddLink aaa = new ScAsnTreeUpdate.AsnUpdateActionAddLink(treePathSlashName, link.getParentPath(), link.getType());
                        updateList.add(aaa);
                    }
                }
                pd.setProgress("Finishing ...", ++count);
                ScAsnTreeUpdate scnu = new ScAsnTreeUpdate(Repository.getInstance(), updateList.toArray(new ScAsnTreeUpdate.AsnUpdateActionAddLink[0]));
                scnu.run();
                if (!scnu.isSuccess()) {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error updating server", (String)scnu.getResultObject());
                }
                Repository.getInstance().fetchAssignments(true);
            }
        }
        catch (Throwable throwable) {
            try {
                pd.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }

    public void triggerDeployment(List<ScDeletePolicy.RenamePolicyRequest> policiesToUndeploy) {
        if (policiesToUndeploy.size() > 0) {
            LinkedList<String> affectedPolicies = new LinkedList<String>();
            for (ScDeletePolicy.RenamePolicyRequest dpr : policiesToUndeploy) {
                String oldName = dpr.m_name;
                String type = dpr.m_type;
                String newName = dpr.m_newName;
                StringBuilder sb = new StringBuilder();
                sb.append(oldName).append('\u25ba').append(type);
                affectedPolicies.add(sb.toString());
                StringBuilder sb1 = new StringBuilder();
                sb1.append(newName).append('\u25ba').append(type);
                affectedPolicies.add(sb1.toString());
            }
            TriggerDeploymentDialog upd = new TriggerDeploymentDialog(Display.getCurrent().getActiveShell(), "  Deploy Renamed Policies");
            upd.setBlockOnOpen(true);
            upd.open();
            if (upd.getReturnCode() == 0) {
                ScDeploymentTriggerFiltered sc = new ScDeploymentTriggerFiltered(Repository.getInstance(), affectedPolicies.toArray(new String[0]));
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "trigger deployments for " + affectedPolicies.size() + " policies");
                }
                Repository.getJobManager().schedule(sc);
            } else {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentsSummaryView.getInstance());
            }
        }
    }

    public boolean isCopying() {
        boolean b = false;
        if (this.m_pvd.m_target != null) {
            this.m_target = this.m_pvd.m_target;
            b = true;
        }
        return b;
    }

    public boolean isRenaming() {
        boolean b = false;
        if (this.m_pvd.m_prefix.length() > 0 || this.m_pvd.m_suffix.length() > 0) {
            b = true;
        } else if (this.m_pvd.m_find.length() > 0 || this.m_pvd.m_replace.length() > 0) {
            b = true;
        }
        return b;
    }

    public boolean isRenameOnly() {
        return this.isRenaming() && !this.isCopying();
    }
}

