/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.actions.AssignToNodeAction;
import com.blixx.ctrl.sc.in.ScDeploy;
import com.blixx.ctrl.sc.in.ScDeployVirtual;
import com.blixx.ctrl.sc.in.ScUndeploy;
import com.blixx.ctrl.sc.in.ScUndeployDelayed;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;

public class RedeployAction
extends AssignToNodeAction {
    public static final String AGENT = "REDEPLOY";

    public RedeployAction(TreeViewer treeViewer, String action) {
        super(treeViewer, action);
        this.m_action = action;
        this.m_type = (String)treeViewer.getData(TREE_VIEWER_TYPE);
        this.setTitleAndID();
    }

    public RedeployAction(TableViewer tableViewer, String action) {
        super(tableViewer, action);
        this.m_type = null;
        this.m_action = action;
        this.setTitleAndID();
    }

    public RedeployAction(String polName, String polType, String action) {
        super(polName, polType, action);
        this.m_type = null;
        this.m_action = action;
        this.setTitleAndID();
    }

    @Override
    protected void setTitleAndID() {
        if (this.m_action.equals("DEPLOY")) {
            this.setText("Re-Deploy to all");
            this.setId("redeploy all");
        } else if (this.m_action.equals("UNDEPLOY")) {
            if (this.m_type != null && this.m_type.equals("Packages")) {
                this.setText("Mark as UnDeploy from all");
                this.setId("undeployfromallVirtual");
            } else {
                this.setText("UnDeploy from all");
                this.setId("undeployfromall");
            }
        } else if (this.m_action.equals("DEPLOY_DELAYED")) {
            this.setText("Enqueue ReDeployment to all");
            this.setId("Enqueueredeployall");
        } else if (this.m_action.equals("UNDEPLOY_DELAYED")) {
            this.setText("Enqueue UnDeployment from all");
            this.setId("Enqueueundeployfromall");
        }
    }

    @Override
    public void run() {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<String> agentIDs = new ArrayList<String>();
        ArrayList<ScDeploy.NameType> elements = new ArrayList<ScDeploy.NameType>();
        HashMap<AgentCard, Object> agents = new HashMap<AgentCard, Object>();
        if (this.m_elements.size() == 0) {
            return;
        }
        al.ensureCapacity(this.m_elements.size() * 2);
        int i = 0;
        while (i < this.m_elements.size()) {
            GroupTreeObject gtol = (GroupTreeObject)this.m_elements.get(i);
            String type = gtol.getTreeObject().getType();
            if (type == null) {
                RTLogger.print(5, "type is null for element" + gtol);
            } else {
                al.add(type);
                al.add(gtol.getName());
                elements.add(new ScDeploy.NameType(gtol.getName(), type));
                Map<AgentCard, Object> related = Repository.getInstance().getAllAssignments().getAllRelatedAgents(gtol.getName(), type);
                if (related != null) {
                    for (AgentCard ac : related.keySet()) {
                        if (ac == null || !Repository.getInstance().isPermittedAgentModify(ac)) continue;
                        agents.put(ac, related.get(ac));
                        agentIDs.add(ac.getAgentID());
                    }
                }
            }
            ++i;
        }
        String title = this.m_action.startsWith("UNDEPLOY") ? "Undeploy" : "Re-Deploy";
        ShowMessageDialog smd = new ShowMessageDialog(this.m_shell, title, String.valueOf(this.getText()) + "? \n\nRelated Agents:", "Total: " + agents.size() + " Agents", true, "OK", new ArrayList(agents.keySet()), "No related Agents found");
        smd.setBlockOnOpen(true);
        int res = smd.open();
        if (res != 0) {
            return;
        }
        if (agents.size() > 0) {
            ScDeploy sc1 = null;
            String agentIDsAsString = ((Object)agentIDs).toString().replaceAll("[\\[{}\\]]", "");
            if (this.m_action.equals("DEPLOY")) {
                sc1 = new ScDeploy(Repository.getInstance(), AGENT, elements.toArray(new ScDeploy.NameType[0]));
            } else if (this.m_action.equals("UNDEPLOY")) {
                if (this.m_type == null || !this.m_type.equals("Packages")) {
                    sc1 = new ScUndeploy(Repository.getInstance(), AGENT, elements.toArray(new ScDeploy.NameType[0]));
                }
            } else if (this.m_action.equals("DEPLOY_DELAYED")) {
                sc1 = new ScDeployVirtual(Repository.getInstance(), agentIDsAsString, elements.toArray(new ScDeploy.NameType[0]));
            } else if (this.m_action.equals("UNDEPLOY_DELAYED")) {
                sc1 = new ScUndeployDelayed(Repository.getInstance(), agentIDsAsString, elements.toArray(new ScDeploy.NameType[0]));
            }
            if (sc1 != null) {
                Repository.getJobManager().schedule(sc1);
            }
        }
    }
}

