/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.ctrl.sc.in.ScJobRedeployAgents;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RedeployAgentAction
extends Action {
    GroupTreeObjectLast m_gtol = null;
    TreeViewer m_tv = null;
    List<String> m_selectedAgents = null;
    private static int MAX = 1000;

    public RedeployAgentAction(TreeViewer viewer, AgentCard ac) {
        super("UpgradeAgentAction");
        this.setId("upgradeagentaction");
        this.setText("Upgrade Agent");
        this.m_tv = viewer;
        this.m_selectedAgents = new ArrayList<String>();
        if (viewer == null && ac != null) {
            if (this.isUpgradeAllowed(ac)) {
                this.m_selectedAgents.add(ac.getAgentID());
            }
        } else if (viewer != null) {
            this.m_selectedAgents = this.collectSelectedAgent();
        }
        this.checkSelection();
    }

    public RedeployAgentAction(List<AgentCard> agentCardList) {
        super("UpgradeAgentAction");
        this.setId("upgradeagentaction");
        this.setText("Upgrade Agent");
        this.m_selectedAgents = new ArrayList<String>(agentCardList.size());
        int i = 0;
        while (i < agentCardList.size()) {
            AgentCard ac = agentCardList.get(i);
            if (this.isUpgradeAllowed(ac)) {
                this.m_selectedAgents.add(ac.getAgentID());
            }
            ++i;
        }
        this.checkSelection();
    }

    private boolean isUpgradeAllowed(AgentCard ac) {
        return ac != null && ac.isApproved() && !ac.isExternal() && Repository.getInstance().isPermittedAgentModify(ac.getAgentID());
    }

    private void checkSelection() {
        if (this.m_selectedAgents.size() > 1) {
            this.setText("Upgrade Agents");
        }
        if (this.m_selectedAgents.size() == 0 || this.m_selectedAgents.size() > MAX) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled() || this.m_selectedAgents == null || this.m_selectedAgents.size() == 0) {
            return;
        }
        ArrayList<AgentCard> selAgentCards = new ArrayList<AgentCard>();
        String[] IDs = new String[this.m_selectedAgents.size()];
        int i = 0;
        while (i < this.m_selectedAgents.size()) {
            String agentID = this.m_selectedAgents.get(i);
            RTLogger.print(5, "upgrade " + agentID);
            IDs[i] = agentID;
            selAgentCards.add(Repository.getInstance().getAgentCard(agentID));
            ++i;
        }
        String title = "   Upgrade Agent";
        String header = "Do you want to upgrade the following Agent:";
        String footer = "1 Agent to upgrade!";
        String noElementText = "No Agents to upgrade";
        if (this.m_selectedAgents.size() > 1) {
            title = "   Upgrade Agents";
            header = "Do you want to upgrade the following Agents:";
            footer = String.valueOf(this.m_selectedAgents.size()) + " Agents to upgrade!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Upgrade", selAgentCards, noElementText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            ScJobRedeployAgents sc = new ScJobRedeployAgents(Repository.getInstance(), IDs);
            Repository.getJobManager().schedule(sc);
        }
    }

    public List<String> collectSelectedAgent() {
        HashSet<String> selectedAgents = new HashSet<String>();
        HashSet<GroupTreeObject> parentList = new HashSet<GroupTreeObject>();
        HashSet<GroupTreeObject> selectedGTOs = new HashSet<GroupTreeObject>();
        StructuredSelection sel = (StructuredSelection)this.m_tv.getSelection();
        for (Object o : sel) {
            if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                AgentCard ac = (AgentCard)gtoLast.getTreeObject().getObject();
                if (ac == null) {
                    ac = Repository.getInstance().getAgentCard(gtoLast.getLinkedPath());
                }
                if (!this.isUpgradeAllowed(ac)) continue;
                selectedAgents.add(ac.getAgentID());
                if (selectedGTOs.contains(gtoLast.getParent())) continue;
                parentList.add(gtoLast.getParent());
                continue;
            }
            if (!(o instanceof GroupTreeObject)) continue;
            selectedGTOs.add((GroupTreeObject)o);
        }
        for (GroupTreeObject gto : selectedGTOs) {
            if (parentList.contains(gto)) continue;
            List<GroupTreeObjectLast> list = gto.getAllGTOLs();
            for (GroupTreeObjectLast gtol : list) {
                AgentCard ac;
                Object obj = gtol.getTreeObject().getObject();
                if (!(obj instanceof AgentCard) || !this.isUpgradeAllowed(ac = (AgentCard)obj)) continue;
                selectedAgents.add(ac.getAgentID());
            }
        }
        return new ArrayList<String>(selectedAgents);
    }
}

