/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.GUIJob;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.log.RTLogger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;

public class RefreshTreeAction
extends Action {
    String m_commandToProcess = null;
    String m_actionToProcess = null;
    String[] m_params = null;
    private TreeViewer m_treeViewer = null;

    public RefreshTreeAction(TreeViewer treeViewer, String cmd, String action, String[] params) {
        super("Refresh Tree");
        this.setText("Refresh Tree");
        this.setId("Refresh Tree");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
        this.m_treeViewer = treeViewer;
        this.m_commandToProcess = cmd;
        this.m_actionToProcess = action;
        this.m_params = params;
    }

    public void run() {
        if (this.m_treeViewer != null) {
            if (this.m_treeViewer.getData(AssignmentListView.TREE_VIEWER_TYPE).equals(AssignmentListView.ASSIGNMENT_LIST)) {
                Repository.getInstance().fetchAssignments(true);
            } else if (this.m_treeViewer.getData(PolicyListView.TREE_VIEWER_TYPE).equals(PolicyListView.POLICY_LIST)) {
                Repository.getInstance().fetchPolicies(true);
            }
        } else {
            ServerClient sc = new ServerClient(this.m_commandToProcess, this.m_actionToProcess, this.m_params);
            sc.runInUIThread(null);
            if (sc.isSuccess()) {
                RTLogger.print(5, "ACTION has done. Command:" + this.m_commandToProcess + " action:" + this.m_actionToProcess);
                GUIJob job = GUIJob.getRepositoryRefresh(this.m_commandToProcess, sc.isSuccess(), sc.getResultObject());
                Repository.getUIJobManager().schedule(job);
            } else {
                RTLogger.print(5, "ACTION has failed. Command:" + this.m_commandToProcess + " action:" + this.m_actionToProcess);
            }
        }
    }
}

