/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameFPolicyAction
extends Action {
    private ForwardPolicy m_selFwdPolicy = null;
    private ServerFilterView m_sfv = null;
    private Shell m_shell = null;

    public RenameFPolicyAction(ForwardPolicy selFwdPolicy, boolean isNew, ServerFilterView sfv) {
        super("renamefpolicy");
        this.setId("renamefpolicy");
        this.setText("Rename FPolicy");
        this.m_selFwdPolicy = selFwdPolicy;
        this.m_sfv = sfv;
        if (Repository.getInstance().getRights(1009) < 3 || this.m_selFwdPolicy == null || isNew) {
            this.setEnabled(false);
        }
    }

    public void run() {
        String newName;
        FPolicyRenamingDialog dialog = new FPolicyRenamingDialog(this.m_shell, this.m_selFwdPolicy.policyName);
        dialog.setBlockOnOpen(true);
        Window.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        int res = dialog.open();
        if (res == 0 && (newName = dialog.getNewName()) != null && newName.length() > 0) {
            Repository.getInstance().fetchForwardPolicies(true);
            this.m_sfv.setDirty(false);
        }
    }

    private class FPolicyRenamingDialog
    extends Dialog {
        private Composite m_topComp;
        private GUIDisplayElements m_gui;
        private String m_currName;
        private Text m_textField;
        private Text m_infoText;
        private String m_newName;

        public FPolicyRenamingDialog(Shell parentShell, String currName) {
            super(parentShell);
            this.m_topComp = null;
            this.m_gui = null;
            this.m_currName = null;
            this.m_textField = null;
            this.m_infoText = null;
            this.m_newName = null;
            super.setShellStyle(66704);
            FPolicyRenamingDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
            this.m_currName = currName;
        }

        protected Control createDialogArea(Composite parent) {
            this.m_gui = new GUIDisplayElements();
            this.m_topComp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginTop = 10;
            gl.marginWidth = 10;
            this.m_topComp.setLayout((Layout)gl);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 390;
            gd.heightHint = 90;
            this.m_topComp.setLayoutData((Object)gd);
            this.m_textField = this.m_gui.addInputFieldSingle(this.m_topComp, null, "New FowarwardPolicy Name: ", this.m_currName, 1, 1, 0, 0, 60, null);
            this.m_textField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FPolicyRenamingDialog.this.m_newName = FPolicyRenamingDialog.this.m_textField.getText().trim();
                    String errorValidator = new NameValidatorFile().isValid(FPolicyRenamingDialog.this.m_newName);
                    if (FPolicyRenamingDialog.this.m_newName.length() == 0 || FPolicyRenamingDialog.this.nameAlreadyExist(FPolicyRenamingDialog.this.m_newName) || errorValidator != null) {
                        FPolicyRenamingDialog.this.getButton(0).setEnabled(false);
                    } else {
                        FPolicyRenamingDialog.this.getButton(0).setEnabled(true);
                    }
                    FPolicyRenamingDialog.this.m_textField.setToolTipText(errorValidator);
                }
            });
            this.m_infoText = this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "", 1, 1, 0, 0, BMUI.font_arial8);
            this.m_infoText.setForeground(BMUI.color_critical);
            ((GridData)this.m_infoText.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_infoText.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)this.m_infoText.getLayoutData()).widthHint = 60;
            return this.m_topComp;
        }

        private boolean nameAlreadyExist(String newName) {
            boolean exist = false;
            String infoText = "";
            ArrayList fpolicies = new ArrayList();
            int i = 0;
            while (i < fpolicies.size()) {
                ForwardPolicy fwp = (ForwardPolicy)fpolicies.get(i);
                if (fwp.policyName.equals(newName)) {
                    exist = true;
                    infoText = "Name does alreay exists!";
                    break;
                }
                ++i;
            }
            this.m_infoText.setText(infoText);
            return exist;
        }

        protected String getNewName() {
            return this.m_newName;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "OK", true);
            this.createButton(parent, 1, "Cancel", false);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setImage(BMUI.IMAGE_PRODUCT);
            newShell.setText("Rename ForwardPolicy");
        }

        protected void okPressed() {
            super.okPressed();
        }

        public boolean close() {
            try {
                this.m_topComp.dispose();
            }
            catch (Throwable throwable) {}
            return super.close();
        }
    }
}

