/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.editors.OpenFileAction;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.FileDialog;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class RenameFileAction
extends Action {
    public String m_path = null;
    public String m_newPath = null;
    public String m_fileName_initial = null;
    public String m_fileName = null;
    private GroupTreeObjectLast m_fileGTOL = null;

    public RenameFileAction(StructuredSelection ssel, String path, GroupTreeObjectLast fileGTOL) {
        this.setText("Rename File");
        if (fileGTOL == null || path == null || ssel.size() > 1 || Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
            return;
        }
        this.m_fileGTOL = fileGTOL;
        this.m_path = "srv/packages" + path;
        this.m_fileName_initial = fileGTOL.getName();
        this.m_fileName = fileGTOL.getName();
    }

    private void run(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_fileName = name;
        this.run();
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        boolean isFileOpen = false;
        IEditorReference eRef = null;
        IEditorReference[] editors = BinariesListView.getInstance().getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            String title;
            eRef = editors[i];
            String[] split = eRef.getTitle().split("/");
            if (split != null && split.length > 0 && (title = split[split.length - 1]).equals(this.m_fileName_initial)) {
                if (eRef.isDirty()) {
                    new ShowMessageBox("Rename File", "File has been modified but not yet saved. Please save the file first.", 1);
                    return;
                }
                isFileOpen = true;
                break;
            }
            ++i;
        }
        FileDialog id = new FileDialog(Display.getCurrent().getActiveShell(), "  Rename file", "Please enter new filename", this.m_fileName_initial, this.m_fileName, new NameValidatorFile());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            String name = id.getValue();
            if (name != null && name.length() > 0) {
                if (name.equals(this.m_fileName_initial)) {
                    return;
                }
                GroupTreeObject gto = this.m_fileGTOL.getParent().getFirstChild(name);
                if (gto != null) {
                    new ShowMessageBox(" Rename File", "File name does already exist!", 2);
                    this.run(name);
                } else {
                    this.m_newPath = this.m_path.substring(0, this.m_path.length() - this.m_fileName_initial.length());
                    this.m_newPath = String.valueOf(this.m_newPath) + name;
                    ServerClient sc = ServerClient.renameFile(this.m_path, this.m_newPath);
                    sc.runInUIThread(null);
                    if (sc.isSuccess()) {
                        RTLogger.print(5, "File renamed. " + this.m_newPath);
                        BinariesListView.getInstance().refreshTree(true);
                        if (isFileOpen) {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(new IEditorReference[]{eRef}, false);
                                GroupTreeObject binary = Repository.getInstance().getBinaryTree().findFirstGroup(this.m_fileGTOL.getParent().getName(), this.m_fileGTOL.getParent().getType());
                                GroupTreeObjectLast newFileGTO = binary.findElement(name, this.m_fileGTOL.getType());
                                OpenFileAction action = new OpenFileAction(BinariesListView.getInstance().getSite().getWorkbenchWindow(), newFileGTO);
                                action.run();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            } else {
                RTLogger.print(5, "Error renaming file: " + this.m_newPath);
            }
        }
    }
}

