/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.NameValidatorHostGroup;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class RenameGroupTreeObjectAction
extends Action {
    private GroupTreeObject m_gto = null;
    private TreeViewer m_treeViewer = null;
    private String m_treeType = null;
    private GroupTreeObject m_assignmentRoot = PolicyManager.getInstance().getAsnTree();
    private UpdateServer usrv = new UpdateServer();

    public RenameGroupTreeObjectAction(TreeViewer treeViewer, GroupTreeObject gto, String treeType) {
        super("RenameGroup");
        this.setText("Rename Group");
        this.setId("rename_GroupTreeObject");
        this.m_gto = gto;
        this.m_treeViewer = treeViewer;
        this.m_treeType = treeType;
        if (this.m_gto == null || this.m_treeType == null || this.m_treeViewer == null || this.m_treeViewer.getTree().getSelectionCount() > 1) {
            this.setEnabled(false);
            return;
        }
        if (this.m_treeType.equals(BMUI.type_tree_policy) || this.m_treeType.equals(BMUI.type_tree_policy_renaming_dialog)) {
            if (Repository.getInstance().getRights(1001) < 3) {
                this.setEnabled(false);
            } else if (!PolicyManager.getInstance().isPermittedPolicyModifyRecursive(this.m_gto)) {
                this.setEnabled(false);
            }
        } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
            if (!PolicyManager.getInstance().isPermittedPGAModify(this.m_gto)) {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        InputDialog id = new InputDialog(this.m_treeViewer.getControl().getShell(), "Rename Group", "Please enter a new Group Name", this.m_gto.getName().toString(), (IInputValidator)new NameValidatorHostGroup());
        id.setBlockOnOpen(true);
        Window.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        int res = id.open();
        if (res == 0 && !this.m_gto.getName().equals(id.getValue().trim())) {
            if (this.m_gto.getParent().getChild(id.getValue(), this.m_gto.getType()) != null) {
                MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error", (String)"Another Group with this name already exists on the same level!\nPlease enter a different name.");
                this.run();
            } else {
                boolean isSuccess = false;
                Map<List, String> hmLinks = new HashMap<List, String>();
                String oldTreePath = this.m_gto.getPath();
                if (this.m_treeType.equals(BMUI.type_tree_policy)) {
                    String newPath = String.valueOf(this.m_gto.getParentPath()) + "/" + id.getValue();
                    hmLinks = this.getLinks(this.m_gto, newPath, hmLinks);
                    isSuccess = this.usrv.syncWithServer(oldTreePath, id.getValue(), CMDS.ACTION_RNM, this.m_gto.getType());
                } else if (this.m_treeType.equals(BMUI.type_tree_assignment)) {
                    isSuccess = this.usrv.syncAsnWithServer(oldTreePath, id.getValue(), CMDS.ACTION_RNM, this.m_gto.getType());
                }
                if (isSuccess) {
                    this.m_gto.setName(id.getValue());
                    Object[] expanded1 = this.m_treeViewer.getExpandedElements();
                    this.m_treeViewer.refresh();
                    int index = 0;
                    while (index < expanded1.length) {
                        this.m_treeViewer.setExpandedState(expanded1[index], true);
                        ++index;
                    }
                    if (this.m_treeType.equals(BMUI.type_tree_policy)) {
                        this.updateLinks(hmLinks);
                        Repository.getInstance().fetchAssignments(true);
                    }
                } else {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error renaming Tree Group", (String)this.usrv.m_resultString);
                }
            }
        }
    }

    public Map<List, String> getLinks(GroupTreeObject gtoParent, String newPath, Map<List, String> hm) {
        List<GroupTreeObject> elements = gtoParent.getElements();
        for (GroupTreeObject o : elements) {
            if (!(o instanceof GroupTreeObjectLast)) {
                GroupTreeObject gto = o;
                this.getLinks(gto, String.valueOf(newPath) + "/" + gto.getName(), hm);
                continue;
            }
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            List<GroupTreeObjectLast> linkList = this.m_assignmentRoot.findLinksByName(gtol.getPath());
            if (linkList.size() <= 0) continue;
            hm.put(linkList, newPath);
        }
        return hm;
    }

    public void updateLinks(Map<List, String> hmLinks) {
        ProgressDialog pd = new ProgressDialog("Update Assignments", "", 0, hmLinks.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int processingNumber = 0;
        ServerClientBatch scb = new ServerClientBatch("GETAGENTCARDS");
        scb.openSocket();
        try {
            for (List linkList : hmLinks.keySet()) {
                String newLinkPath = hmLinks.get(linkList);
                Iterator it = linkList.iterator();
                boolean deleteOk = false;
                boolean addOk = false;
                ++processingNumber;
                while (it.hasNext()) {
                    GroupTreeObjectLast link = (GroupTreeObjectLast)it.next();
                    pd.setProgress("Updating link " + newLinkPath + "/" + link.getName(), processingNumber);
                    scb.setCommand("ASSIGNMENTTREEUPDATE2", null, new String[]{link.getPath(), "nonrecursive", CMDS.ACTION_DELLINK_noDeploy, link.getType()});
                    scb.runBatch();
                    deleteOk = scb.isSuccess();
                    if (deleteOk) {
                        scb.setCommand("ASSIGNMENTTREEUPDATE2", null, new String[]{String.valueOf(newLinkPath) + "/" + link.getName(), link.getParentPath(), CMDS.ACTION_ADDLINK_noDeploy, link.getType()});
                        scb.runBatch();
                        addOk = scb.isSuccess();
                    }
                    if (deleteOk && addOk) continue;
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Rename Group", (String)("Error updating link " + link.getName() + "!"));
                    RTLogger.print(3, "Error updating link " + link.getName());
                }
            }
        }
        catch (Throwable throwable) {
            try {
                scb.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scb.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
    }
}

