/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ActionAndHostGroupDialog;
import com.blixx.boom.gui.dialogs.NameValidatorHostGroup;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.ScErrorShowMessage;
import com.blixx.boom.gui.utils.XMLTree;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScRenameNodeGroup;
import com.blixx.shared.BM;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.w3c.dom.Document;

public class RenameHostGroupAction
extends Action {
    private Viewer m_viewer = null;
    private GroupTreeObject m_root = null;
    private String m_localPath = null;
    private String m_srvPath = null;
    private String m_filename = null;
    private String m_hostGrpName_initial = null;
    private String m_hostGrpName = null;
    private String m_groupType = null;
    private String m_parentPath = null;

    public RenameHostGroupAction(Viewer viewer, String fname, String srvPath, String localpath, String gName, String gType, String parentPath, GroupTreeObject root) {
        this.setText("Rename Group");
        this.setId("RenameGTO");
        this.m_viewer = viewer;
        this.m_hostGrpName_initial = gName;
        this.m_hostGrpName = gName;
        this.m_groupType = gType;
        this.m_parentPath = parentPath;
        this.m_root = root;
        this.m_localPath = localpath;
        this.m_srvPath = srvPath;
        this.m_filename = fname;
        if (Repository.getInstance().getRights(1002) < 3) {
            this.setEnabled(false);
        }
        GroupTreeObject folder = this.m_root.searchPath(String.valueOf(this.m_parentPath) + BM.GTO_PATH_SEPARATOR + this.m_hostGrpName_initial, this.m_groupType);
        if (!Repository.getInstance().isPermittedNodeGroupModify(folder)) {
            this.setEnabled(false);
        }
    }

    private void run(String name) {
        if (!this.isEnabled()) {
            return;
        }
        this.m_hostGrpName = name;
        this.run();
    }

    public void run() {
        String name;
        ActionAndHostGroupDialog id = new ActionAndHostGroupDialog(this.m_viewer.getControl().getShell(), "  Rename Host Group", "Please enter a Host Group Name:", this.m_hostGrpName_initial, this.m_hostGrpName, new NameValidatorHostGroup());
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0 && (name = id.getValue()) != null && name.length() > 0) {
            if (name.equals(this.m_hostGrpName_initial)) {
                return;
            }
            GroupTreeObject gto = this.m_root.searchPath(String.valueOf(this.m_parentPath) + "/" + name, this.m_groupType);
            if (gto != null) {
                new ShowMessageBox(" Rename Node Group", "A Node Group with this name does already exist!", 2);
                this.run(name);
            } else {
                ScRenameNodeGroup scrnm = new ScRenameNodeGroup(Repository.getInstance(), String.valueOf(this.m_parentPath) + "/" + this.m_hostGrpName_initial, String.valueOf(this.m_parentPath) + "/" + name);
                final String fname = name;
                scrnm.addCmdPostProcess(new ICmdPostProcess(){

                    public void postProcess(ServerClient cmd) {
                        if (!cmd.isSupported()) {
                            GroupTreeObject group = RenameHostGroupAction.this.m_root.searchPath(String.valueOf(RenameHostGroupAction.this.m_parentPath) + "/" + RenameHostGroupAction.this.m_hostGrpName_initial, RenameHostGroupAction.this.m_groupType);
                            if (group != null) {
                                group.setName(fname);
                                GroupTreeObject rroot = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
                                rroot.addElement(RenameHostGroupAction.this.m_root);
                                XMLTree xt = new XMLTree();
                                Document doc = xt.getXML(rroot);
                                XMLFactory.writeXml(doc, String.valueOf(RenameHostGroupAction.this.m_localPath) + RenameHostGroupAction.this.m_filename);
                                com.blixx.boom.engine.ServerClient sc = com.blixx.boom.engine.ServerClient.putFile(String.valueOf(RenameHostGroupAction.this.m_srvPath) + RenameHostGroupAction.this.m_filename, String.valueOf(RenameHostGroupAction.this.m_localPath) + RenameHostGroupAction.this.m_filename);
                                Repository.getJobManager().schedule(sc);
                            } else {
                                new ShowMessageBox("  Missing Node Group", "Cannot rename '" + RenameHostGroupAction.this.m_hostGrpName_initial + "'. Group does not exist!", 2);
                                return;
                            }
                        }
                    }
                });
                scrnm.addCmdPostProcess(new ScErrorShowMessage("Error renaming node group: " + this.m_hostGrpName_initial));
                Repository.getJobManager().schedule(scrnm);
            }
        }
    }
}

