/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RenamePkgAction
extends Action {
    public String m_path = null;
    public String m_newPath = null;
    public String m_shortName = null;
    public GroupTreeObject m_gto = null;

    public RenamePkgAction(StructuredSelection ssel, String path, String shortName, String text) {
        this.m_path = "srv/packages" + path;
        this.m_shortName = shortName;
        this.setText(text);
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
        } else if (ssel.isEmpty() || ssel.size() > 1) {
            this.setEnabled(false);
        }
        this.m_gto = (GroupTreeObject)ssel.getFirstElement();
    }

    public void run() {
        InputDialog id = new InputDialog(Display.getCurrent().getActiveShell(), "  Rename Package", "Please enter new name", this.m_shortName, (IInputValidator)new NameValidatorFile());
        id.setBlockOnOpen(true);
        InputDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        int res = id.open();
        if (res == 0 && !this.m_gto.getName().equals(id.getValue().trim())) {
            String newNme = id.getValue();
            if (this.m_gto.getParent().getChild(id.getValue(), this.m_gto.getType()) != null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Another Group with this name already exists on the same level!\nPlease enter a different name.");
                this.run();
            } else {
                this.m_newPath = this.m_path.substring(0, this.m_path.length() - this.m_shortName.length());
                this.m_newPath = String.valueOf(this.m_newPath) + newNme;
                ServerClient sc = ServerClient.renamePackage(this.m_path, this.m_newPath);
                sc.runInUIThread(null);
                if (sc.isSuccess()) {
                    RTLogger.print(5, "PKG renamed. " + this.m_newPath);
                    BinariesListView.getInstance().refreshTree(true);
                } else {
                    RTLogger.print(5, "Error renaming PKG: " + this.m_path);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error renaming PKG: " + this.m_path + "\n" + sc.getResultObject()));
                    this.run();
                }
            }
        }
    }
}

