/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.UserRole;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class RenameRoleAction
extends Action {
    private TreeViewer m_treeViewer = null;
    GroupTreeObject m_gto = null;

    public RenameRoleAction(TreeViewer treeViewer, Shell parentShell, GroupTreeObject gto) {
        super("RenameUserRole");
        this.setText("Rename User Role");
        this.setId("RenameUserRole");
        this.m_treeViewer = treeViewer;
        this.m_gto = gto;
        if (Repository.getInstance().getRights(1004) < 3 || this.m_gto == null || this.m_gto.getName().equals(UserManager.ADMINISTRATOR) || this.m_treeViewer == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        InputDialog id = new InputDialog(this.m_treeViewer.getControl().getShell(), "  Rename User Role", "Group Name", this.m_gto.getName(), null);
        Window.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            boolean exist = Repository.getInstance().getUserManager().roleExist(id.getValue());
            if (exist) {
                MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Information", (String)"Role does already exist. Please choose a different name!");
            } else {
                UserRole role = Repository.getInstance().getUserManager().getRoleByName(this.m_gto.getName());
                role.setName(id.getValue().trim());
                Repository.getInstance().getUserManager().saveRole(role);
            }
        }
    }
}

