/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameTabAction
extends Action {
    private CTabFolder m_folder = null;
    private CTabItem m_currentTab = null;
    private Shell m_parentShell = null;
    private String m_currentTitle = null;
    private Text m_infoText = null;

    public RenameTabAction(CTabFolder folder, Shell parentShell, String currentTitle) {
        super("RenameTab");
        this.setId("RenameTab");
        this.setText("Rename");
        this.m_folder = folder;
        this.m_parentShell = parentShell;
        this.m_currentTitle = currentTitle;
        if (this.m_folder == null) {
            this.setEnabled(false);
            return;
        }
        this.m_currentTab = this.m_folder.getSelection();
        if (this.m_currentTab == null || this.m_currentTab instanceof MessageBrowserTab && ((MessageBrowserTab)this.m_currentTab).isPredefinedTab()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (Repository.getInstance().getRights(1000) < 3 || !this.isEnabled() || this.m_folder == null || this.m_parentShell == null) {
            return;
        }
        TabRenamingDialog dialog = new TabRenamingDialog(this.m_parentShell, "  Rename Indication Tab", "Please enter a new Name: ", this.m_currentTitle);
        dialog.setBlockOnOpen(true);
        Window.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        int res = dialog.open();
        if (res == 0) {
            String newTitle = dialog.getNewTitle();
            newTitle = this.validateNewTitle(newTitle);
            this.m_currentTab.setText(newTitle);
            this.m_currentTab.setData((Object)MessagesView.RENAMED);
            if (this.m_currentTab instanceof MessageBrowserTab) {
                UISettings.getInstance().storeAndReload();
            }
        }
    }

    private boolean titelAlreadyExist(String newTitle) {
        boolean exist = false;
        newTitle = newTitle.replace("[Active]", "");
        newTitle = newTitle.replace("[Closed]", "");
        int i = 0;
        while (i < this.m_folder.getItemCount()) {
            CTabItem tab = this.m_folder.getItem(i);
            if (!tab.equals(this.m_currentTab)) {
                String title = tab.getText();
                title = title.replace("[Active]", "");
                if ((title = title.replace("[Closed]", "")).equalsIgnoreCase(newTitle)) {
                    exist = true;
                    break;
                }
            }
            ++i;
        }
        if (exist) {
            this.m_infoText.setText("Title alreay exists!");
        } else {
            this.m_infoText.setText("");
        }
        return exist;
    }

    private String validateNewTitle(String newTitle) {
        newTitle = newTitle.replace("[Active]", "");
        newTitle = newTitle.replace("[Closed]", "");
        if (this.m_currentTitle.contains("[Active]")) {
            newTitle = String.valueOf(newTitle) + "[Active]";
        } else if (this.m_currentTitle.contains("[Closed]")) {
            newTitle = String.valueOf(newTitle) + "[Closed]";
        }
        return newTitle;
    }

    private class TabRenamingDialog
    extends Dialog
    implements ModifyListener {
        private Composite m_topComp;
        private GUIDisplayElements m_gui;
        private String m_title;
        private String m_message;
        private String m_currTitle;
        private Text m_textField;
        private String m_newTitle;
        public static final String NEW_NAME = "NEW_NAME";

        public TabRenamingDialog(Shell parentShell, String title, String message, String currTitle) {
            super(parentShell);
            this.m_topComp = null;
            this.m_gui = null;
            this.m_title = null;
            this.m_message = null;
            this.m_currTitle = null;
            this.m_textField = null;
            this.m_newTitle = null;
            super.setShellStyle(66704);
            TabRenamingDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
            this.m_title = title;
            this.m_message = message;
            this.m_currTitle = currTitle;
        }

        protected Control createDialogArea(Composite parent) {
            this.m_gui = new GUIDisplayElements();
            this.m_topComp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginTop = 10;
            gl.marginWidth = 10;
            this.m_topComp.setLayout((Layout)gl);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 390;
            gd.heightHint = 90;
            this.m_topComp.setLayoutData((Object)gd);
            this.m_textField = this.m_gui.addInputFieldSingle(this.m_topComp, NEW_NAME, this.m_message, this.m_currTitle, 1, 1, 0, 0, 60, this);
            RenameTabAction.this.m_infoText = this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "", 1, 1, 0, 0, BMUI.font_arial8);
            RenameTabAction.this.m_infoText.setForeground(BMUI.color_critical);
            ((GridData)((RenameTabAction)RenameTabAction.this).m_infoText.getLayoutData()).horizontalAlignment = 4;
            ((GridData)((RenameTabAction)RenameTabAction.this).m_infoText.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)((RenameTabAction)RenameTabAction.this).m_infoText.getLayoutData()).widthHint = 60;
            return this.m_topComp;
        }

        protected String getNewTitle() {
            return this.m_newTitle;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "OK", true);
            this.createButton(parent, 1, "Cancel", false);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setImage(BMUI.IMAGE_PRODUCT);
            newShell.setText(this.m_title);
        }

        protected void okPressed() {
            super.okPressed();
        }

        public boolean close() {
            try {
                this.m_topComp.dispose();
            }
            catch (Throwable throwable) {}
            return super.close();
        }

        public void modifyText(ModifyEvent e) {
            Text text;
            String name;
            if (e.getSource() instanceof Text && (name = (String)(text = (Text)e.getSource()).getData()).equals(NEW_NAME)) {
                this.m_newTitle = this.m_textField.getText().trim();
                if (this.m_newTitle.length() == 0) {
                    this.getButton(0).setEnabled(false);
                } else {
                    this.getButton(0).setEnabled(true);
                }
            }
        }
    }
}

