/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.ctrl.sc.in.ScJobRestartAgents;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RestartAgentAction
extends Action {
    ArrayList<AgentCard> m_selectedAgents = new ArrayList();
    private static int MAX = 1000;

    private RestartAgentAction() {
        super("RestartAgent");
        this.setText("Restart Agent");
        this.setId("RestartAgent");
    }

    public RestartAgentAction(List<AgentCard> selectedAgents) {
        this();
        this.m_selectedAgents.ensureCapacity(selectedAgents.size());
        for (AgentCard ac : selectedAgents) {
            if (!this.isUpgradeAllowed(ac)) continue;
            this.m_selectedAgents.add(ac);
        }
        this.checkSelection();
    }

    private boolean isUpgradeAllowed(AgentCard ac) {
        return ac != null && ac.isApproved() && !ac.isExternal() && Repository.getInstance().isPermittedAgentModify(ac.getAgentID());
    }

    private void checkSelection() {
        if (this.m_selectedAgents.size() > 1) {
            this.setText("Restart Agents");
        }
        if (this.m_selectedAgents.size() == 0 || this.m_selectedAgents.size() > MAX) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled() || this.m_selectedAgents == null || this.m_selectedAgents.size() == 0) {
            return;
        }
        String title = "   Restart Agent";
        String header = "Do you want to restart the following Agent:";
        String footer = "1 Agent to restart!";
        String noElementText = "No Agents to restart";
        if (this.m_selectedAgents.size() > 1) {
            title = "   Restart Agents";
            header = "Do you want to restart the following Agents:";
            footer = String.valueOf(this.m_selectedAgents.size()) + " Agents to restart!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Restart", this.m_selectedAgents, noElementText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            String[] IDs = new String[this.m_selectedAgents.size()];
            int i = 0;
            while (i < this.m_selectedAgents.size()) {
                IDs[i] = this.m_selectedAgents.get(i).getAgentID();
                ++i;
            }
            ScJobRestartAgents sc = new ScJobRestartAgents(Repository.getInstance(), IDs);
            Repository.getJobManager().schedule(sc);
        }
    }
}

