/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.log.RTLogger;
import java.io.File;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveFilterAction
extends Action {
    private FilterFactory m_filterFactory = null;
    private TableViewer m_tv = null;

    public SaveFilterAction(TableViewer tv) {
        super("SaveFilters");
        this.setText("Save Filters");
        this.setId("savefilters");
        this.m_tv = tv;
    }

    public void run() {
        this.m_filterFactory = new FilterFactory();
        Shell shell = new Shell(Display.getCurrent().getActiveShell());
        String path = null;
        boolean success = true;
        try {
            FileDialog fd = new FileDialog(shell, 8192);
            fd.setText("  Export Filter");
            path = fd.open();
            if (path != null) {
                File file = new File(path);
                if (file.exists()) {
                    success = file.delete();
                }
                if (success) {
                    Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(this.m_tv);
                    this.m_filterFactory.storeFilter(file, it);
                } else {
                    RTLogger.print(4, "File exists, error deleting file");
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving file" + path, e);
        }
        shell.dispose();
    }
}

