/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.gui.utils.FilterFactory;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.log.RTLogger;
import java.io.File;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveServiceFilterAction
extends Action {
    private FilterFactory m_filterFactory = null;
    private TableViewer m_message_tv = null;
    private EventFilterGroup m_selectedEFG = null;

    public SaveServiceFilterAction(TableViewer message_tv, EventFilterGroup selectedEFG) {
        super("ExportServiceFilters");
        this.setText("Export Filters");
        this.setId("exportservicefilters");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_EXPORT);
        this.m_message_tv = message_tv;
        this.m_selectedEFG = selectedEFG;
        if (this.m_selectedEFG == null || this.m_selectedEFG.getFilters().size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        this.m_filterFactory = new FilterFactory();
        Shell shell = new Shell(Display.getCurrent().getActiveShell());
        String path = null;
        boolean success = true;
        try {
            FileDialog fd = new FileDialog(shell, 8192);
            fd.setText("  Export Filter");
            path = fd.open();
            if (path != null) {
                File file = new File(path);
                if (file.exists()) {
                    success = file.delete();
                }
                if (success) {
                    Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(this.m_message_tv);
                    this.m_filterFactory.storeFilter(file, it);
                } else {
                    RTLogger.print(4, "File exists, error deleting file");
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving file" + path, e);
        }
        shell.dispose();
    }
}

