/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.log.RTLogger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;

public class SearchPolicyAction
extends Action {
    private String m_searchText = null;
    private String[] m_properties = null;
    private int m_action = 0;
    private Map<String, String> m_result = null;

    public SearchPolicyAction() {
        super("SearchPolicy");
        this.setId("searchpolicy");
        this.setText("Search Policy");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_SEARCH);
        this.m_action = 0;
        if (Repository.getInstance().getRights(1001) < 2) {
            this.setEnabled(false);
        }
    }

    public SearchPolicyAction(String[] properties, String searchText) {
        super("SearchPolicyTest");
        this.setId("searchpolicyTest");
        this.setText("Search Policy Test");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_SEARCH);
        this.m_action = 1;
        this.m_properties = properties;
        this.m_searchText = searchText;
        if (Repository.getInstance().getRights(1001) < 2 || this.m_searchText == null || this.m_searchText.length() == 0) {
            this.setEnabled(false);
        }
    }

    public SearchPolicyAction(String[] properties) {
        super("SearchPolicyTest");
        this.setId("searchpolicyTest");
        this.setText("Search Policy Test");
        this.setImageDescriptor(BMUI.IMAGE_DESCR_SEARCH);
        this.m_action = 2;
        this.m_properties = properties;
        if (Repository.getInstance().getRights(1001) < 2 || this.m_properties == null || this.m_properties.length == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        switch (this.m_action) {
            case 0: {
                PolicyView.displayPolicySearch();
                break;
            }
            case 1: {
                if (this.m_searchText == null || this.m_searchText.length() == 0 || this.m_properties == null || this.m_properties.length == 0) {
                    return;
                }
                RTLogger.print(5, "*** START GLOBAL POLICY SEARCH (searchText=" + this.m_searchText + ")");
                this.startSearch();
                break;
            }
            case 2: {
                if (this.m_properties == null || this.m_properties.length == 0) {
                    return;
                }
                RTLogger.print(5, "*** START ADVANCED POLICY SEARCH");
                int i = 0;
                while (i < this.m_properties.length) {
                    RTLogger.print(5, this.m_properties[i].toString());
                    ++i;
                }
                this.startSearch();
            }
        }
    }

    private void startSearch() {
        this.m_result = new HashMap<String, String>();
        ServerClient sc = ServerClient.searchPolicies(this.m_searchText, this.m_properties);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            this.m_result = (Map)sc.getResultObject();
            if (this.m_result != null && this.m_result.size() > 0) {
                RTLogger.print(5, "*** Search Policy: " + this.m_result.size() + " matches!");
            } else {
                RTLogger.print(5, "*** Search Policy:  No policies found");
            }
        } else {
            RTLogger.print(5, "*** Search Policy: Error searching policies - searchText=" + this.m_searchText);
        }
    }

    public Map<String, String> getResult() {
        return this.m_result;
    }
}

