/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;

public class SelectBinaryInTreeAction
extends Action {
    private String m_name = null;

    public SelectBinaryInTreeAction(String name) {
        super("selectbinaryintree");
        this.setId("selectbinaryintree");
        this.setText("Select Package in Tree");
        if (name == null || name.length() == 0 || Repository.getInstance().getRights(1006) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_name = name;
    }

    public SelectBinaryInTreeAction(GroupTreeObject gtol) {
        super("selectbinaryintree");
        this.setId("selectbinaryintree");
        this.setText("Select Package in Tree");
        if (gtol == null || Repository.getInstance().getRights(1006) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_name = gtol.getName();
        if (this.m_name == null || this.m_name.length() == 0) {
            this.setEnabled(false);
        }
    }

    public SelectBinaryInTreeAction(TableViewer tableViewer) {
        super("selectbinaryintree");
        this.setId("selectbinaryintree");
        this.setText("Select Package in Tree");
        if (tableViewer == null || Repository.getInstance().getRights(1006) <= 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)tableViewer.getSelection();
        if (!sel.isEmpty() && sel.size() == 1) {
            String type;
            Assignment asn;
            Object selected = sel.getFirstElement();
            if (selected != null && selected instanceof String[]) {
                String[] item = (String[])selected;
                this.m_name = item[1];
            } else if (selected != null && selected instanceof Assignment && (asn = (Assignment)selected) != null && (type = asn.getType()) != null && type.equals("pkg")) {
                this.m_name = asn.getName();
            }
        }
        if (this.m_name == null || this.m_name.length() == 0) {
            this.setEnabled(false);
        }
    }

    public SelectBinaryInTreeAction(TreeViewer treeViewer) {
        super("selectbinaryintree");
        Object selected;
        this.setId("selectbinaryintree");
        this.setText("Select Package in Tree");
        if (treeViewer == null || Repository.getInstance().getRights(1006) <= 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
        if (!sel.isEmpty() && sel.size() == 1 && (selected = sel.getFirstElement()) != null && selected instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
            this.m_name = gtol.getName();
        }
        if (this.m_name == null || this.m_name.length() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        GroupTreeObject root_binary = Repository.getInstance().getBinaryTree();
        GroupTreeObject gto_binary = root_binary.findFirstGroupByName(this.m_name);
        if (gto_binary != null) {
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)BinariesListView.getInstance());
            Repository.getInstance().setBinariesTreeSelection(this.m_name);
        }
    }
}

