/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;

public class SelectNodeGroupInTreeAction
extends Action {
    private String m_path = null;

    public SelectNodeGroupInTreeAction(String path) {
        super("selectnodegroupintree");
        this.setId("selectnodegroupintree");
        this.setText("Select NodeGroup in Tree");
        if (path == null || path.length() == 0 || Repository.getInstance().getRights(1002) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_path = path;
    }

    public SelectNodeGroupInTreeAction(GroupTreeObject gto) {
        super("selectnodegroupintree");
        this.setId("selectnodegroupintree");
        this.setText("Select NodeGroup in Tree");
        if (gto == null || Repository.getInstance().getRights(1002) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_path = gto.getPath();
        if (this.m_path == null || this.m_path.length() == 0) {
            this.setEnabled(false);
        }
    }

    public SelectNodeGroupInTreeAction(TreeViewer treeViewer) {
        super("selectnodegroupintree");
        Object selected;
        this.setId("selectnodegroupintree");
        this.setText("Select NodeGroup in Tree");
        if (treeViewer == null || Repository.getInstance().getRights(1002) <= 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
        if (!sel.isEmpty() && sel.size() == 1 && (selected = sel.getFirstElement()) != null && !(selected instanceof GroupTreeObjectLast)) {
            GroupTreeObject gto = (GroupTreeObject)selected;
            this.m_path = gto.getPath();
        }
        if (this.m_path == null || this.m_path.length() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_path == null || this.m_path.length() == 0) {
            return;
        }
        GroupTreeObject root_node = (GroupTreeObject)NodeListView.getInstance().getTreeViewer().getInput();
        GroupTreeObject ng = root_node.searchPath(this.m_path, "");
        if (ng != null) {
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)NodeListView.getInstance());
            NodeListView.setTreeSelectionAgentLink(this.m_path, null);
        }
    }
}

