/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObjectLast;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;

public class SelectPolicyInTreeAction
extends Action {
    private String m_name = null;
    private String m_type = null;

    public SelectPolicyInTreeAction(String name, String type) {
        super("selectpolicyintree");
        this.setId("selectpolicyintree");
        this.setText("Select Policy in Tree");
        if (name == null || name.length() == 0 || type == null || type.length() == 0 || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_name = name;
        this.m_type = type;
        if (this.m_name == null || this.m_type == null) {
            this.setEnabled(false);
        }
    }

    public SelectPolicyInTreeAction(GroupTreeObjectLast gtol) {
        super("selectpolicyintree");
        this.setId("selectpolicyintree");
        this.setText("Select Policy in Tree");
        if (gtol == null || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_name = gtol.getName();
        this.m_type = gtol.getType();
        if (this.m_name == null || this.m_type == null) {
            this.setEnabled(false);
        }
    }

    public SelectPolicyInTreeAction(TreeViewer treeViewer) {
        super("selectpolicyintree");
        Object selected;
        this.setId("selectpolicyintree");
        this.setText("Select Policy in Tree");
        if (treeViewer == null || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
        if (!sel.isEmpty() && sel.size() == 1 && (selected = sel.getFirstElement()) != null && selected instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
            this.m_name = gtol.getName();
            this.m_type = gtol.getType();
        }
        if (this.m_name == null || this.m_type == null) {
            this.setEnabled(false);
        }
    }

    public SelectPolicyInTreeAction(TableViewer tableViewer) {
        super("selectpolicyintree");
        this.setId("selectpolicyintree");
        this.setText("Select Policy in Tree");
        if (tableViewer == null || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)tableViewer.getSelection();
        if (!sel.isEmpty() && sel.size() == 1) {
            GroupTreeObjectLast gtol;
            String type;
            Assignment asn;
            Object selected = sel.getFirstElement();
            if (selected != null && selected instanceof String[]) {
                String[] item = (String[])selected;
                this.m_name = item[1];
                this.m_type = item[0];
            } else if (selected != null && selected instanceof Assignment && (asn = (Assignment)selected) != null && (type = asn.getType()) != null && (type.equals("mon") || type.equals("msg")) && (gtol = PolicyManager.getInstance().getPolicyTree().findElement(asn.getName(), type)) != null) {
                this.m_name = gtol.getName();
                this.m_type = gtol.getType();
            }
        }
        if (this.m_name == null || this.m_type == null) {
            this.setEnabled(false);
        }
    }

    public SelectPolicyInTreeAction(Assignment asn) {
        super("selectpolicyintree");
        GroupTreeObjectLast gtol;
        this.setId("selectpolicyintree");
        this.setText("Select Policy in Tree");
        if (asn == null || Repository.getInstance().getRights(1001) <= 1) {
            this.setEnabled(false);
            return;
        }
        String type = asn.getType();
        if (type != null && (type.equals("mon") || type.equals("msg")) && (gtol = PolicyManager.getInstance().getPolicyTree().findElement(asn.getName(), type)) != null) {
            this.m_name = gtol.getName();
            this.m_type = gtol.getType();
        }
        if (this.m_name == null || this.m_type == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_name == null || this.m_name.length() == 0 || this.m_type == null || this.m_type.length() == 0) {
            return;
        }
        try {
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)PolicyListView.getInstance());
            PolicyTreeProvider.getInstance().setTreeSelection(this.m_name, this.m_type);
        }
        catch (Throwable throwable) {}
    }
}

