/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.MultilineInputDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class SendMessageAction
extends Action {
    String m_toUser = null;

    public SendMessageAction(String toUser) {
        this.m_toUser = toUser;
        if (this.m_toUser == null) {
            this.setEnabled(false);
        }
    }

    public SendMessageAction() {
        this.m_toUser = "";
    }

    public String getId() {
        return "send.msg.all";
    }

    public String getText() {
        return "Send a Message...";
    }

    public boolean isEnabled() {
        return Repository.getInstance().getRights(1004) >= 2 && this.m_toUser != null;
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        String to = this.m_toUser;
        ArrayList<Object> users = new ArrayList<String>(0);
        users.add(to);
        if (this.m_toUser.equals("")) {
            users = new ArrayList<String>(Repository.getInstance().getUserManager().getConnectedUsers());
            users.remove(Repository.m_user);
            if (users.size() == 0) {
                new ShowMessageBox("   Send a Message", "There are no users online!", 2);
                return;
            }
            to = "To all connected users: " + users;
        }
        MultilineInputDialog sd = new MultilineInputDialog(Display.getCurrent().getActiveShell(), "   Send a message", to, "", null);
        sd.setOKButtonText("Send");
        sd.setBlockOnOpen(true);
        sd.setOKButtonEnabled(users.size() > 0);
        int res = sd.open();
        if (res == 0) {
            String message = sd.getValue().trim();
            String[] arr = new String[]{this.m_toUser, message};
            ServerClient sc = new ServerClient("SEND_CMD", "SHOW_MESSAGE", arr);
            Repository.getJobManager().schedule(sc);
        }
    }
}

