/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.ServerJobTab;
import com.blixx.boom.gui.views.ServerJobsView;
import com.blixx.log.RTLogger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabItem;

public class ServerJobTriggerOnceAction
extends Action {
    private String jobName = null;

    public ServerJobTriggerOnceAction(ServerJobsView serverJobView, TableViewer tableViewer) {
        super("runonce");
        String[] row;
        this.setId("runonce");
        this.setText("Run once");
        if (serverJobView == null || tableViewer == null || serverJobView.m_rights < 3) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection sel = (StructuredSelection)tableViewer.getSelection();
        if (!sel.isEmpty() && (row = (String[])sel.getFirstElement()).length > 0) {
            this.jobName = row[0];
        }
        if (this.jobName == null || "".equals(this.jobName)) {
            this.setEnabled(false);
            return;
        }
    }

    public ServerJobTriggerOnceAction(ServerJobsView serverJobView, String jobName) {
        super("runonce");
        this.setId("runonce");
        this.setText("Run once");
        if (serverJobView == null || jobName == null || "".equals(jobName) || serverJobView.m_rights < 3) {
            this.setEnabled(false);
            return;
        }
        this.jobName = jobName;
    }

    public void run() {
        if (this.jobName != null && this.jobName.length() > 0) {
            ServerClient sc = new ServerClient("SJOBS_TRIGGER", this.jobName, new String[0]);
            sc.runInUIThread(null);
            if (sc.isSuccess()) {
                CTabItem cTab;
                if (ServerJobsView.isTabOpen(this.jobName) && (cTab = ServerJobsView.getTab(this.jobName)) instanceof ServerJobTab) {
                    ((ServerJobTab)cTab).refresh();
                }
            } else {
                String error = (String)sc.getResultObject();
                new ShowMessageBox("Error getting configuration", error, 33);
                RTLogger.print(6, "Error getting sjob configuration " + error);
            }
        }
    }
}

